/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.virtualmap.internal.pipeline;

import com.swirlds.base.function.CheckedSupplier;
import com.swirlds.common.threading.framework.config.ThreadConfiguration;
import com.swirlds.common.threading.manager.AdHocThreadManager;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.metrics.api.Metrics;
import com.swirlds.virtualmap.config.VirtualMapConfig;
import com.swirlds.virtualmap.internal.merkle.VirtualMapStatistics;
import com.swirlds.virtualmap.internal.pipeline.PipelineList;
import com.swirlds.virtualmap.internal.pipeline.PipelineListNode;
import com.swirlds.virtualmap.internal.pipeline.VirtualRoot;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VirtualPipeline {
    private static final String PIPELINE_COMPONENT = "virtual-pipeline";
    private static final String PIPELINE_THREAD_NAME = "lifecycle";
    private static final Logger logger = LogManager.getLogger(VirtualPipeline.class);
    private final PipelineList<VirtualRoot> copies;
    private final AtomicInteger undestroyedCopies = new AtomicInteger();
    private final ConcurrentLinkedDeque<VirtualRoot> unhashedCopies;
    private final AtomicReference<VirtualRoot> mostRecentCopy = new AtomicReference();
    private volatile boolean alive;
    private final ExecutorService executorService;
    private final AtomicBoolean workScheduled = new AtomicBoolean(false);
    private final VirtualMapConfig config;
    private final VirtualMapStatistics statistics;

    public VirtualPipeline(@NonNull VirtualMapConfig config, @NonNull String label) {
        this.config = Objects.requireNonNull(config);
        this.copies = new PipelineList();
        this.unhashedCopies = new ConcurrentLinkedDeque();
        this.alive = true;
        this.executorService = Executors.newSingleThreadExecutor(((ThreadConfiguration)((ThreadConfiguration)((ThreadConfiguration)new ThreadConfiguration(AdHocThreadManager.getStaticThreadManager()).setComponent(PIPELINE_COMPONENT)).setThreadName(PIPELINE_THREAD_NAME)).setExceptionHandler((t, ex) -> logger.error(LogMarker.EXCEPTION.getMarker(), "Uncaught exception ", ex))).buildFactory());
        this.statistics = new VirtualMapStatistics(label);
    }

    public void registerMetrics(Metrics metrics) {
        this.statistics.registerMetrics(metrics);
    }

    private void validatePipelineRegistration(VirtualRoot copy) {
        if (!copy.isRegisteredToPipeline(this)) {
            throw new IllegalStateException("copy is not registered with this pipeline");
        }
    }

    private void applyFamilySizeBackpressure() {
        long sleepTimeMillis = this.calculateFamilySizeBackpressurePause();
        if (sleepTimeMillis <= 0L) {
            return;
        }
        try {
            long timeSleptSoFar;
            long currentSleepTimeMillis;
            long sleepStartTime = System.currentTimeMillis();
            do {
                TimeUnit.MILLISECONDS.sleep(1L);
                timeSleptSoFar = System.currentTimeMillis() - sleepStartTime;
            } while ((currentSleepTimeMillis = this.calculateFamilySizeBackpressurePause()) > 0L && timeSleptSoFar < currentSleepTimeMillis && timeSleptSoFar < sleepTimeMillis);
            logger.info(LogMarker.VIRTUAL_MERKLE_STATS.getMarker(), "Total size backpressure: {} ms", (Object)timeSleptSoFar);
            this.statistics.recordFamilySizeBackpressureMs((int)timeSleptSoFar);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    long calculateFamilySizeBackpressurePause() {
        long sizeThreshold = this.config.familyThrottleThreshold();
        if (sizeThreshold <= 0L) {
            return 0L;
        }
        long totalSize = this.currentTotalSize();
        double ratio = (double)totalSize / (double)sizeThreshold;
        int over100percentExcess = (int)Math.round((ratio - 1.0) * 100.0);
        if (over100percentExcess <= 0) {
            return 0L;
        }
        return (long)over100percentExcess * (long)over100percentExcess;
    }

    public void registerCopy(VirtualRoot copy) {
        Objects.requireNonNull(copy);
        if (copy.isImmutable()) {
            throw new IllegalStateException("Only mutable copies may be registered");
        }
        if (this.isAlreadyRegistered(copy)) {
            logger.info(LogMarker.VIRTUAL_MERKLE_STATS.getMarker(), "Virtual root copy is already registered in the pipeline");
            return;
        }
        logger.debug(LogMarker.VIRTUAL_MERKLE_STATS.getMarker(), "Register copy {}", (Object)copy.getFastCopyVersion());
        this.undestroyedCopies.getAndIncrement();
        this.copies.add(copy);
        if (!copy.isHashed()) {
            assert (!this.unhashedCopies.contains(copy));
            this.unhashedCopies.add(copy);
        }
        this.mostRecentCopy.set(copy);
        this.statistics.setPipelineSize(this.copies.getSize());
        this.applyFamilySizeBackpressure();
    }

    public synchronized void terminate() {
        if (!this.alive) {
            return;
        }
        this.pausePipelineAndExecute("terminate", () -> {
            this.shutdown(false);
            return null;
        });
    }

    public synchronized void destroyCopy(VirtualRoot copy) {
        if (!this.alive) {
            return;
        }
        logger.debug(LogMarker.VIRTUAL_MERKLE_STATS.getMarker(), "Destroy copy {}", (Object)copy.getFastCopyVersion());
        int remainingCopies = this.undestroyedCopies.decrementAndGet();
        if (remainingCopies < 0) {
            throw new IllegalStateException("copies destroyed too many times");
        }
        if (remainingCopies == 0) {
            this.shutdown(false);
        } else {
            this.scheduleWork();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hashCopy(VirtualRoot copy) {
        VirtualRoot unhashedCopy;
        this.validatePipelineRegistration(copy);
        while ((unhashedCopy = this.unhashedCopies.peekFirst()) != null) {
            VirtualRoot virtualRoot = unhashedCopy;
            synchronized (virtualRoot) {
                if (copy.isHashed()) {
                    return;
                }
                if (!unhashedCopy.isHashed()) {
                    unhashedCopy.computeHash();
                }
                assert (unhashedCopy.isHashed());
                this.unhashedCopies.remove(unhashedCopy);
            }
        }
        if (!copy.isHashed()) {
            throw new IllegalStateException("failed to hash copy");
        }
    }

    public <T, E extends Exception> T pausePipelineAndRun(String label, CheckedSupplier<T, E> action) throws E {
        T ret = this.pausePipelineAndExecute(label, action);
        if (this.alive) {
            this.scheduleWork();
        }
        return ret;
    }

    private void scheduleWork() {
        if (this.workScheduled.compareAndSet(false, true)) {
            this.executorService.submit(this::doWork);
        }
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.executorService.awaitTermination(timeout, unit);
    }

    private boolean shouldBeFlushed(VirtualRoot copy) {
        return copy.shouldBeFlushed() && (copy.isDestroyed() || copy.isDetached());
    }

    private long currentTotalSize() {
        VirtualRoot copy;
        long totalEstimatedSize = 0L;
        for (PipelineListNode<VirtualRoot> node = this.copies.getFirst(); node != null && (copy = node.getValue()).isImmutable(); node = node.getNext()) {
            long estimatedSize = copy.estimatedSize();
            totalEstimatedSize += estimatedSize;
        }
        return totalEstimatedSize;
    }

    private void flush(VirtualRoot copy) {
        if (copy.isFlushed()) {
            throw new IllegalStateException("copy is already flushed");
        }
        if (!copy.isHashed()) {
            this.hashCopy(copy);
        }
        copy.flush();
    }

    private boolean canBeMerged(PipelineListNode<VirtualRoot> mergeCandidate) {
        VirtualRoot copy = mergeCandidate.getValue();
        PipelineListNode<VirtualRoot> mergeTarget = mergeCandidate.getNext();
        return !copy.shouldBeFlushed() && (copy.isDestroyed() || copy.isDetached()) && mergeTarget != null && mergeTarget.getValue().isImmutable();
    }

    private void merge(PipelineListNode<VirtualRoot> node) {
        VirtualRoot next;
        VirtualRoot copy = node.getValue();
        if (copy.isMerged()) {
            throw new IllegalStateException("copy is already merged");
        }
        if (!copy.isHashed()) {
            this.hashCopy(copy);
        }
        if (!(next = node.getNext().getValue()).isHashed()) {
            this.hashCopy(next);
        }
        copy.merge();
    }

    private void hashFlushMerge() {
        VirtualRoot copy;
        for (PipelineListNode<VirtualRoot> next = this.copies.getFirst(); next != null && !Thread.currentThread().isInterrupted() && (copy = next.getValue()).isImmutable(); next = next.getNext()) {
            if (next == this.copies.getFirst() && this.shouldBeFlushed(copy)) {
                logger.debug(LogMarker.VIRTUAL_MERKLE_STATS.getMarker(), "Flush {}", (Object)copy.getFastCopyVersion());
                this.flush(copy);
                this.copies.remove(next);
            } else if (this.canBeMerged(next)) {
                assert (!copy.isMerged());
                logger.debug(LogMarker.VIRTUAL_MERKLE_STATS.getMarker(), "Merge {}", (Object)copy.getFastCopyVersion());
                this.merge(next);
                this.copies.remove(next);
            }
            this.statistics.setPipelineSize(this.copies.getSize());
            logger.debug(LogMarker.VIRTUAL_MERKLE_STATS.getMarker(), "Pipeline size {}", (Object)this.copies.getSize());
            long totalSize = this.currentTotalSize();
            logger.debug(LogMarker.VIRTUAL_MERKLE_STATS.getMarker(), "Total size {}", (Object)totalSize);
            this.statistics.setNodeCacheSize(totalSize);
        }
    }

    private void doWork() {
        this.workScheduled.set(false);
        try {
            this.hashFlushMerge();
        }
        catch (Throwable e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "exception on virtual pipeline thread", e);
            this.shutdown(true);
        }
    }

    private synchronized void shutdown(boolean immediately) {
        this.alive = false;
        if (!this.executorService.isShutdown()) {
            if (immediately) {
                this.executorService.shutdownNow();
                this.fireOnShutdown(immediately);
            } else {
                this.executorService.submit(() -> this.fireOnShutdown(false));
                this.executorService.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <V, E extends Exception> V pausePipelineAndExecute(String label, CheckedSupplier<V, E> supplier) throws E {
        Objects.requireNonNull(supplier);
        CountDownLatch waitForBackgroundThreadToStart = new CountDownLatch(1);
        CountDownLatch waitForRunnableToFinish = new CountDownLatch(1);
        this.executorService.execute(() -> {
            waitForBackgroundThreadToStart.countDown();
            try {
                waitForRunnableToFinish.await();
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("Fatal error: interrupted while waiting for runnable " + label + " to finish");
            }
        });
        try {
            waitForBackgroundThreadToStart.await();
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Fatal error: failed to start " + label);
        }
        try {
            Object object = supplier.get();
            return (V)object;
        }
        finally {
            waitForRunnableToFinish.countDown();
        }
    }

    public boolean isTerminated() {
        return !this.alive;
    }

    private void fireOnShutdown(boolean immediately) {
        VirtualRoot copy = this.mostRecentCopy.get();
        if (copy != null) {
            copy.onShutdown(immediately);
        }
    }

    private static String uppercaseBoolean(boolean value) {
        return value ? "TRUE" : "FALSE";
    }

    public void logDebugInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append("Virtual pipeline dump, ");
        sb.append("  size = ").append(this.copies.getSize()).append("\n");
        sb.append("Copies listed oldest to newest:\n");
        int index = 0;
        for (PipelineListNode<VirtualRoot> next = this.copies.getFirst(); next != null; next = next.getNext()) {
            VirtualRoot copy = next.getValue();
            sb.append(index);
            sb.append(", flushed = ").append(VirtualPipeline.uppercaseBoolean(copy.isFlushed()));
            sb.append(", flushed = ").append(VirtualPipeline.uppercaseBoolean(copy.isMerged()));
            sb.append(", destroyed = ").append(VirtualPipeline.uppercaseBoolean(copy.isDestroyed()));
            sb.append(", hashed = ").append(VirtualPipeline.uppercaseBoolean(copy.isHashed()));
            sb.append(", detached = ").append(VirtualPipeline.uppercaseBoolean(copy.isDetached()));
            sb.append("\n");
            ++index;
        }
        sb.append("There is no problem if this has happened during a freeze.\n");
        logger.info(LogMarker.VIRTUAL_MERKLE_STATS.getMarker(), "{}", (Object)sb);
    }

    private boolean isAlreadyRegistered(VirtualRoot copy) {
        return !this.copies.testAll(c -> !copy.equals(c));
    }
}

