/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.base.io.exceptions;

import java.io.IOException;
import org.hiero.base.io.SerializableDet;

public class InvalidVersionException
extends IOException {
    public InvalidVersionException(int expectedVersion, int version) {
        super(String.format("Illegal version %d was read from the stream. Expected %d", version, expectedVersion));
    }

    public InvalidVersionException(int minimumVersion, int maximumVersion, int version) {
        super(String.format("Illegal version %d was read from the stream. Expected version in the range %d - %d", version, minimumVersion, maximumVersion));
    }

    public InvalidVersionException(int version, SerializableDet object) {
        super(String.format("Illegal version %d was read from the stream for %s (class ID %d(0x%08X)). Expected version in the range %d - %d", version, object.getClass(), object.getClassId(), object.getClassId(), object.getMinimumSupportedVersion(), object.getVersion()));
    }
}

