/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.test.fixtures.event.source;

import com.swirlds.common.test.fixtures.TransactionGenerator;
import com.swirlds.platform.internal.EventImpl;
import com.swirlds.platform.test.fixtures.event.source.AbstractEventSource;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;

public class ForkingEventSource
extends AbstractEventSource {
    private int maximumBranchCount;
    private double forkProbability;
    private List<LinkedList<EventImpl>> branches;
    private int currentBranch;

    public ForkingEventSource() {
        this(true, DEFAULT_TRANSACTION_GENERATOR);
    }

    public ForkingEventSource(boolean useFakeHashes) {
        this(useFakeHashes, DEFAULT_TRANSACTION_GENERATOR);
    }

    public ForkingEventSource(boolean useFakeHashes, TransactionGenerator transactionGenerator) {
        super(useFakeHashes, transactionGenerator);
        this.maximumBranchCount = 3;
        this.forkProbability = 0.01;
        this.setMaximumBranchCount(this.maximumBranchCount);
    }

    private ForkingEventSource(ForkingEventSource that) {
        super(that);
        this.setMaximumBranchCount(that.maximumBranchCount);
        this.forkProbability = that.forkProbability;
    }

    public int getMaximumBranchCount() {
        return this.maximumBranchCount;
    }

    public ForkingEventSource setMaximumBranchCount(int maximumBranchCount) {
        if (maximumBranchCount < 1) {
            throw new IllegalArgumentException("Requires at least one branch");
        }
        this.maximumBranchCount = maximumBranchCount;
        this.branches = new ArrayList<LinkedList<EventImpl>>(maximumBranchCount);
        return this;
    }

    public double getForkProbability() {
        return this.forkProbability;
    }

    public ForkingEventSource setForkProbability(double forkProbability) {
        this.forkProbability = forkProbability;
        return this;
    }

    @Override
    public ForkingEventSource copy() {
        return new ForkingEventSource(this);
    }

    @Override
    public void reset() {
        super.reset();
        this.branches = new ArrayList<LinkedList<EventImpl>>(this.maximumBranchCount);
    }

    @Override
    public EventImpl getRecentEvent(Random random, int index) {
        if (this.branches.isEmpty()) {
            return null;
        }
        this.currentBranch = random.nextInt(this.branches.size());
        LinkedList<EventImpl> events = this.branches.get(this.currentBranch);
        if (events.size() == 0) {
            return null;
        }
        if (index >= events.size()) {
            return events.getLast();
        }
        return events.get(index);
    }

    private boolean shouldFork(Random random) {
        return this.maximumBranchCount > 1 && random.nextDouble() < this.forkProbability;
    }

    private void fork(Random random) {
        if (this.branches.size() < this.maximumBranchCount) {
            this.currentBranch = this.branches.size();
            this.branches.add(new LinkedList());
        } else {
            int newEventIndex;
            while ((newEventIndex = random.nextInt(this.branches.size())) == this.currentBranch) {
            }
            this.currentBranch = newEventIndex;
        }
    }

    @Override
    public void setLatestEvent(Random random, EventImpl event) {
        if (this.shouldFork(random)) {
            this.fork(random);
        }
        if (this.branches.size() == 0) {
            this.branches.add(new LinkedList());
            this.currentBranch = 0;
        }
        LinkedList<EventImpl> branch = this.branches.get(this.currentBranch);
        branch.addFirst(event);
        this.pruneEventList(branch);
    }

    public List<LinkedList<EventImpl>> getBranches() {
        return this.branches;
    }
}

