/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.merkle.utility;

import com.swirlds.common.FastCopyable;
import java.io.IOException;
import java.util.Objects;
import org.hiero.base.io.SelfSerializable;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.base.io.streams.SerializableDataOutputStream;

public class SerializableLong
implements Comparable<SerializableLong>,
FastCopyable,
SelfSerializable {
    public static final long CLASS_ID = 8133160492230511558L;
    private long value;

    public SerializableLong(long value) {
        this.value = value;
    }

    public SerializableLong() {
    }

    public SerializableLong copy() {
        return new SerializableLong(this.value);
    }

    @Override
    public int compareTo(SerializableLong that) {
        return Long.compare(this.value, that.value);
    }

    public long getValue() {
        return this.value;
    }

    public long getAndIncrement() {
        return this.value++;
    }

    public long getAndDecrement() {
        return this.value--;
    }

    public void serialize(SerializableDataOutputStream out) throws IOException {
        out.writeLong(this.value);
    }

    public void deserialize(SerializableDataInputStream in, int version) throws IOException {
        this.value = in.readLong();
    }

    public long getClassId() {
        return 8133160492230511558L;
    }

    public int getVersion() {
        return 1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SerializableLong)) {
            return false;
        }
        SerializableLong that = (SerializableLong)o;
        return this.value == that.value;
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return Long.toString(this.value);
    }

    private static class ClassVersion {
        public static final int ORIGINAL = 1;

        private ClassVersion() {
        }
    }
}

