/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.iss;

import com.swirlds.demo.iss.PlannedIncident;
import com.swirlds.logging.legacy.LogMarker;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.io.SelfSerializable;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.base.io.streams.SerializableDataOutputStream;
import org.hiero.consensus.model.node.NodeId;

public class PlannedIss
implements SelfSerializable,
PlannedIncident {
    private static final Logger logger = LogManager.getLogger(PlannedIss.class);
    private static final long CLASS_ID = 802925871424763245L;
    private Duration timeAfterGenesis;
    private List<List<NodeId>> hashPartitions = new ArrayList<List<NodeId>>();

    public PlannedIss() {
    }

    public PlannedIss(Duration timeAfterGenesis, List<List<NodeId>> hashPartitions) {
        this.timeAfterGenesis = timeAfterGenesis;
        this.hashPartitions = hashPartitions;
    }

    public long getClassId() {
        return 802925871424763245L;
    }

    public int getVersion() {
        return 1;
    }

    public void serialize(SerializableDataOutputStream out) throws IOException {
        out.writeLong(this.timeAfterGenesis.toNanos());
        out.writeInt(this.hashPartitions.size());
        for (List<NodeId> partition : this.hashPartitions) {
            out.writeSerializableList(partition, false, true);
        }
    }

    public void deserialize(SerializableDataInputStream in, int version) throws IOException {
        this.timeAfterGenesis = Duration.ofNanos(in.readLong());
        this.hashPartitions.clear();
        int partitionCount = in.readInt();
        for (int partitionIndex = 0; partitionIndex < partitionCount; ++partitionIndex) {
            this.hashPartitions.add(in.readSerializableList(1024, false, NodeId::new));
        }
    }

    @Override
    @NonNull
    public Duration getTimeAfterGenesis() {
        return this.timeAfterGenesis;
    }

    @Override
    @NonNull
    public String getDescriptor() {
        return "ISS";
    }

    public int getPartitionCount() {
        return this.hashPartitions.size();
    }

    public int getPartitionOfNode(@NonNull NodeId nodeId) {
        Objects.requireNonNull(nodeId);
        for (int partitionIndex = 0; partitionIndex < this.hashPartitions.size(); ++partitionIndex) {
            List<NodeId> partition = this.hashPartitions.get(partitionIndex);
            for (NodeId partitionNode : partition) {
                if (!nodeId.equals((Object)partitionNode)) continue;
                return partitionIndex;
            }
        }
        return -1;
    }

    @NonNull
    public static PlannedIss fromString(@NonNull String plannedIssString) {
        String[] timestampAndPartitionsStrings = plannedIssString.strip().split(":");
        int elapsedTime = Integer.parseInt(timestampAndPartitionsStrings[0]);
        String partitionsString = timestampAndPartitionsStrings[1];
        String[] partitionStrings = partitionsString.split("-");
        HashSet<NodeId> uniqueNodeIds = new HashSet<NodeId>();
        ArrayList<List<NodeId>> partitions = new ArrayList<List<NodeId>>(partitionStrings.length);
        for (String partitionString : partitionStrings) {
            String[] nodeStrings = partitionString.split("\\+");
            ArrayList<NodeId> nodes = new ArrayList<NodeId>();
            for (String nodeString : nodeStrings) {
                NodeId nodeId = NodeId.of((long)Long.parseLong(nodeString));
                nodes.add(nodeId);
                if (uniqueNodeIds.add(nodeId)) continue;
                logger.error(LogMarker.EXCEPTION.getMarker(), "Node {} appears more than once in ISS description!", (Object)nodeId);
            }
            partitions.add(nodes);
        }
        return new PlannedIss(Duration.ofSeconds(elapsedTime), partitions);
    }

    private static final class ClassVersion {
        public static final int ORIGINAL = 1;

        private ClassVersion() {
        }
    }
}

