/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.logging.utils;

import com.swirlds.config.api.Configuration;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;

@Deprecated(forRemoval=true)
public class ConfigUtils {
    private ConfigUtils() {
    }

    @NonNull
    public static <T> T configValueOrElse(@NonNull Configuration configuration, @NonNull String propertyName, @NonNull Class<T> propertyType, @NonNull T orElseValue) {
        Objects.requireNonNull(orElseValue, "orElseValue must not be null");
        return (T)Objects.requireNonNullElse(configuration.getValue(propertyName, propertyType, null), orElseValue);
    }

    @Nullable
    public static Long readDataSizeInBytes(@NonNull Configuration configuration, @NonNull String propertyName) {
        Objects.requireNonNull(configuration, "configuration must not be null");
        Objects.requireNonNull(propertyName, "propertyName must not be null");
        String propertyValue = (String)configuration.getValue(propertyName, String.class, null);
        if (propertyValue == null || propertyValue.isBlank()) {
            return null;
        }
        return DataSize.parseFrom(propertyValue).asBytes();
    }

    public record DataSize(long value, DataUnit unit) {
        @NonNull
        public static DataSize parseFrom(@NonNull String value) {
            String result = value.replaceAll("\\s", "").toLowerCase();
            DataUnit unit = switch (result.charAt(result.length() - 2)) {
                case 'k' -> DataUnit.KILO_BYTE;
                case 'm' -> DataUnit.MEGA_BYTE;
                case 'g' -> DataUnit.GIGA_BYTE;
                case 't' -> DataUnit.TERA_BYTE;
                default -> DataUnit.BYTE;
            };
            return new DataSize(unit.getValueFromString(result), unit);
        }

        public long asBytes() {
            return this.unit.convertToBytes(this.value);
        }
    }

    public static enum DataUnit {
        BYTE(""),
        KILO_BYTE("kb"),
        MEGA_BYTE("mb"),
        GIGA_BYTE("gb"),
        TERA_BYTE("tb");

        final String symbol;

        private DataUnit(String symbol) {
            this.symbol = symbol;
        }

        public long convertToBytes(long value) {
            return value * (long)Math.pow(1024.0, this.ordinal());
        }

        public double convertFromBytes(double value) {
            return value / Math.pow(1024.0, this.ordinal());
        }

        public double convertTo(DataUnit targetUnit, long value) {
            return targetUnit.convertFromBytes(this.convertToBytes(value));
        }

        public String getSymbol() {
            return this.symbol;
        }

        public long getValueFromString(String value) {
            String result = value.replaceAll("\\s", "");
            return Long.parseLong(result.substring(0, result.length() - this.symbol.length()));
        }
    }
}

