/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.reconnect;

import com.swirlds.common.merkle.crypto.MerkleCryptography;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.logging.legacy.payload.ReconnectFailurePayload;
import com.swirlds.platform.network.Connection;
import com.swirlds.platform.reconnect.ReconnectException;
import com.swirlds.state.MerkleNodeState;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ReconnectUtils {
    private static final Logger logger = LogManager.getLogger(ReconnectUtils.class);
    private static final long END_RECONNECT_MSG = 8595038238444960609L;

    private ReconnectUtils() {
    }

    static void endReconnectHandshake(@NonNull Connection connection) throws IOException {
        connection.getDos().writeLong(8595038238444960609L);
        connection.getDos().flush();
        long endReconnectMsg = connection.getDis().readLong();
        if (endReconnectMsg != 8595038238444960609L) {
            throw new IOException("Did not receive expected end reconnect message. Expecting %x, Received %x".formatted(8595038238444960609L, endReconnectMsg));
        }
    }

    static void hashStateForReconnect(MerkleCryptography merkleCryptography, MerkleNodeState workingState) {
        try {
            merkleCryptography.digestTreeAsync(workingState.getRoot()).get();
        }
        catch (ExecutionException e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), () -> new ReconnectFailurePayload("Error encountered while hashing state for reconnect", ReconnectFailurePayload.CauseOfFailure.ERROR).toString(), (Throwable)e);
            throw new ReconnectException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.error(LogMarker.EXCEPTION.getMarker(), () -> new ReconnectFailurePayload("Interrupted while attempting to hash state", ReconnectFailurePayload.CauseOfFailure.ERROR).toString(), (Throwable)e);
        }
    }
}

