/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.test.fixtures.event.emitter;

import com.hedera.hapi.node.state.roster.Roster;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.platform.test.fixtures.event.emitter.ShuffledEventEmitter;
import com.swirlds.platform.test.fixtures.event.emitter.StandardEventEmitter;
import com.swirlds.platform.test.fixtures.event.generator.StandardGraphGenerator;
import com.swirlds.platform.test.fixtures.event.source.EventSource;
import com.swirlds.platform.test.fixtures.event.source.EventSourceFactory;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import java.util.Objects;
import java.util.Random;

public class EventEmitterFactory {
    private final Random random;
    private final Roster roster;
    private final long commonSeed;
    private final PlatformContext platformContext;
    private final EventSourceFactory sourceFactory;

    public EventEmitterFactory(@NonNull PlatformContext platformContext, @NonNull Random random, @NonNull Roster roster) {
        this.random = Objects.requireNonNull(random);
        this.roster = Objects.requireNonNull(roster);
        this.commonSeed = random.nextLong();
        this.sourceFactory = new EventSourceFactory(roster.rosterEntries().size());
        this.platformContext = Objects.requireNonNull(platformContext);
    }

    public ShuffledEventEmitter newShuffledEmitter() {
        return this.newShuffledFromSourceFactory();
    }

    public StandardEventEmitter newStandardEmitter() {
        return this.newStandardFromSourceFactory();
    }

    public ShuffledEventEmitter newBranchingShuffledGenerator() {
        int numNetworkNodes = this.roster.rosterEntries().size();
        int maxNumBranchingSources = (int)Math.floor((double)numNetworkNodes / 3.0);
        this.sourceFactory.addCustomSource(index -> index < (long)maxNumBranchingSources, EventSourceFactory::newBranchingEventSource);
        return this.newShuffledFromSourceFactory();
    }

    public ShuffledEventEmitter newShuffledFromSourceFactory() {
        return this.newShuffledEmitter(this.sourceFactory.generateSources());
    }

    public StandardEventEmitter newStandardFromSourceFactory() {
        return new StandardEventEmitter(this.newStandardGraphGenerator(this.sourceFactory.generateSources()));
    }

    private StandardGraphGenerator newStandardGraphGenerator(List<EventSource> eventSources) {
        return new StandardGraphGenerator(this.platformContext, this.commonSeed, eventSources, this.roster);
    }

    private ShuffledEventEmitter newShuffledEmitter(List<EventSource> eventSources) {
        return new ShuffledEventEmitter(new StandardGraphGenerator(this.platformContext, this.commonSeed, eventSources), this.random.nextLong());
    }

    public EventSourceFactory getSourceFactory() {
        return this.sourceFactory;
    }
}

