/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.logging.legacy;

import com.swirlds.logging.legacy.FilterActionPair;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Predicate;

public abstract class SwirldsLogReader<T> {
    private final List<FilterActionPair<T>> actions = new LinkedList<FilterActionPair<T>>();

    protected abstract T readNextEntry() throws IOException;

    public List<T> collect(Predicate<T> filter) {
        return this.collect(filter, 10000);
    }

    public List<T> collect(Predicate<T> filter, int limit) {
        LinkedList matches = new LinkedList();
        this.addAction(filter, entry -> {
            if (matches.size() < limit) {
                matches.add(entry);
            }
        });
        return matches;
    }

    public AtomicInteger count(Predicate<T> filter) {
        AtomicInteger count = new AtomicInteger(0);
        this.addAction(filter, entry -> count.getAndIncrement());
        return count;
    }

    public void addAction(Predicate<T> filter, Consumer<T> action) {
        this.actions.add(new FilterActionPair<T>(filter, action));
    }

    public T nextEntry() throws IOException {
        return this.nextEntry(null);
    }

    public T nextEntry(Predicate<T> filter) throws IOException {
        T entry;
        do {
            if ((entry = this.readNextEntry()) == null) {
                return null;
            }
            for (FilterActionPair<T> action : this.actions) {
                action.handle(entry);
            }
        } while (filter != null && !filter.test(entry));
        return entry;
    }

    public void readFully() throws IOException {
        T entry;
        while ((entry = this.nextEntry()) != null) {
        }
    }
}

