/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.testreader;

import com.swirlds.platform.testreader.JrsTestIdentifier;
import com.swirlds.platform.testreader.TestStatus;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Instant;
import java.time.format.DateTimeParseException;

public record JrsTestResult(@NonNull JrsTestIdentifier id, @NonNull TestStatus status, @NonNull Instant timestamp, @NonNull String testDirectory) implements Comparable<JrsTestResult>
{
    @Nullable
    public static JrsTestResult parseFromCsvLine(@NonNull String line) {
        String[] parts = line.split(",");
        if (parts.length != 5) {
            return null;
        }
        try {
            return new JrsTestResult(new JrsTestIdentifier(parts[0], parts[1]), TestStatus.valueOf(parts[2]), Instant.parse(parts[3]), parts[4]);
        }
        catch (IllegalArgumentException | DateTimeParseException e) {
            return null;
        }
    }

    @NonNull
    public String toCsvLine() {
        return String.join((CharSequence)",", this.id.panel(), this.id.name(), this.status.name(), this.timestamp.toString(), this.testDirectory);
    }

    @Override
    public int compareTo(@NonNull JrsTestResult that) {
        return that.timestamp.compareTo(this.timestamp);
    }
}

