/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.token;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Duration;
import com.hedera.hapi.node.base.KeyList;
import com.hedera.hapi.node.token.codec.LiveHashJsonCodec;
import com.hedera.hapi.node.token.codec.LiveHashProtoCodec;
import com.hedera.hapi.node.token.schema.LiveHashSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownField;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public final class LiveHash {
    public static final Codec<LiveHash> PROTOBUF = new LiveHashProtoCodec();
    public static final JsonCodec<LiveHash> JSON = new LiveHashJsonCodec();
    public static final LiveHash DEFAULT = LiveHash.newBuilder().build();
    @Nullable
    private final AccountID accountId;
    @NonNull
    private final Bytes hash;
    @Nullable
    private final KeyList keys;
    @Nullable
    private final Duration duration;
    private int $hashCode = -1;
    private int $protobufEncodedSize = -1;
    private final List<UnknownField> $unknownFields;

    public LiveHash(AccountID accountId, Bytes hash, KeyList keys, Duration duration) {
        this.$unknownFields = null;
        this.accountId = accountId;
        this.hash = hash != null ? hash : Bytes.EMPTY;
        this.keys = keys;
        this.duration = duration;
    }

    public LiveHash(AccountID accountId, Bytes hash, KeyList keys, Duration duration, List<UnknownField> $unknownFields) {
        this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
        this.accountId = accountId;
        this.hash = hash != null ? hash : Bytes.EMPTY;
        this.keys = keys;
        this.duration = duration;
    }

    public AccountID accountId() {
        return this.accountId;
    }

    public Bytes hash() {
        return this.hash;
    }

    public KeyList keys() {
        return this.keys;
    }

    public Duration duration() {
        return this.duration;
    }

    @NonNull
    public List<UnknownField> getUnknownFields() {
        return this.$unknownFields == null ? Collections.EMPTY_LIST : this.$unknownFields;
    }

    public int protobufSize() {
        if (this.$protobufEncodedSize == -1) {
            int _size = 0;
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)LiveHashSchema.ACCOUNT_ID, (Object)this.accountId, AccountID.PROTOBUF);
            _size += ProtoWriterTools.sizeOfBytes((FieldDefinition)LiveHashSchema.HASH, (RandomAccessData)this.hash, (boolean)true);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)LiveHashSchema.KEYS, (Object)this.keys, KeyList.PROTOBUF);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)LiveHashSchema.DURATION, (Object)this.duration, Duration.PROTOBUF);
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    UnknownField uf = this.$unknownFields.get(i);
                    _size += ProtoWriterTools.sizeOfVarInt32((int)(uf.field() << 3 | uf.wireType().ordinal()));
                    _size += Math.toIntExact(uf.bytes().length());
                }
            }
            this.$protobufEncodedSize = _size;
        }
        return this.$protobufEncodedSize;
    }

    public int hashCode() {
        if (this.$hashCode == -1) {
            int result = 1;
            if (this.accountId != null && !this.accountId.equals(LiveHash.DEFAULT.accountId)) {
                result = 31 * result + this.accountId.hashCode();
            }
            if (this.hash != null && !this.hash.equals((Object)LiveHash.DEFAULT.hash)) {
                result = 31 * result + this.hash.hashCode();
            }
            if (this.keys != null && !this.keys.equals(LiveHash.DEFAULT.keys)) {
                result = 31 * result + this.keys.hashCode();
            }
            if (this.duration != null && !this.duration.equals(LiveHash.DEFAULT.duration)) {
                result = 31 * result + this.duration.hashCode();
            }
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    result = 31 * result + this.$unknownFields.get(i).hashCode();
                }
            }
            long hashCode = result;
            hashCode += hashCode << 30;
            hashCode ^= hashCode >>> 27;
            hashCode += hashCode << 16;
            hashCode ^= hashCode >>> 20;
            hashCode += hashCode << 5;
            hashCode ^= hashCode >>> 18;
            hashCode += hashCode << 10;
            hashCode ^= hashCode >>> 24;
            hashCode += hashCode << 30;
            this.$hashCode = (int)hashCode;
        }
        return this.$hashCode;
    }

    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        LiveHash thatObj = (LiveHash)that;
        if (this.$hashCode != -1 && thatObj.$hashCode != -1 && this.$hashCode != thatObj.$hashCode) {
            return false;
        }
        if (this.accountId == null && thatObj.accountId != null) {
            return false;
        }
        if (this.accountId != null && !this.accountId.equals(thatObj.accountId)) {
            return false;
        }
        if (this.hash == null && thatObj.hash != null) {
            return false;
        }
        if (this.hash != null && !this.hash.equals((Object)thatObj.hash)) {
            return false;
        }
        if (this.keys == null && thatObj.keys != null) {
            return false;
        }
        if (this.keys != null && !this.keys.equals(thatObj.keys)) {
            return false;
        }
        if (this.duration == null && thatObj.duration != null) {
            return false;
        }
        if (this.duration != null && !this.duration.equals(thatObj.duration)) {
            return false;
        }
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            if (thatObj.$unknownFields == null || this.$unknownFields.size() != thatObj.$unknownFields.size()) {
                return false;
            }
            if (!this.$unknownFields.equals(thatObj.$unknownFields)) {
                return false;
            }
        } else if (thatObj.$unknownFields != null && !thatObj.$unknownFields.isEmpty()) {
            return false;
        }
        return true;
    }

    public String toString() {
        String $ufstr = null;
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.$unknownFields.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                this.$unknownFields.get(i).printToString(sb);
            }
            $ufstr = sb.toString();
        }
        return "LiveHash[accountId=" + String.valueOf(this.accountId) + ", hash=" + String.valueOf(this.hash) + ", keys=" + String.valueOf(this.keys) + ", duration=" + String.valueOf(this.duration) + (String)($ufstr == null ? "" : ", " + $ufstr) + "]";
    }

    public boolean hasAccountId() {
        return this.accountId != null;
    }

    public AccountID accountIdOrElse(@NonNull AccountID defaultValue) {
        return this.hasAccountId() ? this.accountId : defaultValue;
    }

    @NonNull
    public AccountID accountIdOrThrow() {
        return Objects.requireNonNull(this.accountId, "Field accountId is null");
    }

    public void ifAccountId(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasAccountId()) {
            ifPresent.accept(this.accountId);
        }
    }

    public boolean hasKeys() {
        return this.keys != null;
    }

    public KeyList keysOrElse(@NonNull KeyList defaultValue) {
        return this.hasKeys() ? this.keys : defaultValue;
    }

    @NonNull
    public KeyList keysOrThrow() {
        return Objects.requireNonNull(this.keys, "Field keys is null");
    }

    public void ifKeys(@NonNull Consumer<KeyList> ifPresent) {
        if (this.hasKeys()) {
            ifPresent.accept(this.keys);
        }
    }

    public boolean hasDuration() {
        return this.duration != null;
    }

    public Duration durationOrElse(@NonNull Duration defaultValue) {
        return this.hasDuration() ? this.duration : defaultValue;
    }

    @NonNull
    public Duration durationOrThrow() {
        return Objects.requireNonNull(this.duration, "Field duration is null");
    }

    public void ifDuration(@NonNull Consumer<Duration> ifPresent) {
        if (this.hasDuration()) {
            ifPresent.accept(this.duration);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.accountId, this.hash, this.keys, this.duration, this.$unknownFields);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private AccountID accountId = null;
        @NonNull
        private Bytes hash = Bytes.EMPTY;
        @Nullable
        private KeyList keys = null;
        @Nullable
        private Duration duration = null;
        private final List<UnknownField> $unknownFields;

        public Builder() {
            this.$unknownFields = null;
        }

        public Builder(AccountID accountId, Bytes hash, KeyList keys, Duration duration) {
            this.$unknownFields = null;
            this.accountId = accountId;
            this.hash = hash != null ? hash : Bytes.EMPTY;
            this.keys = keys;
            this.duration = duration;
        }

        public Builder(AccountID accountId, Bytes hash, KeyList keys, Duration duration, List<UnknownField> $unknownFields) {
            this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
            this.accountId = accountId;
            this.hash = hash != null ? hash : Bytes.EMPTY;
            this.keys = keys;
            this.duration = duration;
        }

        public LiveHash build() {
            return new LiveHash(this.accountId, this.hash, this.keys, this.duration);
        }

        public Builder accountId(@Nullable AccountID accountId) {
            this.accountId = accountId;
            return this;
        }

        public Builder accountId(AccountID.Builder builder) {
            this.accountId = builder.build();
            return this;
        }

        public Builder hash(@NonNull Bytes hash) {
            this.hash = hash != null ? hash : Bytes.EMPTY;
            return this;
        }

        public Builder keys(@Nullable KeyList keys) {
            this.keys = keys;
            return this;
        }

        public Builder keys(KeyList.Builder builder) {
            this.keys = builder.build();
            return this;
        }

        public Builder duration(@Nullable Duration duration) {
            this.duration = duration;
            return this;
        }

        public Builder duration(Duration.Builder builder) {
            this.duration = builder.build();
            return this;
        }
    }
}

