/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.virtualmap.internal.reconnect;

import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.virtualmap.VirtualKey;
import com.swirlds.virtualmap.VirtualValue;
import com.swirlds.virtualmap.datasource.VirtualLeafBytes;
import com.swirlds.virtualmap.internal.RecordAccessor;
import com.swirlds.virtualmap.internal.reconnect.ReconnectHashLeafFlusher;
import edu.umd.cs.findbugs.annotations.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReconnectNodeRemover<K extends VirtualKey, V extends VirtualValue> {
    private static final Logger logger = LogManager.getLogger(ReconnectNodeRemover.class);
    private long newLastLeafPath;
    private final RecordAccessor oldRecords;
    private final long oldFirstLeafPath;
    private final long oldLastLeafPath;
    private final ReconnectHashLeafFlusher flusher;

    public ReconnectNodeRemover(@NonNull RecordAccessor oldRecords, long oldFirstLeafPath, long oldLastLeafPath, @NonNull ReconnectHashLeafFlusher flusher) {
        this.oldRecords = oldRecords;
        this.oldFirstLeafPath = oldFirstLeafPath;
        this.oldLastLeafPath = oldLastLeafPath;
        this.flusher = flusher;
    }

    public synchronized void setPathInformation(long newFirstLeafPath, long newLastLeafPath) {
        logger.info(LogMarker.RECONNECT.getMarker(), "setPathInformation(): firstLeafPath: {} -> {}, lastLeafPath: {} -> {}", (Object)this.oldFirstLeafPath, (Object)newFirstLeafPath, (Object)this.oldLastLeafPath, (Object)newLastLeafPath);
        this.flusher.start(newFirstLeafPath, newLastLeafPath);
        this.newLastLeafPath = newLastLeafPath;
        if (this.oldLastLeafPath > 0L) {
            for (long path = this.oldFirstLeafPath; path < Math.min(newFirstLeafPath, this.oldLastLeafPath + 1L); ++path) {
                VirtualLeafBytes oldRecord = this.oldRecords.findLeafRecord(path);
                assert (oldRecord != null);
                this.flusher.deleteLeaf(oldRecord);
            }
        }
        logger.info(LogMarker.RECONNECT.getMarker(), "setPathInformation(): done");
    }

    public synchronized void newLeafNode(long path, Bytes newKey) {
        VirtualLeafBytes oldRecord = this.oldRecords.findLeafRecord(path);
        if (oldRecord != null && !newKey.equals((Object)oldRecord.keyBytes())) {
            this.flusher.deleteLeaf(oldRecord);
        }
    }

    public synchronized void allNodesReceived() {
        long firstOldStalePath;
        logger.info(LogMarker.RECONNECT.getMarker(), "allNodesReceived()");
        for (long p = firstOldStalePath = this.newLastLeafPath == -1L ? 1L : this.newLastLeafPath + 1L; p <= this.oldLastLeafPath; ++p) {
            VirtualLeafBytes oldExtraLeafRecord = this.oldRecords.findLeafRecord(p);
            assert (oldExtraLeafRecord != null || p < this.oldFirstLeafPath);
            if (oldExtraLeafRecord == null) continue;
            this.flusher.deleteLeaf(oldExtraLeafRecord);
        }
        logger.info(LogMarker.RECONNECT.getMarker(), "allNodesReceived(): done");
    }
}

