/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.util;

import com.hedera.hapi.node.base.Transaction;
import com.hedera.hapi.node.transaction.TransactionResponse;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.grpc.GrpcCall;
import com.hedera.pbj.runtime.grpc.GrpcClient;
import com.hedera.pbj.runtime.grpc.Pipeline;
import com.hedera.pbj.runtime.grpc.Pipelines;
import com.hedera.pbj.runtime.grpc.ServiceInterface;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicReference;

public interface UtilServiceInterface
extends ServiceInterface {
    public static final String SERVICE_NAME = "UtilService";
    public static final String FULL_NAME = "proto.UtilService";

    @NonNull
    public TransactionResponse prng(@NonNull Transaction var1);

    @NonNull
    public TransactionResponse atomicBatch(@NonNull Transaction var1);

    @NonNull
    default public String serviceName() {
        return SERVICE_NAME;
    }

    @NonNull
    default public String fullName() {
        return FULL_NAME;
    }

    @NonNull
    default public List<ServiceInterface.Method> methods() {
        return Arrays.asList(UtilServiceMethod.values());
    }

    @NonNull
    default public Pipeline<? super Bytes> open(@NonNull ServiceInterface.Method method, @NonNull ServiceInterface.RequestOptions options, @NonNull Pipeline<? super Bytes> replies) {
        UtilServiceMethod m = (UtilServiceMethod)method;
        try {
            return switch (m.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> Pipelines.unary().mapRequest(bytes -> UtilServiceInterface.parseTransaction(bytes, options)).method(this::prng).mapResponse(reply -> UtilServiceInterface.serializeTransactionResponse(reply, options)).respondTo(replies).build();
                case 1 -> Pipelines.unary().mapRequest(bytes -> UtilServiceInterface.parseTransaction(bytes, options)).method(this::atomicBatch).mapResponse(reply -> UtilServiceInterface.serializeTransactionResponse(reply, options)).respondTo(replies).build();
            };
        }
        catch (Exception e) {
            replies.onError((Throwable)e);
            return Pipelines.noop();
        }
    }

    @NonNull
    private static Codec<Transaction> getTransactionCodec(@NonNull ServiceInterface.RequestOptions options) {
        Objects.requireNonNull(options);
        if (options.isJson() && !options.isProtobuf()) {
            return Transaction.JSON;
        }
        return Transaction.PROTOBUF;
    }

    @NonNull
    private static Codec<TransactionResponse> getTransactionResponseCodec(@NonNull ServiceInterface.RequestOptions options) {
        Objects.requireNonNull(options);
        if (options.isJson() && !options.isProtobuf()) {
            return TransactionResponse.JSON;
        }
        return TransactionResponse.PROTOBUF;
    }

    @NonNull
    private static Transaction parseTransaction(@NonNull Bytes message, @NonNull ServiceInterface.RequestOptions options) throws ParseException {
        Objects.requireNonNull(message);
        Objects.requireNonNull(options);
        return (Transaction)UtilServiceInterface.getTransactionCodec(options).parse(message.toReadableSequentialData(), false, 16);
    }

    @NonNull
    private static Bytes serializeTransactionResponse(@NonNull TransactionResponse reply, @NonNull ServiceInterface.RequestOptions options) {
        Objects.requireNonNull(reply);
        Objects.requireNonNull(options);
        return UtilServiceInterface.getTransactionResponseCodec(options).toBytes((Object)reply);
    }

    public static enum UtilServiceMethod implements ServiceInterface.Method
    {
        prng,
        atomicBatch;

    }

    public static class UtilServiceClient
    implements UtilServiceInterface {
        private final GrpcClient grpcClient;
        private final ServiceInterface.RequestOptions requestOptions;

        public UtilServiceClient(@NonNull GrpcClient grpcClient, @NonNull ServiceInterface.RequestOptions requestOptions) {
            this.grpcClient = Objects.requireNonNull(grpcClient);
            this.requestOptions = Objects.requireNonNull(requestOptions);
        }

        public void close() {
            this.grpcClient.close();
        }

        @Override
        @NonNull
        public TransactionResponse prng(@NonNull Transaction request) {
            final AtomicReference replyRef = new AtomicReference();
            final AtomicReference errorRef = new AtomicReference();
            final CountDownLatch latch = new CountDownLatch(1);
            Pipeline<TransactionResponse> pipeline = new Pipeline<TransactionResponse>(this){

                public void onSubscribe(Flow.Subscription subscription) {
                    subscription.request(Long.MAX_VALUE);
                }

                public void onNext(TransactionResponse reply) {
                    if (replyRef.get() != null) {
                        throw new IllegalStateException("prng is unary, but received more than one reply. The latest reply is: " + String.valueOf(reply));
                    }
                    replyRef.set(reply);
                    latch.countDown();
                }

                public void onError(Throwable throwable) {
                    errorRef.set(throwable);
                    latch.countDown();
                }

                public void onComplete() {
                    latch.countDown();
                }
            };
            GrpcCall call = this.grpcClient.createCall("proto.UtilService/prng", UtilServiceInterface.getTransactionCodec(this.requestOptions), UtilServiceInterface.getTransactionResponseCodec(this.requestOptions), (Pipeline)pipeline);
            call.sendRequest((Object)request, true);
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (errorRef.get() != null) {
                throw new RuntimeException((Throwable)errorRef.get());
            }
            if (replyRef.get() != null) {
                return (TransactionResponse)replyRef.get();
            }
            throw new RuntimeException("Call to prng completed w/o receiving a reply or an error explicitly. The request was: " + String.valueOf(request));
        }

        @Override
        @NonNull
        public TransactionResponse atomicBatch(@NonNull Transaction request) {
            final AtomicReference replyRef = new AtomicReference();
            final AtomicReference errorRef = new AtomicReference();
            final CountDownLatch latch = new CountDownLatch(1);
            Pipeline<TransactionResponse> pipeline = new Pipeline<TransactionResponse>(this){

                public void onSubscribe(Flow.Subscription subscription) {
                    subscription.request(Long.MAX_VALUE);
                }

                public void onNext(TransactionResponse reply) {
                    if (replyRef.get() != null) {
                        throw new IllegalStateException("atomicBatch is unary, but received more than one reply. The latest reply is: " + String.valueOf(reply));
                    }
                    replyRef.set(reply);
                    latch.countDown();
                }

                public void onError(Throwable throwable) {
                    errorRef.set(throwable);
                    latch.countDown();
                }

                public void onComplete() {
                    latch.countDown();
                }
            };
            GrpcCall call = this.grpcClient.createCall("proto.UtilService/atomicBatch", UtilServiceInterface.getTransactionCodec(this.requestOptions), UtilServiceInterface.getTransactionResponseCodec(this.requestOptions), (Pipeline)pipeline);
            call.sendRequest((Object)request, true);
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (errorRef.get() != null) {
                throw new RuntimeException((Throwable)errorRef.get());
            }
            if (replyRef.get() != null) {
                return (TransactionResponse)replyRef.get();
            }
            throw new RuntimeException("Call to atomicBatch completed w/o receiving a reply or an error explicitly. The request was: " + String.valueOf(request));
        }
    }
}

