/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.virtualmap.internal.reconnect;

import com.swirlds.common.merkle.synchronization.config.ReconnectConfig;
import com.swirlds.common.merkle.synchronization.streams.AsyncOutputStream;
import com.swirlds.common.merkle.synchronization.utility.MerkleSynchronizationException;
import com.swirlds.common.threading.pool.StandardWorkGroup;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.virtualmap.internal.reconnect.LearnerPullVirtualTreeView;
import com.swirlds.virtualmap.internal.reconnect.NodeTraversalOrder;
import com.swirlds.virtualmap.internal.reconnect.PullVirtualTreeRequest;
import java.time.Duration;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.crypto.Hash;
import org.hiero.base.io.SelfSerializable;

public class LearnerPullVirtualTreeSendTask {
    private static final Logger logger = LogManager.getLogger(LearnerPullVirtualTreeSendTask.class);
    private static final String NAME = "reconnect-learner-sender";
    private final StandardWorkGroup workGroup;
    private final AsyncOutputStream<PullVirtualTreeRequest> out;
    private final LearnerPullVirtualTreeView view;
    private final NodeTraversalOrder traversalOrder;
    private final AtomicBoolean senderIsFinished;
    private final Duration rootResponseTimeout;
    private final CountDownLatch rootResponseReceived;
    private final AtomicLong responsesExpected;

    public LearnerPullVirtualTreeSendTask(ReconnectConfig reconnectConfig, StandardWorkGroup workGroup, AsyncOutputStream<PullVirtualTreeRequest> out, LearnerPullVirtualTreeView view, NodeTraversalOrder traversalOrder, AtomicBoolean senderIsFinished, CountDownLatch rootResponseReceived, AtomicLong responsesExpected) {
        this.workGroup = workGroup;
        this.out = out;
        this.view = view;
        this.traversalOrder = traversalOrder;
        this.senderIsFinished = senderIsFinished;
        this.rootResponseReceived = rootResponseReceived;
        this.responsesExpected = responsesExpected;
        this.rootResponseTimeout = reconnectConfig.pullLearnerRootResponseTimeout();
    }

    void exec() {
        this.workGroup.execute(NAME, this::run);
    }

    private void run() {
        try (AsyncOutputStream<PullVirtualTreeRequest> asyncOutputStream = this.out;){
            this.out.sendAsync((SelfSerializable)new PullVirtualTreeRequest(0L, new Hash()));
            this.view.getMapStats().incrementTransfersFromLearner();
            this.responsesExpected.incrementAndGet();
            if (!this.rootResponseReceived.await(this.rootResponseTimeout.toMillis(), TimeUnit.MILLISECONDS)) {
                throw new MerkleSynchronizationException("Timed out waiting for root node response from the teacher");
            }
            while (true) {
                long path = this.traversalOrder.getNextPathToSend();
                logger.debug(LogMarker.RECONNECT.getMarker(), "Learner send path: " + path);
                if (path < -1L) {
                    Thread.onSpinWait();
                    continue;
                }
                Hash hash = path == -1L ? null : this.view.getNodeHash(path);
                this.out.sendAsync((SelfSerializable)new PullVirtualTreeRequest(path, hash));
                this.view.getMapStats().incrementTransfersFromLearner();
                if (path == -1L) break;
                this.responsesExpected.incrementAndGet();
            }
            logger.debug(LogMarker.RECONNECT.getMarker(), "Learner send done");
        }
        catch (InterruptedException ex) {
            logger.warn(LogMarker.RECONNECT.getMarker(), "Learner's sending task interrupted");
            Thread.currentThread().interrupt();
        }
        catch (Exception ex) {
            throw new MerkleSynchronizationException("Exception in the learner's sending task", (Throwable)ex);
        }
        finally {
            this.senderIsFinished.set(true);
        }
    }
}

