/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.test.fixtures.gui;

import com.swirlds.platform.gui.hashgraph.HashgraphGui;
import com.swirlds.platform.gui.hashgraph.HashgraphGuiSource;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import javax.swing.JFrame;

public final class HashgraphGuiRunner {
    private HashgraphGuiRunner() {
    }

    public static void runHashgraphGui(@NonNull HashgraphGuiSource guiSource, @Nullable JComponent additionalControls) {
        JFrame frame = new JFrame();
        CloseDetector closeDetector = new CloseDetector();
        frame.addWindowListener(closeDetector);
        frame.setExtendedState(frame.getExtendedState() | 6);
        frame.setLayout(new BorderLayout());
        frame.setFocusable(true);
        frame.requestFocusInWindow();
        frame.setDefaultCloseOperation(3);
        HashgraphGui hashgraphGui = new HashgraphGui(guiSource);
        hashgraphGui.reloadSource();
        frame.add((Component)hashgraphGui, "North");
        if (additionalControls != null) {
            frame.add((Component)additionalControls, "South");
        }
        frame.setVisible(true);
        while (!closeDetector.isClosed()) {
            hashgraphGui.reloadSource();
            hashgraphGui.repaint();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }
    }

    private static class CloseDetector
    implements WindowListener {
        private final AtomicBoolean isClosed = new AtomicBoolean(false);

        private CloseDetector() {
        }

        public boolean isClosed() {
            return this.isClosed.get();
        }

        @Override
        public void windowOpened(WindowEvent e) {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            this.isClosed.set(true);
        }

        @Override
        public void windowClosed(WindowEvent e) {
            this.isClosed.set(true);
        }

        @Override
        public void windowIconified(WindowEvent e) {
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
        }

        @Override
        public void windowActivated(WindowEvent e) {
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
        }
    }
}

