/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.iss;

import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.swirlds.demo.iss.PlannedIncident;
import com.swirlds.logging.legacy.LogMarker;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.consensus.model.node.NodeId;

public class PlannedIss
implements PlannedIncident {
    private static final Logger logger = LogManager.getLogger(PlannedIss.class);
    private final Duration timeAfterGenesis;
    private final List<List<NodeId>> hashPartitions;

    public PlannedIss(@NonNull Duration timeAfterGenesis, @NonNull List<List<NodeId>> hashPartitions) {
        this.timeAfterGenesis = timeAfterGenesis;
        this.hashPartitions = hashPartitions;
    }

    public PlannedIss(@NonNull ReadableSequentialData in) {
        this.timeAfterGenesis = Duration.ofNanos(in.readLong());
        int partitionCount = in.readInt();
        this.hashPartitions = new ArrayList<List<NodeId>>(partitionCount);
        for (int partitionIndex = 0; partitionIndex < partitionCount; ++partitionIndex) {
            int partitionSize = in.readInt();
            ArrayList<NodeId> nodes = new ArrayList<NodeId>(partitionSize);
            for (int nodeIndex = 0; nodeIndex < partitionSize; ++nodeIndex) {
                nodes.add(NodeId.of((long)in.readLong()));
            }
            this.hashPartitions.add(nodes);
        }
    }

    public void writeTo(WritableSequentialData out) {
        out.writeLong(this.timeAfterGenesis.toNanos());
        out.writeInt(this.hashPartitions.size());
        for (List<NodeId> partition : this.hashPartitions) {
            out.writeInt(partition.size());
            for (NodeId nodeId : partition) {
                out.writeLong(nodeId.id());
            }
        }
    }

    public int getSizeInBytes() {
        int sizeInBytes = 0;
        sizeInBytes += 8;
        sizeInBytes += 4;
        for (List<NodeId> partition : this.hashPartitions) {
            sizeInBytes += 4;
            sizeInBytes += partition.size() * 8;
        }
        return sizeInBytes;
    }

    @Override
    @NonNull
    public Duration getTimeAfterGenesis() {
        return this.timeAfterGenesis;
    }

    @Override
    @NonNull
    public String getDescriptor() {
        return "ISS";
    }

    public int getPartitionCount() {
        return this.hashPartitions.size();
    }

    public int getPartitionOfNode(@NonNull NodeId nodeId) {
        Objects.requireNonNull(nodeId);
        for (int partitionIndex = 0; partitionIndex < this.hashPartitions.size(); ++partitionIndex) {
            List<NodeId> partition = this.hashPartitions.get(partitionIndex);
            for (NodeId partitionNode : partition) {
                if (!nodeId.equals((Object)partitionNode)) continue;
                return partitionIndex;
            }
        }
        return -1;
    }

    @NonNull
    public static PlannedIss fromString(@NonNull String plannedIssString) {
        String[] timestampAndPartitionsStrings = plannedIssString.strip().split(":");
        int elapsedTime = Integer.parseInt(timestampAndPartitionsStrings[0]);
        String partitionsString = timestampAndPartitionsStrings[1];
        String[] partitionStrings = partitionsString.split("-");
        HashSet<NodeId> uniqueNodeIds = new HashSet<NodeId>();
        ArrayList<List<NodeId>> partitions = new ArrayList<List<NodeId>>(partitionStrings.length);
        for (String partitionString : partitionStrings) {
            String[] nodeStrings = partitionString.split("\\+");
            ArrayList<NodeId> nodes = new ArrayList<NodeId>();
            for (String nodeString : nodeStrings) {
                NodeId nodeId = NodeId.of((long)Long.parseLong(nodeString));
                nodes.add(nodeId);
                if (uniqueNodeIds.add(nodeId)) continue;
                logger.error(LogMarker.EXCEPTION.getMarker(), "Node {} appears more than once in ISS description!", (Object)nodeId);
            }
            partitions.add(nodes);
        }
        return new PlannedIss(Duration.ofSeconds(elapsedTime), partitions);
    }
}

