/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.test.fixtures.stream;

import java.io.IOException;
import java.security.SecureRandom;
import java.time.Instant;
import java.util.Arrays;
import java.util.Objects;
import org.hiero.base.crypto.AbstractHashable;
import org.hiero.base.crypto.RunningHash;
import org.hiero.base.crypto.RunningHashable;
import org.hiero.base.crypto.SerializableHashable;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.base.io.streams.SerializableDataOutputStream;
import org.hiero.base.utility.ByteUtils;
import org.hiero.consensus.model.stream.StreamAligned;
import org.hiero.consensus.model.stream.Timestamped;

public class ObjectForTestStream
extends AbstractHashable
implements RunningHashable,
SerializableHashable,
StreamAligned,
Timestamped {
    private static final long CLASS_ID = -1238626748786447452L;
    private static final int CLASS_VERSION_PAYLOAD = 2;
    private static final int CLASS_VERSION = 2;
    private byte[] payload;
    private Instant consensusTimestamp;
    private RunningHash runningHash;
    private long streamAlignment;

    public ObjectForTestStream() {
    }

    public ObjectForTestStream(int number, Instant consensusTimestamp) {
        this(number, consensusTimestamp, Long.MIN_VALUE);
    }

    public ObjectForTestStream(int number, Instant consensusTimestamp, long streamAlignment) {
        this(ByteUtils.intToByteArray((int)number), consensusTimestamp, streamAlignment);
    }

    public ObjectForTestStream(byte[] payload, Instant consensusTimestamp, long streamAlignment) {
        this.payload = payload;
        this.consensusTimestamp = consensusTimestamp;
        this.runningHash = new RunningHash();
        this.streamAlignment = streamAlignment;
    }

    public long getStreamAlignment() {
        return this.streamAlignment;
    }

    public Instant getTimestamp() {
        return this.consensusTimestamp;
    }

    public long getClassId() {
        return -1238626748786447452L;
    }

    public int getVersion() {
        return 2;
    }

    public RunningHash getRunningHash() {
        return this.runningHash;
    }

    public void serialize(SerializableDataOutputStream out) throws IOException {
        out.writeByteArray(this.payload);
        out.writeInstant(this.consensusTimestamp);
    }

    public void deserialize(SerializableDataInputStream in, int version) throws IOException {
        if (version == 2) {
            this.payload = in.readByteArray(Integer.MAX_VALUE);
        } else {
            int number = in.readInt();
            this.payload = ByteUtils.intToByteArray((int)number);
        }
        this.consensusTimestamp = in.readInstant();
    }

    public String toString() {
        return String.format("ObjectForTestStream[payload size: %d, time: %s]", this.payload.length, this.consensusTimestamp);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || ((Object)((Object)this)).getClass() != other.getClass()) {
            return false;
        }
        ObjectForTestStream that = (ObjectForTestStream)((Object)other);
        return Arrays.equals(this.payload, that.payload) && Objects.equals(this.consensusTimestamp, that.consensusTimestamp);
    }

    public int hashCode() {
        int result = Objects.hash(this.consensusTimestamp);
        result = 31 * result + Arrays.hashCode(this.payload);
        return result;
    }

    public static ObjectForTestStream getRandomObjectForTestStream(int sizeOfPayload) {
        SecureRandom random = new SecureRandom();
        byte[] payload = new byte[sizeOfPayload];
        random.nextBytes(payload);
        return new ObjectForTestStream(payload, Instant.now(), Long.MIN_VALUE);
    }
}

