/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.event;

import com.swirlds.common.metrics.RunningAverageMetric;
import com.swirlds.metrics.api.MetricConfig;
import com.swirlds.metrics.api.Metrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.concurrent.atomic.AtomicLong;

public class EventCounter {
    private static final AtomicLong numEventsInMemory = new AtomicLong(0L);
    private static final RunningAverageMetric.Config AVG_EVENTS_IN_MEM_CONFIG = new RunningAverageMetric.Config("internal", "eventsInMem").withDescription("total number of events in memory, for all members on the local machine together").withUnit("count");

    public static long getNumEventsInMemory() {
        return numEventsInMemory.get();
    }

    public static void incrementLinkedEventCount() {
        numEventsInMemory.incrementAndGet();
    }

    public static void decrementLinkedEventCount() {
        numEventsInMemory.decrementAndGet();
    }

    public static void registerEventCounterMetrics(@NonNull Metrics metrics) {
        RunningAverageMetric avgEventsInMem = (RunningAverageMetric)metrics.getOrCreate((MetricConfig)AVG_EVENTS_IN_MEM_CONFIG);
        metrics.addUpdater(() -> avgEventsInMem.update((double)EventCounter.getNumEventsInMemory()));
    }
}

