/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.formatting;

import java.util.List;

public enum TextEffect {
    RESET(0),
    BOLD(1),
    ITALIC(3),
    UNDERLINE(4),
    CROSSED_OUT(9),
    RED(31),
    GREEN(32),
    YELLOW(33),
    BLUE(34),
    PURPLE(35),
    CYAN(36),
    WHITE(37),
    GRAY(90),
    BRIGHT_RED(91),
    BRIGHT_GREEN(92),
    BRIGHT_YELLOW(93),
    BRIGHT_BLUE(94),
    BRIGHT_PURPLE(95),
    BRIGHT_CYAN(96),
    BRIGHT_WHITE(97);

    private static boolean textEffectsEnabled;
    private static final String FORMAT_ESCAPE = "\u001b[";
    private static final String FORMAT_SEPARATOR = ";";
    private static final String FORMAT_END = "m";
    private final int code;

    public static void setTextEffectsEnabled(boolean textEffectsEnabled) {
        TextEffect.textEffectsEnabled = textEffectsEnabled;
    }

    public static boolean areTextEffectsEnabled() {
        return textEffectsEnabled;
    }

    private TextEffect(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public String apply(String text) {
        return TextEffect.applyEffects(text, this);
    }

    public void apply(StringBuilder sb, String text) {
        TextEffect.applyEffects(sb, text, this);
    }

    private static void generateEscapeSequence(StringBuilder sb, TextEffect ... effects) {
        if (effects == null || effects.length == 0) {
            return;
        }
        sb.append(FORMAT_ESCAPE);
        for (int index = 0; index < effects.length; ++index) {
            sb.append(effects[index].getCode());
            if (index >= effects.length - 1) continue;
            sb.append(FORMAT_SEPARATOR);
        }
        sb.append(FORMAT_END);
    }

    private static void generateEscapeSequence(StringBuilder sb, List<TextEffect> effects) {
        if (effects == null || effects.isEmpty()) {
            return;
        }
        sb.append(FORMAT_ESCAPE);
        for (int index = 0; index < effects.size(); ++index) {
            sb.append(effects.get(index).getCode());
            if (index >= effects.size() - 1) continue;
            sb.append(FORMAT_SEPARATOR);
        }
        sb.append(FORMAT_END);
    }

    public static String applyEffects(String text, TextEffect ... effects) {
        if (!textEffectsEnabled) {
            return text;
        }
        StringBuilder sb = new StringBuilder();
        TextEffect.applyEffects(sb, text, effects);
        return sb.toString();
    }

    public static void applyEffects(StringBuilder sb, String text, TextEffect ... effects) {
        if (!textEffectsEnabled) {
            sb.append(text);
            return;
        }
        TextEffect.generateEscapeSequence(sb, effects);
        sb.append(text);
        TextEffect.generateEscapeSequence(sb, RESET);
    }

    public static String applyEffects(String text, List<TextEffect> effects) {
        if (!textEffectsEnabled) {
            return text;
        }
        StringBuilder sb = new StringBuilder();
        TextEffect.applyEffects(sb, text, effects);
        return sb.toString();
    }

    public static void applyEffects(StringBuilder sb, String text, List<TextEffect> effects) {
        if (!textEffectsEnabled) {
            sb.append(text);
            return;
        }
        TextEffect.generateEscapeSequence(sb, effects);
        sb.append(text);
        TextEffect.generateEscapeSequence(sb, RESET);
    }

    public static int getPrintableTextLength(String formattedString) {
        int length = 0;
        for (int i = 0; i < formattedString.length(); ++i) {
            if (formattedString.charAt(i) == '\u001b') {
                while (formattedString.charAt(i) != 'm') {
                    ++i;
                }
                continue;
            }
            ++length;
        }
        return length;
    }

    static {
        textEffectsEnabled = false;
    }
}

