/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state.merkle;

import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.FieldType;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.ProtoConstants;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.util.Objects;

public record StateItem(@NonNull Bytes key, @NonNull Bytes value) {
    public static final Codec<StateItem> CODEC = new StateItemCodec();

    public StateItem {
        Objects.requireNonNull(key, "Null key");
        Objects.requireNonNull(value, "Null value");
    }

    public static final class StateItemCodec
    implements Codec<StateItem> {
        static final FieldDefinition FIELD_KEY = new FieldDefinition("keyBytes", FieldType.BYTES, false, 2);
        static final FieldDefinition FIELD_VALUE = new FieldDefinition("keyBytes", FieldType.BYTES, false, 3);

        @NonNull
        public StateItem parse(@NonNull ReadableSequentialData input, boolean strictMode, boolean parseUnknownFields, int maxDepth, int maxSize) throws ParseException {
            int firstFieldNum = StateItemCodec.extractFieldNum(input);
            Bytes keyBytes = null;
            Bytes valueBytes = null;
            if (firstFieldNum == FIELD_KEY.number()) {
                keyBytes = StateItemCodec.readBytes(input, FIELD_KEY);
            } else if (firstFieldNum == FIELD_VALUE.number()) {
                valueBytes = StateItemCodec.readBytes(input, FIELD_VALUE);
            } else {
                throw new ParseException("StateItem unknown field num: " + firstFieldNum);
            }
            int secondFieldNum = StateItemCodec.extractFieldNum(input);
            if (secondFieldNum == FIELD_KEY.number()) {
                keyBytes = StateItemCodec.readBytes(input, FIELD_KEY);
            } else if (secondFieldNum == FIELD_VALUE.number()) {
                valueBytes = StateItemCodec.readBytes(input, FIELD_VALUE);
            } else {
                throw new ParseException("StateItem unknown field num: " + secondFieldNum);
            }
            assert (keyBytes != null);
            assert (valueBytes != null);
            return new StateItem(keyBytes, valueBytes);
        }

        private static int extractFieldNum(ReadableSequentialData input) throws ParseException {
            int tag = input.readVarInt(false);
            int wireType = tag & 7;
            if (wireType != ProtoConstants.WIRE_TYPE_DELIMITED.ordinal()) {
                throw new ParseException("StateItem key wire type mismatch: expected=" + ProtoConstants.WIRE_TYPE_DELIMITED.ordinal() + ", actual=" + wireType);
            }
            return tag >> 3;
        }

        private static Bytes readBytes(ReadableSequentialData input, FieldDefinition fieldDefinition) throws ParseException {
            ProtoConstants wireType = ProtoWriterTools.wireType((FieldDefinition)fieldDefinition);
            if (wireType != ProtoConstants.WIRE_TYPE_DELIMITED) {
                throw new ParseException("StateItem key wire type mismatch: expected=" + ProtoConstants.WIRE_TYPE_DELIMITED.ordinal() + ", actual=" + String.valueOf(wireType));
            }
            int keySize = input.readVarInt(false);
            Bytes keyBytes = keySize == 0 ? Bytes.EMPTY : input.readBytes(keySize);
            return keyBytes;
        }

        public void write(@NonNull StateItem data, @NonNull WritableSequentialData out) throws IOException {
            ProtoWriterTools.writeDelimited((WritableSequentialData)out, (FieldDefinition)FIELD_KEY, (int)StrictMath.toIntExact(data.key.length()), v -> v.writeBytes((RandomAccessData)data.key));
            ProtoWriterTools.writeDelimited((WritableSequentialData)out, (FieldDefinition)FIELD_VALUE, (int)StrictMath.toIntExact(data.value.length()), v -> v.writeBytes((RandomAccessData)data.value));
        }

        public int measure(@NonNull ReadableSequentialData input) throws ParseException {
            long start = input.position();
            this.parse(input);
            long end = input.position();
            return (int)(end - start);
        }

        public int measureRecord(StateItem item) {
            int size = 0;
            size += ProtoWriterTools.sizeOfTag((FieldDefinition)FIELD_KEY);
            size += ProtoWriterTools.sizeOfVarInt32((int)StrictMath.toIntExact(item.key.length()));
            size += StrictMath.toIntExact(item.key.length());
            size += ProtoWriterTools.sizeOfTag((FieldDefinition)FIELD_VALUE);
            size += ProtoWriterTools.sizeOfVarInt32((int)StrictMath.toIntExact(item.value().length()));
            return size += StrictMath.toIntExact(item.value.length());
        }

        public boolean fastEquals(@NonNull StateItem item, @NonNull ReadableSequentialData input) throws ParseException {
            return item.equals(this.parse(input));
        }

        public StateItem getDefaultInstance() {
            return new StateItem(Bytes.EMPTY, Bytes.EMPTY);
        }
    }
}

