/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.merkle.map.internal;

import com.swirlds.common.FastCopyable;
import com.swirlds.common.merkle.MerkleInternal;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.impl.PartialBinaryMerkleInternal;
import com.swirlds.common.merkle.utility.Keyed;
import com.swirlds.merkle.map.internal.MerkleMapEntryKey;
import java.util.Objects;
import org.hiero.base.io.SelfSerializable;

public class MerkleMapEntry<K extends FastCopyable & SelfSerializable, V extends MerkleNode>
extends PartialBinaryMerkleInternal
implements Keyed<K>,
MerkleInternal {
    public static final long CLASS_ID = 1854880078658912208L;

    public MerkleMapEntry(K key, V value) {
        this.setLeft((MerkleNode)new MerkleMapEntryKey<K>(key));
        this.setRight((MerkleNode)value);
    }

    public MerkleMapEntry(V value) {
        this.setRight((MerkleNode)value);
    }

    public MerkleMapEntry() {
    }

    protected MerkleMapEntry(MerkleMapEntry<K, V> that) {
        super(that);
        that.setImmutable(true);
        if (that.getLeft() != null) {
            this.setLeft(that.getLeft().copy().cast());
        }
        if (that.getRight() != null) {
            this.setRight(that.getRight().copy().cast());
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MerkleMapEntry)) {
            return false;
        }
        MerkleMapEntry otherLeaf = (MerkleMapEntry)((Object)object);
        return Objects.equals(this.getLeft(), otherLeaf.getLeft()) && Objects.equals(this.getRight(), otherLeaf.getRight());
    }

    public int hashCode() {
        return Objects.hash(this.getLeft(), this.getRight());
    }

    public MerkleMapEntry<K, V> copy() {
        this.throwIfImmutable();
        this.throwIfDestroyed();
        return new MerkleMapEntry<K, V>(this);
    }

    public long getClassId() {
        return 1854880078658912208L;
    }

    public int getVersion() {
        return 1;
    }

    public K getKey() {
        MerkleMapEntryKey key = (MerkleMapEntryKey)this.getLeft();
        return (K)(key == null ? null : (FastCopyable)key.getKey());
    }

    public void setKey(K key) {
        if (this.getLeft() == null) {
            this.setLeft((MerkleNode)new MerkleMapEntryKey<K>(key));
        } else {
            MerkleMapEntryKey keyWrapper = (MerkleMapEntryKey)this.getLeft();
            keyWrapper.setKey(key);
        }
    }

    public V getValue() {
        return (V)this.getRight();
    }

    public void setValue(V value) {
        this.setRight((MerkleNode)value);
    }

    private static class ClassVersion {
        public static final int ORIGINAL = 1;

        private ClassVersion() {
        }
    }
}

