/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.transaction;

import com.swirlds.common.metrics.FunctionGauge;
import com.swirlds.common.metrics.SpeedometerMetric;
import com.swirlds.metrics.api.MetricConfig;
import com.swirlds.metrics.api.Metrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.function.Supplier;

public class TransactionPoolMetrics {
    private static final SpeedometerMetric.Config ACCEPTED_APP_TRANSACTIONS_CONFIG = new SpeedometerMetric.Config("platform", "acceptedAppTransactions").withDescription("Cycled when an app transaction is submitted to the transaction pool and accepted.");
    private final SpeedometerMetric acceptedAppTransactions;
    private static final SpeedometerMetric.Config REJECTED_APP_TRANSACTIONS_CONFIG = new SpeedometerMetric.Config("platform", "rejectedAppTransactions").withDescription("Cycled when an app transaction is submitted to the transaction pool and not accepted.");
    private final SpeedometerMetric rejectedAppTransactions;
    private static final SpeedometerMetric.Config SUBMITTED_PLATFORM_TRANSACTIONS_CONFIG = new SpeedometerMetric.Config("platform", "submittedPlatformTransactions").withDescription("Cycled when a platform transaction is submitted (platform transactions are always accepted).");
    private final SpeedometerMetric submittedPlatformTransactions;

    public TransactionPoolMetrics(@NonNull Metrics metrics, @NonNull Supplier<Integer> getBufferedTransactionCount, @NonNull Supplier<Integer> getPriorityBufferedTransactionCount) {
        this.acceptedAppTransactions = (SpeedometerMetric)metrics.getOrCreate((MetricConfig)ACCEPTED_APP_TRANSACTIONS_CONFIG);
        this.rejectedAppTransactions = (SpeedometerMetric)metrics.getOrCreate((MetricConfig)REJECTED_APP_TRANSACTIONS_CONFIG);
        this.submittedPlatformTransactions = (SpeedometerMetric)metrics.getOrCreate((MetricConfig)SUBMITTED_PLATFORM_TRANSACTIONS_CONFIG);
        metrics.getOrCreate((MetricConfig)new FunctionGauge.Config("platform", "bufferedTransactions", Integer.class, getBufferedTransactionCount).withDescription("The number of non-priority transactions waiting to be inserted into an event.").withUnit("count"));
        metrics.getOrCreate((MetricConfig)new FunctionGauge.Config("platform", "bufferedPriorityTransactions", Integer.class, getPriorityBufferedTransactionCount).withDescription("The number of priority transactions waiting to be inserted into an event.").withUnit("count"));
    }

    public void recordAcceptedAppTransaction() {
        this.acceptedAppTransactions.cycle();
    }

    public void recordRejectedAppTransaction() {
        this.rejectedAppTransactions.cycle();
    }

    public void recordSubmittedPlatformTransaction() {
        this.submittedPlatformTransactions.cycle();
    }
}

