/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.merkledb.test.fixtures;

import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.merkledb.test.fixtures.ExampleByteArrayVirtualValue;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Random;
import org.hiero.base.constructable.ConstructableIgnored;

@ConstructableIgnored
public final class ExampleVariableValue
extends ExampleByteArrayVirtualValue {
    public static final ExampleVariableValueCodec CODEC = new ExampleVariableValueCodec();
    private static final Random RANDOM = new Random(12234L);
    private static final int RANDOM_BYTES = 1024;
    private static final byte[] RANDOM_DATA = new byte[1024];
    private int id;
    private byte[] data;

    public static Bytes intToValue(int v) {
        return ExampleVariableValue.intToValue(v, RANDOM_DATA, 0, 256 + v % 768);
    }

    public static Bytes intToValue(int v, byte[] data, int off, int len) {
        byte[] bytes = new byte[4 + len];
        ByteBuffer.wrap(bytes).putInt(v).put(data, off, len);
        return Bytes.wrap((byte[])bytes);
    }

    public ExampleVariableValue() {
        this.id = 0;
        this.data = new byte[256];
    }

    public ExampleVariableValue(int id) {
        this.id = id;
        this.data = new byte[256 + id % 768];
        System.arraycopy(RANDOM_DATA, 0, this.data, 0, this.data.length);
    }

    public ExampleVariableValue(int id, byte[] data) {
        this.id = id;
        this.data = new byte[data.length];
        System.arraycopy(data, 0, this.data, 0, data.length);
    }

    public ExampleVariableValue(ReadableSequentialData in) {
        this.id = in.readInt();
        int len = in.readInt();
        this.data = new byte[len];
        in.readBytes(this.data);
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public byte[] getData() {
        return this.data;
    }

    public int getSizeInBytes() {
        return 8 + this.data.length;
    }

    public void writeTo(WritableSequentialData out) {
        out.writeInt(this.id);
        out.writeInt(this.data.length);
        out.writeBytes(this.data);
    }

    static {
        RANDOM.nextBytes(RANDOM_DATA);
    }

    public static class ExampleVariableValueCodec
    implements Codec<ExampleVariableValue> {
        public ExampleVariableValue getDefaultInstance() {
            return null;
        }

        @NonNull
        public ExampleVariableValue parse(@NonNull ReadableSequentialData in, boolean strictMode, boolean parseUnknownFields, int maxDepth, int maxSize) {
            return new ExampleVariableValue(in);
        }

        public void write(@NonNull ExampleVariableValue value, @NonNull WritableSequentialData out) throws IOException {
            value.writeTo(out);
        }

        public int measure(@NonNull ReadableSequentialData in) {
            throw new UnsupportedOperationException("ExampleVariableValueCodec.measure() not implemented");
        }

        public int measureRecord(ExampleVariableValue value) {
            return value.getSizeInBytes();
        }

        public boolean fastEquals(@NonNull ExampleVariableValue value, @NonNull ReadableSequentialData in) throws ParseException {
            ExampleVariableValue other = (ExampleVariableValue)this.parse(in);
            return other.equals(value);
        }
    }
}

