/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.merkledb.files.hashmap;

import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.FieldType;
import com.hedera.pbj.runtime.ProtoConstants;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.BufferedData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.merkledb.files.hashmap.ParsedBucket;
import com.swirlds.merkledb.files.hashmap.ReusableBucketPool;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public sealed class Bucket
implements Closeable
permits ParsedBucket {
    private static final Logger logger = LogManager.getLogger(Bucket.class);
    private static final AtomicInteger LARGEST_BUCKET_CREATED = new AtomicInteger(0);
    protected static final FieldDefinition FIELD_BUCKET_INDEX = new FieldDefinition("index", FieldType.FIXED32, false, false, false, 1);
    protected static final FieldDefinition FIELD_BUCKET_ENTRIES = new FieldDefinition("entries", FieldType.MESSAGE, true, true, false, 11);
    protected static final FieldDefinition FIELD_BUCKETENTRY_HASHCODE = new FieldDefinition("hashCode", FieldType.FIXED32, false, false, false, 1);
    protected static final FieldDefinition FIELD_BUCKETENTRY_VALUE = new FieldDefinition("value", FieldType.FIXED64, false, false, false, 2);
    protected static final FieldDefinition FIELD_BUCKETENTRY_KEYBYTES = new FieldDefinition("keyBytes", FieldType.BYTES, false, false, false, 3);
    private static final int METADATA_SIZE = ProtoWriterTools.sizeOfTag((FieldDefinition)FIELD_BUCKET_INDEX, (ProtoConstants)ProtoConstants.WIRE_TYPE_FIXED_32_BIT) + 4;
    protected final ReusableBucketPool bucketPool;
    private volatile BufferedData bucketData;
    private volatile long bucketIndexFieldOffset = 0L;
    private int entryCount = 0;

    protected Bucket() {
        this(null);
    }

    protected Bucket(ReusableBucketPool bucketPool) {
        this.bucketPool = bucketPool;
        this.bucketData = BufferedData.allocate((int)METADATA_SIZE);
        this.clear();
    }

    private void setSize(int size, boolean keepContent) {
        if (this.bucketData.capacity() < (long)size) {
            BufferedData newData = BufferedData.allocate((int)size);
            if (keepContent) {
                this.bucketData.resetPosition();
                newData.writeBytes(this.bucketData);
            }
            this.bucketData = newData;
        }
        this.bucketData.resetPosition();
        this.bucketData.limit((long)size);
    }

    @Override
    public void close() throws IOException {
        if (this.bucketPool != null) {
            this.bucketPool.releaseBucket(this);
        }
    }

    public void clear() {
        this.setSize(METADATA_SIZE, false);
        this.bucketIndexFieldOffset = 0L;
        this.setBucketIndex(0);
        this.entryCount = 0;
    }

    public int getBucketIndex() {
        long bucketIndexValueOffset = this.bucketIndexFieldOffset + (long)ProtoWriterTools.sizeOfTag((FieldDefinition)FIELD_BUCKET_INDEX, (ProtoConstants)ProtoConstants.WIRE_TYPE_FIXED_32_BIT);
        return this.bucketData.getInt(bucketIndexValueOffset);
    }

    public void setBucketIndex(int index) {
        this.bucketData.position(this.bucketIndexFieldOffset);
        ProtoWriterTools.writeTag((WritableSequentialData)this.bucketData, (FieldDefinition)FIELD_BUCKET_INDEX);
        this.bucketData.writeInt(index);
    }

    public boolean isEmpty() {
        return this.bucketData.length() == (long)METADATA_SIZE;
    }

    public int getBucketEntryCount() {
        return this.entryCount;
    }

    protected void checkLargestBucket(int count) {
        if (!logger.isDebugEnabled(LogMarker.MERKLE_DB.getMarker())) {
            return;
        }
        if (count > LARGEST_BUCKET_CREATED.get()) {
            LARGEST_BUCKET_CREATED.set(count);
            logger.debug(LogMarker.MERKLE_DB.getMarker(), "New largest bucket, now = {} entries", (Object)count);
        }
    }

    public int sizeInBytes() {
        return Math.toIntExact(this.bucketData.length());
    }

    public long findValue(int keyHashCode, Bytes key, long notFoundValue) throws IOException {
        FindResult result = this.findEntry(keyHashCode, key);
        if (result.found()) {
            return result.entryValue();
        }
        return notFoundValue;
    }

    public final void putValue(Bytes key, int keyHashCode, long value) {
        this.putValue(key, keyHashCode, Long.MIN_VALUE, value);
    }

    public boolean putValue(Bytes key, int keyHashCode, long oldValue, long value) {
        boolean needCheckOldValue = oldValue != Long.MIN_VALUE;
        FindResult result = this.findEntry(keyHashCode, key);
        if (value == Long.MIN_VALUE) {
            if (result.found()) {
                if (needCheckOldValue && oldValue != result.entryValue) {
                    return false;
                }
                long nextEntryOffset = result.entryOffset() + (long)result.entrySize();
                long remainderSize = this.bucketData.length() - nextEntryOffset;
                if (remainderSize > 0L) {
                    BufferedData remainder = this.bucketData.slice(nextEntryOffset, remainderSize);
                    this.bucketData.position(result.entryOffset());
                    this.bucketData.writeBytes(remainder);
                }
                if (this.bucketIndexFieldOffset > result.entryOffset()) {
                    this.bucketIndexFieldOffset -= (long)result.entrySize();
                }
                this.bucketData.position(0L);
                this.bucketData.limit(result.entryOffset() + remainderSize);
                --this.entryCount;
                return true;
            }
            return false;
        }
        if (result.found()) {
            if (needCheckOldValue && oldValue != result.entryValue) {
                return false;
            }
            this.bucketData.position(result.entryValueOffset());
            this.bucketData.writeLong(value);
            return value != result.entryValue;
        }
        if (needCheckOldValue) {
            return false;
        }
        this.writeNewEntry(keyHashCode, value, key);
        this.checkLargestBucket(++this.entryCount);
        return true;
    }

    private void writeNewEntry(int hashCode, long value, Bytes key) {
        long entryOffset = this.bucketData.limit();
        int keySize = Math.toIntExact(key.length());
        int entrySize = ProtoWriterTools.sizeOfTag((FieldDefinition)FIELD_BUCKETENTRY_HASHCODE, (ProtoConstants)ProtoConstants.WIRE_TYPE_FIXED_32_BIT) + 4 + ProtoWriterTools.sizeOfTag((FieldDefinition)FIELD_BUCKETENTRY_VALUE, (ProtoConstants)ProtoConstants.WIRE_TYPE_FIXED_64_BIT) + 8 + ProtoWriterTools.sizeOfDelimited((FieldDefinition)FIELD_BUCKETENTRY_KEYBYTES, (int)keySize);
        int totalSize = ProtoWriterTools.sizeOfDelimited((FieldDefinition)FIELD_BUCKET_ENTRIES, (int)entrySize);
        this.setSize(Math.toIntExact(entryOffset + (long)totalSize), true);
        this.bucketData.position(entryOffset);
        ProtoWriterTools.writeDelimited((WritableSequentialData)this.bucketData, (FieldDefinition)FIELD_BUCKET_ENTRIES, (int)entrySize, out -> {
            ProtoWriterTools.writeTag((WritableSequentialData)out, (FieldDefinition)FIELD_BUCKETENTRY_HASHCODE);
            out.writeInt(hashCode);
            ProtoWriterTools.writeTag((WritableSequentialData)out, (FieldDefinition)FIELD_BUCKETENTRY_VALUE);
            out.writeLong(value);
            ProtoWriterTools.writeDelimited((WritableSequentialData)out, (FieldDefinition)FIELD_BUCKETENTRY_KEYBYTES, (int)keySize, t -> t.writeBytes((RandomAccessData)key));
        });
    }

    public void readFrom(ReadableSequentialData in) {
        int size = Math.toIntExact(in.remaining());
        this.setSize(size, false);
        in.readBytes(this.bucketData);
        this.bucketData.flip();
        this.bucketIndexFieldOffset = 0L;
        this.entryCount = 0;
        while (this.bucketData.hasRemaining()) {
            long fieldOffset = this.bucketData.position();
            int tag = this.bucketData.readVarInt(false);
            int fieldNum = tag >> 3;
            if (fieldNum == FIELD_BUCKET_INDEX.number()) {
                this.bucketIndexFieldOffset = fieldOffset;
                this.bucketData.skip(4L);
                continue;
            }
            if (fieldNum == FIELD_BUCKET_ENTRIES.number()) {
                int entryBytesSize = this.bucketData.readVarInt(false);
                this.bucketData.skip((long)entryBytesSize);
                ++this.entryCount;
                continue;
            }
            logger.error(LogMarker.MERKLE_DB.getMarker(), "Cannot read bucket: in={} in.pos={} off={} bd.pos={} bd.lim={} bd.data={}", (Object)in, (Object)in.position(), (Object)fieldOffset, (Object)this.bucketData.position(), (Object)this.bucketData.limit(), (Object)this.bucketData);
            throw new IllegalArgumentException("Unknown bucket field: " + fieldNum);
        }
        this.checkLargestBucket(this.entryCount);
    }

    private static int readBucketEntryHashCode(ReadableSequentialData in) {
        while (in.hasRemaining()) {
            int tag = in.readVarInt(false);
            int fieldNum = tag >> 3;
            if (fieldNum == FIELD_BUCKETENTRY_HASHCODE.number()) {
                return in.readInt();
            }
            if (fieldNum == FIELD_BUCKETENTRY_VALUE.number()) {
                in.readLong();
                continue;
            }
            if (fieldNum == FIELD_BUCKETENTRY_KEYBYTES.number()) {
                int bytesSize = in.readVarInt(false);
                in.skip((long)bytesSize);
                continue;
            }
            throw new IllegalArgumentException("Unknown bucket entry field: " + fieldNum);
        }
        throw new IllegalArgumentException("No bucket entry hash code found");
    }

    public void writeTo(WritableSequentialData out) {
        this.bucketData.resetPosition();
        out.writeBytes(this.bucketData);
    }

    public boolean sanitize(int expectedIndex, int expectedMaskBits) {
        int expectedMask = (1 << expectedMaskBits) - 1;
        this.bucketData.resetPosition();
        long srcIndex = 0L;
        long dstIndex = 0L;
        boolean updated = false;
        while (this.bucketData.hasRemaining()) {
            long fieldOffset = this.bucketData.position();
            int tag = this.bucketData.readVarInt(false);
            int fieldNum = tag >> 3;
            if (fieldNum == FIELD_BUCKET_INDEX.number()) {
                this.bucketData.writeInt(expectedIndex);
                long fieldLenWithTag = this.bucketData.position() - fieldOffset;
                srcIndex += fieldLenWithTag;
                dstIndex += fieldLenWithTag;
                continue;
            }
            if (fieldNum != FIELD_BUCKET_ENTRIES.number()) continue;
            int entrySize = this.bucketData.readVarInt(false);
            long nextEntryOffset = this.bucketData.position() + (long)entrySize;
            long entryLenWithTag = nextEntryOffset - fieldOffset;
            long oldLimit = this.bucketData.limit();
            this.bucketData.limit(nextEntryOffset);
            int entryHashCode = Bucket.readBucketEntryHashCode((ReadableSequentialData)this.bucketData);
            this.bucketData.limit(oldLimit);
            if ((entryHashCode & expectedMask) == expectedIndex) {
                this.copyBucketDataBytes(srcIndex, dstIndex, entryLenWithTag);
                dstIndex += entryLenWithTag;
            } else {
                updated = true;
            }
            srcIndex += entryLenWithTag;
            this.bucketData.position(nextEntryOffset);
        }
        this.bucketData.position(0L);
        this.bucketData.limit(dstIndex);
        return updated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyBucketDataBytes(long src, long dst, long len) {
        if (src == dst) {
            return;
        }
        long limit = this.bucketData.limit();
        long pos = this.bucketData.position();
        BufferedData srcBuf = this.bucketData.slice(src, len);
        try {
            this.bucketData.position(dst);
            this.bucketData.limit(dst + len);
            this.bucketData.writeBytes(srcBuf);
        }
        finally {
            this.bucketData.limit(limit);
            this.bucketData.position(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FindResult findEntry(int keyHashCode, Bytes key) {
        this.bucketData.resetPosition();
        while (this.bucketData.hasRemaining()) {
            long fieldOffset = this.bucketData.position();
            int tag = this.bucketData.readVarInt(false);
            int fieldNum = tag >> 3;
            if (fieldNum == FIELD_BUCKET_INDEX.number()) {
                this.bucketData.skip(4L);
                continue;
            }
            if (fieldNum == FIELD_BUCKET_ENTRIES.number()) {
                int entrySize = this.bucketData.readVarInt(false);
                long nextEntryOffset = this.bucketData.position() + (long)entrySize;
                long oldLimit = this.bucketData.limit();
                this.bucketData.limit(nextEntryOffset);
                try {
                    int entryHashCode = -1;
                    long entryValueOffset = -1L;
                    long entryValue = 0L;
                    long entryKeyBytesOffset = -1L;
                    int entryKeyBytesSize = -1;
                    while (this.bucketData.hasRemaining()) {
                        int entryTag = this.bucketData.readVarInt(false);
                        int entryFieldNum = entryTag >> 3;
                        if (entryFieldNum == FIELD_BUCKETENTRY_HASHCODE.number()) {
                            entryHashCode = this.bucketData.readInt();
                            if (entryHashCode == keyHashCode) continue;
                            break;
                        }
                        if (entryFieldNum == FIELD_BUCKETENTRY_VALUE.number()) {
                            entryValueOffset = this.bucketData.position();
                            entryValue = this.bucketData.readLong();
                            continue;
                        }
                        if (entryFieldNum == FIELD_BUCKETENTRY_KEYBYTES.number()) {
                            entryKeyBytesSize = this.bucketData.readVarInt(false);
                            entryKeyBytesOffset = this.bucketData.position();
                            this.bucketData.skip((long)entryKeyBytesSize);
                            continue;
                        }
                        throw new IllegalArgumentException("Unknown bucket entry field: " + entryFieldNum);
                    }
                    if (entryHashCode != keyHashCode) continue;
                    if (entryValueOffset == -1L || entryKeyBytesOffset == -1L) {
                        logger.warn(LogMarker.MERKLE_DB.getMarker(), "Broken bucket entry");
                        continue;
                    }
                    if (!this.keyEquals(entryKeyBytesOffset, entryKeyBytesSize, key)) continue;
                    FindResult findResult = new FindResult(true, fieldOffset, Math.toIntExact(nextEntryOffset - fieldOffset), entryValueOffset, entryValue);
                    return findResult;
                }
                finally {
                    this.bucketData.limit(oldLimit);
                    this.bucketData.position(nextEntryOffset);
                    continue;
                }
            }
            throw new IllegalArgumentException("Unknown bucket field: " + fieldNum);
        }
        return FindResult.NOT_FOUND;
    }

    private boolean keyEquals(long pos, int size, Bytes key) {
        if ((long)size != key.length()) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            if (this.bucketData.getByte(pos + (long)i) == key.getByte((long)i)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        int entryCount = this.getBucketEntryCount();
        int size = this.sizeInBytes();
        return "Bucket{bucketIndex=" + this.getBucketIndex() + ", entryCount=" + entryCount + ", size=" + size + "}";
    }

    private record FindResult(boolean found, long entryOffset, int entrySize, long entryValueOffset, long entryValue) {
        static FindResult NOT_FOUND = new FindResult(false, -1L, -1, -1L, -1L);
    }
}

