/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.test.fixtures.benchmark;

import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.test.fixtures.benchmark.StateManager;
import com.swirlds.common.utility.AutoCloseableWrapper;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class MutableStateManager<S extends MerkleNode>
implements StateManager<S> {
    private S state;
    private final Lock lock;

    public MutableStateManager(S initialState) {
        this.state = initialState;
        this.lock = new ReentrantLock();
    }

    @Override
    public AutoCloseableWrapper<S> getState() {
        this.lock.lock();
        return new AutoCloseableWrapper(this.state, this.lock::unlock);
    }

    public void lock() {
        this.lock.lock();
    }

    public void unlock() {
        this.lock.unlock();
    }

    public void setState(S state) {
        this.state = state;
    }
}

