/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.notification;

import java.util.ArrayList;
import java.util.List;
import org.hiero.consensus.model.notification.Notification;

public class NotificationResult<N extends Notification> {
    private final N notification;
    private final int totalListeners;
    private final List<Throwable> exceptions;

    public NotificationResult(N notification, int totalListeners) {
        this(notification, totalListeners, null);
    }

    public NotificationResult(N notification, int totalListeners, List<Throwable> exceptions) {
        if (notification == null) {
            throw new IllegalArgumentException("notification");
        }
        this.notification = notification;
        this.totalListeners = totalListeners;
        this.exceptions = exceptions != null ? exceptions : new ArrayList();
    }

    public N getNotification() {
        return this.notification;
    }

    public int getTotalListeners() {
        return this.totalListeners;
    }

    public List<Throwable> getExceptions() {
        return this.exceptions;
    }

    public int getFailureCount() {
        return this.exceptions.size();
    }

    public void addException(Throwable ex) {
        this.exceptions.add(ex);
    }
}

