/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.pbj.runtime.io;

import com.hedera.pbj.runtime.io.SequentialData;
import com.hedera.pbj.runtime.io.buffer.BufferedData;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public interface WritableSequentialData
extends SequentialData {
    public void writeByte(byte var1) throws BufferOverflowException, UncheckedIOException;

    default public void writeByte2(byte b1, byte b2) {
        this.writeByte(b1);
        this.writeByte(b2);
    }

    default public void writeByte3(byte b1, byte b2, byte b3) {
        this.writeByte(b1);
        this.writeByte(b2);
        this.writeByte(b3);
    }

    default public void writeByte4(byte b1, byte b2, byte b3, byte b4) {
        this.writeByte(b1);
        this.writeByte(b2);
        this.writeByte(b3);
        this.writeByte(b4);
    }

    default public void writeUnsignedByte(int b) throws BufferOverflowException, UncheckedIOException {
        this.writeByte((byte)b);
    }

    default public void writeBytes(@NonNull byte[] src) throws BufferOverflowException, UncheckedIOException {
        this.writeBytes(src, 0, src.length);
    }

    default public void writeBytes(@NonNull byte[] src, int offset, int length) throws BufferOverflowException, UncheckedIOException {
        if (length < 0) {
            throw new IllegalArgumentException("length must be >= 0");
        }
        for (int i = offset; i < offset + length; ++i) {
            this.writeByte(src[i]);
        }
    }

    default public void writeBytes(@NonNull ByteBuffer src) throws BufferOverflowException, UncheckedIOException {
        if (this.remaining() < (long)src.remaining()) {
            throw new BufferOverflowException();
        }
        while (src.hasRemaining()) {
            this.writeByte(src.get());
        }
    }

    default public void writeBytes(@NonNull BufferedData src) throws BufferOverflowException, UncheckedIOException {
        if (this.remaining() < src.remaining()) {
            throw new BufferOverflowException();
        }
        while (src.hasRemaining()) {
            this.writeByte(src.readByte());
        }
    }

    default public void writeBytes(@NonNull RandomAccessData src) throws BufferOverflowException, UncheckedIOException {
        if (this.remaining() < src.length()) {
            throw new BufferOverflowException();
        }
        int i = 0;
        while ((long)i < src.length()) {
            this.writeByte(src.getByte(i));
            ++i;
        }
    }

    default public int writeBytes(@NonNull InputStream src, int maxLength) throws UncheckedIOException {
        Objects.requireNonNull(src);
        if (maxLength < 0) {
            throw new IllegalArgumentException("The length must be >= 0");
        }
        if (maxLength == 0) {
            return 0;
        }
        long numBytesToRead = Math.min((long)maxLength, this.remaining());
        if (numBytesToRead == 0L) {
            return 0;
        }
        try {
            byte[] buf = new byte[8192];
            int totalBytesRead = 0;
            while ((long)totalBytesRead < numBytesToRead) {
                int maxBytesToRead = Math.toIntExact(Math.min(numBytesToRead - (long)totalBytesRead, (long)buf.length));
                int numBytesRead = src.read(buf, 0, maxBytesToRead);
                if (numBytesRead == -1) {
                    return totalBytesRead;
                }
                totalBytesRead += numBytesRead;
                this.writeBytes(buf, 0, numBytesRead);
            }
            return totalBytesRead;
        }
        catch (IOException ex) {
            throw new UncheckedIOException("Failed to read from InputStream", ex);
        }
    }

    default public void writeUTF8(@NonNull String value) {
        this.writeBytes(value.getBytes(StandardCharsets.UTF_8));
    }

    default public void writeInt(int value) throws BufferOverflowException, UncheckedIOException {
        if (this.remaining() < 4L) {
            throw new BufferOverflowException();
        }
        this.writeByte4((byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value);
    }

    default public void writeInt(int value, @NonNull ByteOrder byteOrder) throws BufferOverflowException, UncheckedIOException {
        if (byteOrder == ByteOrder.BIG_ENDIAN) {
            this.writeInt(value);
        } else {
            if (this.remaining() < 4L) {
                throw new BufferOverflowException();
            }
            this.writeByte4((byte)value, (byte)(value >>> 8), (byte)(value >>> 16), (byte)(value >>> 24));
        }
    }

    default public void writeUnsignedInt(long value) throws BufferOverflowException, UncheckedIOException {
        if (this.remaining() < 4L) {
            throw new BufferOverflowException();
        }
        this.writeByte4((byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value);
    }

    default public void writeUnsignedInt(long value, @NonNull ByteOrder byteOrder) throws BufferOverflowException, UncheckedIOException {
        if (byteOrder == ByteOrder.BIG_ENDIAN) {
            this.writeUnsignedInt(value);
        } else {
            if (this.remaining() < 4L) {
                throw new BufferOverflowException();
            }
            this.writeByte4((byte)value, (byte)(value >>> 8), (byte)(value >>> 16), (byte)(value >>> 24));
        }
    }

    default public void writeLong(long value) throws BufferOverflowException, UncheckedIOException {
        if (this.remaining() < 8L) {
            throw new BufferOverflowException();
        }
        this.writeByte4((byte)(value >>> 56), (byte)(value >>> 48), (byte)(value >>> 40), (byte)(value >>> 32));
        this.writeByte4((byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value);
    }

    default public void writeLong(long value, @NonNull ByteOrder byteOrder) throws BufferOverflowException, UncheckedIOException {
        if (byteOrder == ByteOrder.BIG_ENDIAN) {
            this.writeLong(value);
        } else {
            if (this.remaining() < 8L) {
                throw new BufferOverflowException();
            }
            this.writeByte4((byte)value, (byte)(value >>> 8), (byte)(value >>> 16), (byte)(value >>> 24));
            this.writeByte4((byte)(value >>> 32), (byte)(value >>> 40), (byte)(value >>> 48), (byte)(value >>> 56));
        }
    }

    default public void writeFloat(float value) throws BufferOverflowException, UncheckedIOException {
        this.writeInt(Float.floatToIntBits(value));
    }

    default public void writeFloat(float value, @NonNull ByteOrder byteOrder) throws BufferOverflowException, UncheckedIOException {
        this.writeInt(Float.floatToIntBits(value), byteOrder);
    }

    default public void writeDouble(double value) throws BufferOverflowException, UncheckedIOException {
        this.writeLong(Double.doubleToLongBits(value));
    }

    default public void writeDouble(double value, @NonNull ByteOrder byteOrder) throws BufferOverflowException, UncheckedIOException {
        this.writeLong(Double.doubleToLongBits(value), byteOrder);
    }

    default public void writeVarInt(int value, boolean zigZag) throws BufferOverflowException, UncheckedIOException {
        this.writeVarLong(value, zigZag);
    }

    default public void writeVarLong(long value, boolean zigZag) throws BufferOverflowException, UncheckedIOException {
        if (zigZag) {
            value = value << 1 ^ value >> 63;
        }
        while (true) {
            if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
                this.writeByte((byte)value);
                return;
            }
            this.writeByte((byte)((int)value & 0x7F | 0x80));
            value >>>= 7;
        }
    }
}

