/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.fcqueue;

import com.swirlds.common.FastCopyable;
import com.swirlds.common.merkle.MerkleLeaf;
import com.swirlds.common.merkle.impl.PartialMerkleLeaf;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicReference;
import org.hiero.base.crypto.Cryptography;
import org.hiero.base.crypto.CryptographyProvider;
import org.hiero.base.crypto.DigestType;
import org.hiero.base.crypto.Hash;
import org.hiero.base.crypto.SerializableHashable;
import org.hiero.base.io.SelfSerializable;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.base.io.streams.SerializableDataOutputStream;
import org.hiero.base.utility.ByteUtils;

public class FCQueue<E extends FastCopyable & SerializableHashable>
extends PartialMerkleLeaf
implements Queue<E>,
MerkleLeaf {
    private static final Cryptography CRYPTOGRAPHY = CryptographyProvider.getInstance();
    public static final long CLASS_ID = 139236190103L;
    public static final int MAX_ELEMENTS = 100000000;
    private static final DigestType DIGEST_TYPE = DigestType.SHA_384;
    private static final long HASH_RADIX = 3L;
    private static final byte[] NULL_HASH_BYTES = new byte[DIGEST_TYPE.digestLength()];
    private static final Hash NULL_HASH = new Hash(NULL_HASH_BYTES);
    private int size;
    private Node<E> head;
    private Node<E> tail;
    private final AtomicReference<Node<E>> unhashed;
    private volatile Hash hash;

    public FCQueue() {
        this.size = 0;
        this.head = new Node();
        this.head.runningHash = new long[DIGEST_TYPE.digestLength() / 8];
        this.tail = this.head;
        this.unhashed = new AtomicReference<Node<E>>(this.head);
        this.hash = null;
    }

    FCQueue(FCQueue<E> fcQueue) {
        super(fcQueue);
        this.size = fcQueue.size;
        this.head = fcQueue.head;
        this.tail = fcQueue.tail;
        this.unhashed = fcQueue.unhashed;
        this.hash = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hash getHash() {
        if (this.hash != null) {
            return this.hash;
        }
        FCQueue fCQueue = this;
        synchronized (fCQueue) {
            Hash result = this.hash;
            if (result == null) {
                result = this.computeHash();
                if (this.isImmutable()) {
                    this.hash = result;
                }
            }
            return result;
        }
    }

    private Hash computeHash() {
        if (this.tail.runningHash == null) {
            Node<E> node = this.unhashed.get();
            while (this.tail.runningHash == null) {
                Node next = node.next;
                if (next.runningHash == null) {
                    byte[] elementHash = this.getHash(node.element);
                    long[] runningHash = (long[])node.runningHash.clone();
                    for (int i = 0; i < runningHash.length; ++i) {
                        runningHash[i] = runningHash[i] * 3L + ByteUtils.byteArrayToLong((byte[])elementHash, (int)(i * 8));
                    }
                    next.runningHash = runningHash;
                }
                node = next;
            }
            this.unhashed.set(node);
        }
        long[] headHash = this.head.runningHash;
        long[] tailHash = this.tail.runningHash;
        long exponent = FCQueue.power(this.size);
        byte[] result = new byte[headHash.length * 8];
        for (int i = 0; i < headHash.length; ++i) {
            ByteUtils.longToByteArray((long)(tailHash[i] - headHash[i] * exponent), (byte[])result, (int)(i * 8));
        }
        return new Hash(result);
    }

    private static long power(int y) {
        long res = 1L;
        long x = 3L;
        while (y > 0) {
            if ((y & 1) == 1) {
                res *= x;
            }
            y >>= 1;
            x *= x;
        }
        return res;
    }

    public synchronized void setHash(Hash hash) {
        throw new UnsupportedOperationException("FCQueue computes its own hash");
    }

    public boolean isSelfHashing() {
        return true;
    }

    @Override
    public synchronized boolean add(E element) {
        if (this.isImmutable()) {
            throw new IllegalStateException("tried to modify an immutable FCQueue");
        }
        if (element == null) {
            throw new NullPointerException("tried to add a null element into an FCQueue");
        }
        if (this.size() >= 100000000) {
            throw new IllegalStateException(String.format("tried to add an element to an FCQueue whose size has reached MAX_ELEMENTS: %d", 100000000));
        }
        this.tail.element = element;
        this.tail.next = new Node();
        this.tail = this.tail.next;
        ++this.size;
        return true;
    }

    @Override
    public synchronized E remove() {
        if (this.isImmutable()) {
            throw new IllegalArgumentException("tried to remove from an immutable FCQueue");
        }
        if (this.size == 0) {
            throw new NoSuchElementException("tried to remove from an empty FCQueue");
        }
        Object element = this.head.element;
        this.head = this.head.next;
        --this.size;
        return element;
    }

    @Override
    public synchronized boolean offer(E o) {
        return this.add(o);
    }

    @Override
    public synchronized E poll() {
        if (this.size == 0) {
            return null;
        }
        return this.remove();
    }

    @Override
    public synchronized E element() {
        if (this.size == 0) {
            throw new NoSuchElementException("tried to get the head of an empty FCQueue");
        }
        return this.head.element;
    }

    @Override
    public synchronized E peek() {
        if (this.size == 0) {
            return null;
        }
        return this.head.element;
    }

    public synchronized FCQueue<E> copy() {
        if (this.isImmutable()) {
            throw new IllegalStateException("Tried to make a copy of an immutable FCQueue");
        }
        FCQueue<E> queue = new FCQueue<E>(this);
        this.setImmutable(true);
        return queue;
    }

    protected synchronized void destroyNode() {
        this.setImmutable(true);
        this.tail = null;
        this.head = null;
        this.size = 0;
        this.hash = NULL_HASH;
    }

    @Override
    public synchronized int size() {
        return this.size;
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public synchronized boolean contains(Object o) {
        for (FastCopyable e : this) {
            if (!Objects.equals(o, e)) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized Iterator<E> iterator() {
        return new Iterator<E>(){
            Node<E> cur;
            final Node<E> end;
            {
                this.cur = FCQueue.this.head;
                this.end = FCQueue.this.tail;
            }

            @Override
            public boolean hasNext() {
                return this.cur != this.end;
            }

            @Override
            public E next() {
                if (this.cur == null || this.cur == this.end) {
                    throw new NoSuchElementException();
                }
                Object result = this.cur.element;
                this.cur = this.cur.next;
                return result;
            }
        };
    }

    public Iterator<E> reverseIterator() {
        ArrayList list = new ArrayList(this);
        Collections.reverse(list);
        return list.iterator();
    }

    @Override
    public synchronized Object[] toArray() {
        Object[] result = new Object[this.size()];
        int i = 0;
        for (FastCopyable e : this) {
            result[i++] = e;
        }
        return result;
    }

    @Override
    public synchronized <T> T[] toArray(T[] a) {
        int currentSize = this.size();
        int i = 0;
        if (a.length < currentSize) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), currentSize);
        } else if (a.length > currentSize) {
            a[currentSize] = null;
        }
        for (FastCopyable e : this) {
            a[i++] = e;
        }
        return a;
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("FCQueue allows removal only from the head, not arbitrary removals");
    }

    @Override
    public synchronized boolean containsAll(Collection<?> c) {
        for (Object e : c) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public synchronized boolean addAll(Collection<? extends E> c) {
        for (FastCopyable e : c) {
            this.add((E)e);
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("FCQueue can only remove from the head");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("FCQueue can only remove from the head");
    }

    @Override
    public synchronized void clear() {
        this.throwIfImmutable();
        this.head = this.tail;
        this.size = 0;
        this.hash = null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FCQueue fcQueue = (FCQueue)o;
        return this.size == fcQueue.size && Objects.equals(this.getHash(), fcQueue.getHash());
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(this.size);
        result = 31 * result + Objects.hashCode(this.getHash());
        return result;
    }

    public synchronized void serialize(SerializableDataOutputStream out) throws IOException {
        this.detach();
        out.writeSerializableIterableWithSize(this.iterator(), this.size(), true, false);
    }

    private void detach() {
        if (this.head == null || this.tail == null || this.isMutable()) {
            return;
        }
        this.getHash();
        Node<E> src = this.head;
        Node dst = new Node();
        this.head = dst;
        while (src != this.tail) {
            dst.element = src.element;
            dst.runningHash = src.runningHash;
            dst.next = new Node();
            src = src.next;
            dst = dst.next;
        }
        dst.runningHash = src.runningHash;
        this.tail = dst;
    }

    public synchronized void deserialize(SerializableDataInputStream in, int version) throws IOException {
        in.readSerializableIterableWithSize(100000000, x$0 -> this.add((E)((FastCopyable)x$0)));
    }

    byte[] getHash(E element) {
        if (element == null) {
            return NULL_HASH_BYTES;
        }
        CRYPTOGRAPHY.digestSync((SerializableHashable)element);
        return CRYPTOGRAPHY.digestBytesSync((SelfSerializable)((SerializableHashable)element).getHash());
    }

    public long getClassId() {
        return 139236190103L;
    }

    public int getVersion() {
        return 3;
    }

    public int getMinimumSupportedVersion() {
        return 2;
    }

    static class Node<E extends FastCopyable> {
        E element;
        Node<E> next;
        volatile long[] runningHash;

        Node() {
        }
    }

    private static class ClassVersion {
        public static final int ORIGINAL = 1;
        public static final int MIGRATE_TO_SERIALIZABLE = 2;
        public static final int REMOVED_HASH = 3;

        private ClassVersion() {
        }
    }
}

