/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.metrics;

import com.swirlds.common.metrics.RunningAverageMetric;
import com.swirlds.common.metrics.extensions.CountPerSecond;
import com.swirlds.metrics.api.MetricConfig;
import com.swirlds.metrics.api.Metrics;
import com.swirlds.platform.gossip.shadowgraph.SyncResult;
import com.swirlds.platform.gossip.shadowgraph.SyncTiming;
import com.swirlds.platform.network.Connection;
import com.swirlds.platform.stats.AverageAndMax;
import com.swirlds.platform.stats.AverageAndMaxTimeStat;
import com.swirlds.platform.stats.AverageStat;
import com.swirlds.platform.stats.AverageTimeStat;
import com.swirlds.platform.stats.MaxStat;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.temporal.ChronoUnit;
import org.hiero.consensus.model.hashgraph.EventWindow;

public class SyncMetrics {
    private static final RunningAverageMetric.Config AVG_BYTES_PER_SEC_SYNC_CONFIG = new RunningAverageMetric.Config("platform", "bytes_per_sec_sync").withDescription("average number of bytes per second transferred during a sync");
    private final RunningAverageMetric avgBytesPerSecSync;
    private static final CountPerSecond.Config CALL_SYNCS_PER_SECOND_CONFIG = new CountPerSecond.Config("platform", "sync_per_secC").withDescription("(call syncs) syncs completed per second initiated by this member");
    private final CountPerSecond callSyncsPerSecond;
    private static final CountPerSecond.Config REC_SYNCS_PER_SECOND_CONFIG = new CountPerSecond.Config("platform", "sync_per_secR").withDescription("(receive syncs) syncs completed per second initiated by other member");
    private final CountPerSecond recSyncsPerSecond;
    private static final RunningAverageMetric.Config TIPS_PER_SYNC_CONFIG = new RunningAverageMetric.Config("internal", "tips_per_sync").withDescription("the average number of tips per sync at the start of each sync").withFormat("%,15.3f");
    private static final CountPerSecond.Config INCOMING_SYNC_REQUESTS_CONFIG = new CountPerSecond.Config("platform", "incomingSyncRequests_per_sec").withDescription("Incoming sync requests received per second");
    private final CountPerSecond incomingSyncRequestsPerSec;
    private static final CountPerSecond.Config ACCEPTED_SYNC_REQUESTS_CONFIG = new CountPerSecond.Config("platform", "acceptedSyncRequests_per_sec").withDescription("Incoming sync requests accepted per second");
    private final CountPerSecond acceptedSyncRequestsPerSec;
    private static final CountPerSecond.Config OPPORTUNITIES_TO_INITIATE_SYNC_CONFIG = new CountPerSecond.Config("platform", "opportunitiesToInitiateSync_per_sec").withDescription("Opportunities to initiate an outgoing sync per second");
    private final CountPerSecond opportunitiesToInitiateSyncPerSec;
    private static final CountPerSecond.Config OUTGOING_SYNC_REQUESTS_CONFIG = new CountPerSecond.Config("platform", "outgoingSyncRequests_per_sec").withDescription("Outgoing sync requests sent per second");
    private final CountPerSecond outgoingSyncRequestsPerSec;
    private static final CountPerSecond.Config SYNCS_PER_SECOND_CONFIG = new CountPerSecond.Config("platform", "syncs_per_sec").withDescription("Total number of syncs completed per second");
    private final CountPerSecond syncsPerSec;
    private static final RunningAverageMetric.Config SYNC_FILTER_TIME_CONFIG = new RunningAverageMetric.Config("platform", "syncFilterTime").withDescription("the average time spent filtering events during a sync").withUnit("nanoseconds");
    private static final CountPerSecond.Config DO_NOT_SYNC_PLATFORM_STATUS = new CountPerSecond.Config("platform", "doNotSyncPlatformStatus").withUnit("hz").withDescription("Number of times per second we do not sync because the platform status doesn't permit it");
    private final CountPerSecond doNoSyncPlatformStatus;
    private static final CountPerSecond.Config DO_NOT_SYNC_COOLDOWN_CONFIG = new CountPerSecond.Config("platform", "doNotSyncCooldown").withUnit("hz").withDescription("Number of times per second we do not sync because we are in sync cooldown");
    private final CountPerSecond doNotSyncCooldown;
    private static final CountPerSecond.Config DO_NOT_SYNC_HALTED_CONFIG = new CountPerSecond.Config("platform", "doNotSyncHalted").withUnit("hz").withDescription("Number of times per second we do not sync because gossip is halted");
    private final CountPerSecond doNotSyncHalted;
    private static final CountPerSecond.Config DO_NOT_SYNC_FALLEN_BEHIND_CONFIG = new CountPerSecond.Config("platform", "doNotSyncFallenBehind").withUnit("hz").withDescription("Number of times per second we do not sync because we have fallen behind");
    private final CountPerSecond doNotSyncFallenBehind;
    private static final CountPerSecond.Config DO_NOT_SYNC_NO_PERMITS_CONFIG = new CountPerSecond.Config("platform", "doNotSyncNoPermits").withUnit("hz").withDescription("Number of times per second we do not sync because we have no permits");
    private final CountPerSecond doNotSyncNoPermits;
    private static final CountPerSecond.Config DO_NOT_SYNC_INTAKE_COUNTER_CONFIG = new CountPerSecond.Config("platform", "doNotSyncIntakeCounter").withUnit("hz").withDescription("Number of times per second we do not sync because the intake counter is too high");
    private final CountPerSecond doNotSyncIntakeCounter;
    private final RunningAverageMetric tipsPerSync;
    private final AverageStat syncIndicatorDiff;
    private final AverageStat eventRecRate;
    private final AverageTimeStat avgSyncDuration1;
    private final AverageTimeStat avgSyncDuration2;
    private final AverageTimeStat avgSyncDuration3;
    private final AverageTimeStat avgSyncDuration4;
    private final AverageTimeStat avgSyncDuration5;
    private final AverageAndMaxTimeStat avgSyncDuration;
    private final AverageStat knownSetSize;
    private final AverageAndMax avgEventsPerSyncSent;
    private final AverageAndMax avgEventsPerSyncRec;
    private final MaxStat multiTipsPerSync;
    private final RunningAverageMetric syncFilterTime;

    public SyncMetrics(Metrics metrics) {
        this.avgBytesPerSecSync = (RunningAverageMetric)metrics.getOrCreate((MetricConfig)AVG_BYTES_PER_SEC_SYNC_CONFIG);
        this.callSyncsPerSecond = new CountPerSecond(metrics, CALL_SYNCS_PER_SECOND_CONFIG);
        this.recSyncsPerSecond = new CountPerSecond(metrics, REC_SYNCS_PER_SECOND_CONFIG);
        this.tipsPerSync = (RunningAverageMetric)metrics.getOrCreate((MetricConfig)TIPS_PER_SYNC_CONFIG);
        this.incomingSyncRequestsPerSec = new CountPerSecond(metrics, INCOMING_SYNC_REQUESTS_CONFIG);
        this.acceptedSyncRequestsPerSec = new CountPerSecond(metrics, ACCEPTED_SYNC_REQUESTS_CONFIG);
        this.opportunitiesToInitiateSyncPerSec = new CountPerSecond(metrics, OPPORTUNITIES_TO_INITIATE_SYNC_CONFIG);
        this.outgoingSyncRequestsPerSec = new CountPerSecond(metrics, OUTGOING_SYNC_REQUESTS_CONFIG);
        this.syncsPerSec = new CountPerSecond(metrics, SYNCS_PER_SECOND_CONFIG);
        this.syncFilterTime = (RunningAverageMetric)metrics.getOrCreate((MetricConfig)SYNC_FILTER_TIME_CONFIG);
        this.doNoSyncPlatformStatus = new CountPerSecond(metrics, DO_NOT_SYNC_PLATFORM_STATUS);
        this.doNotSyncCooldown = new CountPerSecond(metrics, DO_NOT_SYNC_COOLDOWN_CONFIG);
        this.doNotSyncHalted = new CountPerSecond(metrics, DO_NOT_SYNC_HALTED_CONFIG);
        this.doNotSyncFallenBehind = new CountPerSecond(metrics, DO_NOT_SYNC_FALLEN_BEHIND_CONFIG);
        this.doNotSyncNoPermits = new CountPerSecond(metrics, DO_NOT_SYNC_NO_PERMITS_CONFIG);
        this.doNotSyncIntakeCounter = new CountPerSecond(metrics, DO_NOT_SYNC_INTAKE_COUNTER_CONFIG);
        this.avgSyncDuration = new AverageAndMaxTimeStat(metrics, ChronoUnit.SECONDS, "internal", "sec_per_sync", "duration of average successful sync (in seconds)");
        this.avgEventsPerSyncSent = new AverageAndMax(metrics, "platform", "ev_per_syncS", "number of events sent per successful sync", "%,8.1f");
        this.avgEventsPerSyncRec = new AverageAndMax(metrics, "platform", "ev_per_syncR", "number of events received per successful sync", "%,8.1f");
        this.syncIndicatorDiff = new AverageStat(metrics, "internal", "syncIndicatorDiff", "number of ancient indicators ahead (positive) or behind (negative) when syncing", "%,8.1f", 0.1);
        this.eventRecRate = new AverageStat(metrics, "internal", "eventRecRate", "the rate at which we receive and enqueue events in ev/sec", "%,8.1f", 0.1);
        this.avgSyncDuration1 = new AverageTimeStat(metrics, ChronoUnit.SECONDS, "internal", "sec_per_sync1", "duration of step 1 of average successful sync (in seconds)");
        this.avgSyncDuration2 = new AverageTimeStat(metrics, ChronoUnit.SECONDS, "internal", "sec_per_sync2", "duration of step 2 of average successful sync (in seconds)");
        this.avgSyncDuration3 = new AverageTimeStat(metrics, ChronoUnit.SECONDS, "internal", "sec_per_sync3", "duration of step 3 of average successful sync (in seconds)");
        this.avgSyncDuration4 = new AverageTimeStat(metrics, ChronoUnit.SECONDS, "internal", "sec_per_sync4", "duration of step 4 of average successful sync (in seconds)");
        this.avgSyncDuration5 = new AverageTimeStat(metrics, ChronoUnit.SECONDS, "internal", "sec_per_sync5", "duration of step 5 of average successful sync (in seconds)");
        this.knownSetSize = new AverageStat(metrics, "platform", "knownSetSize", "the average size of the known set during a sync", "%,10.3f", 0.1);
        this.multiTipsPerSync = new MaxStat(metrics, "platform", "multiTips_per_sync", "the number of creators that have more than one tip at the start of each sync", "%5d");
    }

    public void eventWindow(@NonNull EventWindow self, @NonNull EventWindow other) {
        this.syncIndicatorDiff.update(self.ancientThreshold() - other.ancientThreshold());
    }

    public void eventsReceived(long nanosStart, int numberReceived) {
        if (numberReceived == 0) {
            return;
        }
        double nanos = (double)System.nanoTime() - (double)nanosStart;
        double seconds = nanos / (double)ChronoUnit.SECONDS.getDuration().toNanos();
        this.eventRecRate.update(Math.round((double)numberReceived / seconds));
    }

    public void recordSyncTiming(SyncTiming timing, Connection conn) {
        this.avgSyncDuration1.update(timing.getTimePoint(0), timing.getTimePoint(1));
        this.avgSyncDuration2.update(timing.getTimePoint(1), timing.getTimePoint(2));
        this.avgSyncDuration3.update(timing.getTimePoint(2), timing.getTimePoint(3));
        this.avgSyncDuration4.update(timing.getTimePoint(3), timing.getTimePoint(4));
        this.avgSyncDuration5.update(timing.getTimePoint(4), timing.getTimePoint(5));
        this.avgSyncDuration.update(timing.getTimePoint(0), timing.getTimePoint(5));
        double syncDurationSec = (double)timing.getPointDiff(5, 0) * 1.0E-9;
        double speed = (double)Math.max(conn.getDis().getSyncByteCounter().getCount(), conn.getDos().getSyncByteCounter().getCount()) / syncDurationSec;
        this.avgBytesPerSecSync.update(speed);
    }

    public void knownSetSize(int knownSetSize) {
        this.knownSetSize.update(knownSetSize);
    }

    public void syncDone(SyncResult info) {
        if (info.isCaller()) {
            this.callSyncsPerSecond.count();
        } else {
            this.recSyncsPerSecond.count();
        }
        this.syncsPerSec.count();
        this.avgEventsPerSyncSent.update(info.getEventsWritten());
        this.avgEventsPerSyncRec.update(info.getEventsRead());
    }

    public void updateMultiTipsPerSync(int multiTipCount) {
        this.multiTipsPerSync.update(multiTipCount);
    }

    public void updateTipsPerSync(int tipCount) {
        this.tipsPerSync.update((double)tipCount);
    }

    public void incomingSyncRequestReceived() {
        this.incomingSyncRequestsPerSec.count();
    }

    public void acceptedSyncRequest() {
        this.acceptedSyncRequestsPerSec.count();
    }

    public void opportunityToInitiateSync() {
        this.opportunitiesToInitiateSyncPerSec.count();
    }

    public void outgoingSyncRequestSent() {
        this.outgoingSyncRequestsPerSec.count();
    }

    public void recordSyncFilterTime(long nanoseconds) {
        this.syncFilterTime.update((double)nanoseconds);
    }

    public void doNotSyncPlatformStatus() {
        this.doNoSyncPlatformStatus.count();
    }

    public void doNotSyncCooldown() {
        this.doNotSyncCooldown.count();
    }

    public void doNotSyncHalted() {
        this.doNotSyncHalted.count();
    }

    public void doNotSyncFallenBehind() {
        this.doNotSyncFallenBehind.count();
    }

    public void doNotSyncNoPermits() {
        this.doNotSyncNoPermits.count();
    }

    public void doNotSyncIntakeCounter() {
        this.doNotSyncIntakeCounter.count();
    }
}

