/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.io.streams;

import com.swirlds.base.function.CheckedFunction;
import com.swirlds.common.io.streams.MerkleDataInputStream;
import com.swirlds.common.io.streams.internal.SerializationOperation;
import com.swirlds.common.io.streams.internal.SerializationStack;
import com.swirlds.common.merkle.MerkleNode;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import org.hiero.base.ValueReference;
import org.hiero.base.io.SelfSerializable;

public class DebuggableMerkleDataInputStream
extends MerkleDataInputStream {
    private static final int STACK_TRACE_OFFSET = 3;
    private final SerializationStack stack;

    public DebuggableMerkleDataInputStream(InputStream in) {
        super(in);
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        StackTraceElement callLocation = stackTrace[3];
        this.stack = new SerializationStack(callLocation);
    }

    public String getFormattedStackTrace() {
        return this.stack.generateSerializationStackTrace();
    }

    public SerializationStack getStack() {
        return this.stack;
    }

    private void startOperation(SerializationOperation operation) {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        StackTraceElement callLocation = stackTrace[3];
        this.stack.startOperation(operation, callLocation);
    }

    private void finishOperation() {
        this.stack.finishOperation();
    }

    protected void recordClassId(long classId) {
        this.stack.setClassId(classId);
    }

    protected void recordClass(Object o) {
        if (o != null) {
            this.stack.setClass(o.getClass());
        }
    }

    private <T> T recordStringRepresentation(T value) {
        this.stack.setStringRepresentation(Objects.toString(value));
        return value;
    }

    public int read() throws IOException {
        this.startOperation(SerializationOperation.READ);
        try {
            int n = super.read();
            return n;
        }
        finally {
            this.finishOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long skip(long n) throws IOException {
        this.startOperation(SerializationOperation.SKIP);
        this.recordStringRepresentation(n);
        try {
            long l = super.skip(n);
            return l;
        }
        finally {
            this.finishOperation();
        }
    }

    @NonNull
    public byte[] readAllBytes() throws IOException {
        this.startOperation(SerializationOperation.READ_ALL_BYTES);
        try {
            byte[] byArray = super.readAllBytes();
            return byArray;
        }
        finally {
            this.finishOperation();
        }
    }

    @NonNull
    public byte[] readNBytes(int len) throws IOException {
        this.startOperation(SerializationOperation.READ_N_BYTES);
        try {
            byte[] byArray = super.readNBytes(len);
            return byArray;
        }
        finally {
            this.finishOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readNBytes(@NonNull byte[] b, int off, int len) throws IOException {
        this.startOperation(SerializationOperation.READ_N_BYTES_ARRAY);
        try {
            int n = super.readNBytes(b, off, len);
            return n;
        }
        finally {
            this.finishOperation();
        }
    }

    public int skipBytes(int n) throws IOException {
        this.startOperation(SerializationOperation.SKIP_BYTES);
        try {
            int n2 = super.skipBytes(n);
            return n2;
        }
        finally {
            this.finishOperation();
        }
    }

    public void skipNBytes(long n) throws IOException {
        this.startOperation(SerializationOperation.SKIP_N_BYTES);
        try {
            super.skipNBytes(n);
        }
        finally {
            this.finishOperation();
        }
    }

    public void readFully(@NonNull byte[] b) throws IOException {
        this.startOperation(SerializationOperation.READ_FULLY);
        try {
            super.readFully(b);
        }
        finally {
            this.finishOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFully(@NonNull byte[] b, int off, int len) throws IOException {
        this.startOperation(SerializationOperation.READ_FULLY_OFFSET);
        try {
            super.readFully(b, off, len);
        }
        finally {
            this.finishOperation();
        }
    }

    public boolean readBoolean() throws IOException {
        this.startOperation(SerializationOperation.READ_BOOLEAN);
        try {
            boolean bl = this.recordStringRepresentation(super.readBoolean());
            return bl;
        }
        finally {
            this.finishOperation();
        }
    }

    public byte readByte() throws IOException {
        this.startOperation(SerializationOperation.READ_BYTE);
        try {
            byte by = this.recordStringRepresentation(super.readByte());
            return by;
        }
        finally {
            this.finishOperation();
        }
    }

    public int readUnsignedByte() throws IOException {
        this.startOperation(SerializationOperation.READ_UNSIGNED_BYTE);
        try {
            int n = this.recordStringRepresentation(super.readUnsignedByte());
            return n;
        }
        finally {
            this.finishOperation();
        }
    }

    public short readShort() throws IOException {
        this.startOperation(SerializationOperation.READ_SHORT);
        try {
            short s = this.recordStringRepresentation(super.readShort());
            return s;
        }
        finally {
            this.finishOperation();
        }
    }

    public int readUnsignedShort() throws IOException {
        this.startOperation(SerializationOperation.READ_UNSIGNED_SHORT);
        try {
            int n = this.recordStringRepresentation(super.readUnsignedShort());
            return n;
        }
        finally {
            this.finishOperation();
        }
    }

    public char readChar() throws IOException {
        this.startOperation(SerializationOperation.READ_CHAR);
        try {
            char c = this.recordStringRepresentation(Character.valueOf(super.readChar())).charValue();
            return c;
        }
        finally {
            this.finishOperation();
        }
    }

    public int readInt() throws IOException {
        this.startOperation(SerializationOperation.READ_INT);
        try {
            int n = this.recordStringRepresentation(super.readInt());
            return n;
        }
        finally {
            this.finishOperation();
        }
    }

    public long readLong() throws IOException {
        this.startOperation(SerializationOperation.READ_LONG);
        try {
            long l = this.recordStringRepresentation(super.readLong());
            return l;
        }
        finally {
            this.finishOperation();
        }
    }

    public float readFloat() throws IOException {
        this.startOperation(SerializationOperation.READ_FLOAT);
        try {
            float f = this.recordStringRepresentation(Float.valueOf(super.readFloat())).floatValue();
            return f;
        }
        finally {
            this.finishOperation();
        }
    }

    public double readDouble() throws IOException {
        this.startOperation(SerializationOperation.READ_DOUBLE);
        try {
            double d = this.recordStringRepresentation(super.readDouble());
            return d;
        }
        finally {
            this.finishOperation();
        }
    }

    @NonNull
    public String readUTF() throws IOException {
        this.startOperation(SerializationOperation.READ_UTF);
        try {
            String string = this.recordStringRepresentation(super.readUTF());
            return string;
        }
        finally {
            this.finishOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readByteArray(int maxLength, boolean readChecksum) throws IOException {
        this.startOperation(SerializationOperation.READ_BYTE_ARRAY);
        try {
            byte[] byArray = super.readByteArray(maxLength, readChecksum);
            return byArray;
        }
        finally {
            this.finishOperation();
        }
    }

    public byte[] readByteArray(int maxLength) throws IOException {
        this.startOperation(SerializationOperation.READ_BYTE_ARRAY);
        try {
            byte[] byArray = super.readByteArray(maxLength);
            return byArray;
        }
        finally {
            this.finishOperation();
        }
    }

    public int[] readIntArray(int maxLength) throws IOException {
        this.startOperation(SerializationOperation.READ_INT_LIST);
        try {
            int[] nArray = super.readIntArray(maxLength);
            return nArray;
        }
        finally {
            this.finishOperation();
        }
    }

    public List<Integer> readIntList(int maxLength) throws IOException {
        this.startOperation(SerializationOperation.READ_INT_LIST);
        try {
            List list = super.readIntList(maxLength);
            return list;
        }
        finally {
            this.finishOperation();
        }
    }

    public long[] readLongArray(int maxLength) throws IOException {
        this.startOperation(SerializationOperation.READ_LONG_LIST);
        try {
            long[] lArray = super.readLongArray(maxLength);
            return lArray;
        }
        finally {
            this.finishOperation();
        }
    }

    public List<Long> readLongList(int maxLength) throws IOException {
        this.startOperation(SerializationOperation.READ_LONG_LIST);
        try {
            List list = super.readLongList(maxLength);
            return list;
        }
        finally {
            this.finishOperation();
        }
    }

    public List<Boolean> readBooleanList(int maxLength) throws IOException {
        this.startOperation(SerializationOperation.READ_BOOLEAN_LIST);
        try {
            List list = super.readBooleanList(maxLength);
            return list;
        }
        finally {
            this.finishOperation();
        }
    }

    public float[] readFloatArray(int maxLength) throws IOException {
        this.startOperation(SerializationOperation.READ_FLOAT_LIST);
        try {
            float[] fArray = super.readFloatArray(maxLength);
            return fArray;
        }
        finally {
            this.finishOperation();
        }
    }

    public List<Float> readFloatList(int maxLength) throws IOException {
        this.startOperation(SerializationOperation.READ_FLOAT_LIST);
        try {
            List list = super.readFloatList(maxLength);
            return list;
        }
        finally {
            this.finishOperation();
        }
    }

    public double[] readDoubleArray(int maxLength) throws IOException {
        this.startOperation(SerializationOperation.READ_DOUBLE_LIST);
        try {
            double[] dArray = super.readDoubleArray(maxLength);
            return dArray;
        }
        finally {
            this.finishOperation();
        }
    }

    public List<Double> readDoubleList(int maxLength) throws IOException {
        this.startOperation(SerializationOperation.READ_DOUBLE_LIST);
        try {
            List list = super.readDoubleList(maxLength);
            return list;
        }
        finally {
            this.finishOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] readStringArray(int maxLength, int maxStringLength) throws IOException {
        this.startOperation(SerializationOperation.READ_STRING_LIST);
        try {
            String[] stringArray = super.readStringArray(maxLength, maxStringLength);
            return stringArray;
        }
        finally {
            this.finishOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> readStringList(int maxLength, int maxStringLength) throws IOException {
        this.startOperation(SerializationOperation.READ_STRING_LIST);
        try {
            List list = super.readStringList(maxLength, maxStringLength);
            return list;
        }
        finally {
            this.finishOperation();
        }
    }

    public Instant readInstant() throws IOException {
        this.startOperation(SerializationOperation.READ_INSTANT);
        try {
            Instant instant = this.recordStringRepresentation(super.readInstant());
            return instant;
        }
        finally {
            this.finishOperation();
        }
    }

    public String readNormalisedString(int maxLength) throws IOException {
        this.startOperation(SerializationOperation.READ_NORMALISED_STRING);
        try {
            String string = super.readNormalisedString(maxLength);
            return string;
        }
        finally {
            this.finishOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends MerkleNode> T readMerkleTree(Path directory, int maxNumberOfNodes) throws IOException {
        this.startOperation(SerializationOperation.READ_MERKLE_TREE);
        try {
            Object t = super.readMerkleTree(directory, maxNumberOfNodes);
            return t;
        }
        finally {
            this.finishOperation();
        }
    }

    @Override
    protected void readNextNode(Path directory, Map<Long, Integer> deserializedVersions) throws IOException {
        this.startOperation(SerializationOperation.READ_MERKLE_NODE);
        try {
            super.readNextNode(directory, deserializedVersions);
        }
        finally {
            this.finishOperation();
        }
    }

    public <T extends SelfSerializable> T readSerializable() throws IOException {
        this.startOperation(SerializationOperation.READ_SERIALIZABLE);
        try {
            SelfSerializable selfSerializable = super.readSerializable();
            return (T)selfSerializable;
        }
        finally {
            this.finishOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends SelfSerializable> T readSerializable(boolean readClassId, @NonNull Supplier<T> serializableConstructor) throws IOException {
        this.startOperation(SerializationOperation.READ_SERIALIZABLE);
        try {
            SelfSerializable selfSerializable = super.readSerializable(readClassId, serializableConstructor);
            return (T)selfSerializable;
        }
        finally {
            this.finishOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends SelfSerializable> void readSerializableIterableWithSize(int maxSize, @NonNull Consumer<T> callback, @Nullable Set<Long> permissibleClassIds) throws IOException {
        this.startOperation(SerializationOperation.READ_SERIALIZABLE_LIST);
        try {
            super.readSerializableIterableWithSize(maxSize, callback, permissibleClassIds);
        }
        finally {
            this.finishOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends SelfSerializable> void readSerializableIterableWithSize(int size, boolean readClassId, @NonNull Supplier<T> serializableConstructor, @NonNull Consumer<T> callback, @Nullable Set<Long> permissibleClassIds) throws IOException {
        this.startOperation(SerializationOperation.READ_SERIALIZABLE_LIST);
        try {
            super.readSerializableIterableWithSize(size, readClassId, serializableConstructor, callback, permissibleClassIds);
        }
        finally {
            this.finishOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T extends SelfSerializable> T readNextSerializableIteration(boolean allSameClass, boolean readClassId, @NonNull ValueReference<Long> classId, @NonNull ValueReference<Integer> version, @NonNull CheckedFunction<Long, T, IOException> serializableConstructor, @Nullable Set<Long> permissibleClassIds) throws IOException {
        this.startOperation(SerializationOperation.READ_SERIALIZABLE);
        try {
            SelfSerializable selfSerializable = super.readNextSerializableIteration(allSameClass, readClassId, classId, version, serializableConstructor, permissibleClassIds);
            return (T)selfSerializable;
        }
        finally {
            this.finishOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends SelfSerializable> List<T> readSerializableList(int maxListSize, @Nullable Set<Long> permissibleClassIds) throws IOException {
        this.startOperation(SerializationOperation.READ_SERIALIZABLE_LIST);
        try {
            List list = super.readSerializableList(maxListSize, permissibleClassIds);
            return list;
        }
        finally {
            this.finishOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends SelfSerializable> List<T> readSerializableList(int maxListSize, boolean readClassId, @NonNull Supplier<T> serializableConstructor, @Nullable Set<Long> permissibleClassIds) throws IOException {
        this.startOperation(SerializationOperation.READ_SERIALIZABLE_LIST);
        try {
            List list = super.readSerializableList(maxListSize, readClassId, serializableConstructor, permissibleClassIds);
            return list;
        }
        finally {
            this.finishOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends SelfSerializable> T[] readSerializableArray(@NonNull IntFunction<T[]> arrayConstructor, int maxListSize, boolean readClassId, @Nullable Set<Long> permissibleClassIds) throws IOException {
        this.startOperation(SerializationOperation.READ_SERIALIZABLE_LIST);
        try {
            SelfSerializable[] selfSerializableArray = super.readSerializableArray(arrayConstructor, maxListSize, readClassId, permissibleClassIds);
            return selfSerializableArray;
        }
        finally {
            this.finishOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends SelfSerializable> T[] readSerializableArray(@NonNull IntFunction<T[]> arrayConstructor, int maxListSize, boolean readClassId, @NonNull Supplier<T> serializableConstructor, @Nullable Set<Long> permissibleClassIds) throws IOException {
        this.startOperation(SerializationOperation.READ_SERIALIZABLE_LIST);
        try {
            SelfSerializable[] selfSerializableArray = super.readSerializableArray(arrayConstructor, maxListSize, readClassId, serializableConstructor, permissibleClassIds);
            return selfSerializableArray;
        }
        finally {
            this.finishOperation();
        }
    }
}

