/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.internal;

import com.swirlds.platform.consensus.CandidateWitness;
import com.swirlds.platform.consensus.DeGen;
import com.swirlds.platform.event.EventCounter;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.hiero.base.Clearable;
import org.hiero.base.crypto.Hash;
import org.hiero.consensus.model.event.EventDescriptorWrapper;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.node.NodeId;

public class EventImpl
implements Clearable {
    private final PlatformEvent baseEvent;
    private long roundReceived = -1L;
    private EventImpl selfParent;
    private EventImpl otherParent;
    private boolean cleared = false;
    private boolean isWitness;
    private boolean isFamous;
    private boolean isFameDecided;
    private boolean isJudge;
    private boolean isConsensus;
    private Instant preliminaryConsensusTimestamp;
    private EventImpl[] lastSee;
    private EventImpl[] stronglySeeP;
    private EventImpl firstSelfWitnessS;
    private EventImpl firstWitnessS;
    private int mark;
    private List<Instant> recTimes;
    private long roundCreated = -1L;
    private boolean[] votes;
    private int cGen = 0;
    private int deGen = 0;

    public EventImpl(@NonNull PlatformEvent platformEvent, @Nullable EventImpl selfParent, @Nullable EventImpl otherParent) {
        Objects.requireNonNull(platformEvent, "baseEvent");
        this.selfParent = selfParent;
        this.otherParent = otherParent;
        this.mark = 0;
        this.baseEvent = platformEvent;
    }

    @NonNull
    public PlatformEvent getBaseEvent() {
        return this.baseEvent;
    }

    public long getRoundReceived() {
        return this.roundReceived;
    }

    public void setRoundReceived(long roundReceived) {
        this.roundReceived = roundReceived;
    }

    @Nullable
    public EventImpl getSelfParent() {
        return this.selfParent;
    }

    public void setSelfParent(@Nullable EventImpl selfParent) {
        this.selfParent = selfParent;
    }

    @Nullable
    public EventImpl getOtherParent() {
        return this.otherParent;
    }

    public void setOtherParent(@Nullable EventImpl otherParent) {
        this.otherParent = otherParent;
    }

    public boolean isWitness() {
        return this.isWitness;
    }

    public void setWitness(boolean witness) {
        this.isWitness = witness;
    }

    public boolean isFamous() {
        return this.isFamous;
    }

    public void setFamous(boolean famous) {
        this.isFamous = famous;
    }

    public boolean isFameDecided() {
        return this.isFameDecided;
    }

    public void setFameDecided(boolean fameDecided) {
        this.isFameDecided = fameDecided;
    }

    public boolean isJudge() {
        return this.isJudge;
    }

    public void setJudgeTrue() {
        this.isJudge = true;
    }

    public boolean isConsensus() {
        return this.isConsensus;
    }

    public void setConsensus(boolean consensus) {
        this.isConsensus = consensus;
    }

    @Nullable
    public Instant getPreliminaryConsensusTimestamp() {
        return this.preliminaryConsensusTimestamp;
    }

    public void setPreliminaryConsensusTimestamp(@Nullable Instant preliminaryConsensusTimestamp) {
        this.preliminaryConsensusTimestamp = preliminaryConsensusTimestamp;
    }

    @Nullable
    public EventImpl getLastSee(int m) {
        return this.lastSee[m];
    }

    public void setLastSee(int m, @Nullable EventImpl event) {
        this.lastSee[m] = event;
    }

    public void initLastSee(int n) {
        this.lastSee = n == 0 ? null : new EventImpl[n];
    }

    public int sizeLastSee() {
        return this.lastSee == null ? 0 : this.lastSee.length;
    }

    @Nullable
    public EventImpl getStronglySeeP(int m) {
        return this.stronglySeeP[m];
    }

    public EventImpl[] getStronglySeeP() {
        return this.stronglySeeP;
    }

    public void setStronglySeeP(int m, @Nullable EventImpl event) {
        this.stronglySeeP[m] = event;
    }

    public void initStronglySeeP(int n) {
        this.stronglySeeP = n == 0 ? null : new EventImpl[n];
    }

    public int sizeStronglySeeP() {
        return this.stronglySeeP == null ? 0 : this.stronglySeeP.length;
    }

    @Nullable
    public EventImpl getFirstSelfWitnessS() {
        return this.firstSelfWitnessS;
    }

    public void setFirstSelfWitnessS(@Nullable EventImpl firstSelfWitnessS) {
        this.firstSelfWitnessS = firstSelfWitnessS;
    }

    @Nullable
    public EventImpl getFirstWitnessS() {
        return this.firstWitnessS;
    }

    public void setFirstWitnessS(@Nullable EventImpl firstWitnessS) {
        this.firstWitnessS = firstWitnessS;
    }

    public int getMark() {
        return this.mark;
    }

    public void setMark(int mark) {
        this.mark = mark;
    }

    @Nullable
    public List<Instant> getRecTimes() {
        return this.recTimes;
    }

    public void setRecTimes(@Nullable List<Instant> recTimes) {
        this.recTimes = recTimes;
    }

    public long getRoundCreated() {
        return this.roundCreated;
    }

    public void setRoundCreated(long roundCreated) {
        this.roundCreated = roundCreated;
    }

    public void initVoting(int numWitnesses) {
        if (this.votes == null || this.votes.length < numWitnesses) {
            this.votes = new boolean[numWitnesses];
            return;
        }
        Arrays.fill(this.votes, false);
    }

    public boolean getVote(@NonNull CandidateWitness witness) {
        return this.votes != null && this.votes.length > witness.getElectionIndex() && this.votes[witness.getElectionIndex()];
    }

    public boolean getVote(int electionIndex) {
        return this.votes != null && this.votes.length > electionIndex && this.votes[electionIndex];
    }

    public int getVotesSize() {
        return this.votes == null ? 0 : this.votes.length;
    }

    public void setVote(@NonNull CandidateWitness witness, boolean vote) {
        this.votes[witness.getElectionIndex()] = vote;
    }

    public void clear() {
        if (this.cleared) {
            return;
        }
        this.cleared = true;
        EventCounter.decrementLinkedEventCount();
        this.selfParent = null;
        this.otherParent = null;
        this.clearMetadata();
    }

    public void clearMetadata() {
        this.clearJudgeFlags();
        this.clearNonJudgeMetadata();
        DeGen.clearDeGen(this);
    }

    private void clearJudgeFlags() {
        this.setWitness(false);
        this.setFamous(false);
        this.setFameDecided(false);
        this.isJudge = false;
    }

    private void clearNonJudgeMetadata() {
        this.initLastSee(0);
        this.initStronglySeeP(0);
        this.setFirstSelfWitnessS(null);
        this.setFirstWitnessS(null);
        this.setRecTimes(null);
    }

    public boolean hasSelfParent() {
        return this.baseEvent.getSelfParent() != null;
    }

    public boolean hasOtherParent() {
        return !this.baseEvent.getOtherParents().isEmpty();
    }

    public Instant getTimeCreated() {
        return this.baseEvent.getTimeCreated();
    }

    public Hash getBaseHash() {
        return this.baseEvent.getHash();
    }

    public Instant getConsensusTimestamp() {
        return this.baseEvent.getConsensusTimestamp();
    }

    @Deprecated(forRemoval=true)
    public long getGeneration() {
        return this.baseEvent.getGeneration();
    }

    public long getNGen() {
        return this.baseEvent.getNGen();
    }

    public long getBirthRound() {
        return this.baseEvent.getBirthRound();
    }

    @NonNull
    public NodeId getCreatorId() {
        return this.baseEvent.getCreatorId();
    }

    public int getCGen() {
        return this.cGen;
    }

    public void setCGen(int cGen) {
        this.cGen = cGen;
    }

    public int getDeGen() {
        return this.deGen;
    }

    public void setDeGen(int deGen) {
        this.deGen = deGen;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventImpl event = (EventImpl)o;
        return Objects.equals(this.baseEvent, event.baseEvent) && this.roundReceived == event.roundReceived;
    }

    public int hashCode() {
        return Objects.hash(this.baseEvent, this.roundReceived);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.baseEvent.getDescriptor().shortString(sb);
        List allParents = this.baseEvent.getAllParents();
        for (EventDescriptorWrapper parent : allParents) {
            parent.shortString(sb);
        }
        return sb.toString();
    }

    public String shortString() {
        return this.baseEvent.getDescriptor().shortString();
    }
}

