/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.support;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import org.apiguardian.api.API;
import org.junit.jupiter.params.support.AnnotationConsumer;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.ReflectionUtils;

@API(status=API.Status.INTERNAL, since="5.0")
public final class AnnotationConsumerInitializer {
    private static final List<AnnotationConsumingMethodSignature> annotationConsumingMethodSignatures = Arrays.asList(new AnnotationConsumingMethodSignature("accept", 1, 0), new AnnotationConsumingMethodSignature("provideArguments", 2, 1), new AnnotationConsumingMethodSignature("convert", 3, 2));

    private AnnotationConsumerInitializer() {
    }

    public static <T> T initialize(AnnotatedElement annotatedElement, T annotationConsumerInstance) {
        if (annotationConsumerInstance instanceof AnnotationConsumer) {
            Class<Annotation> annotationType = AnnotationConsumerInitializer.findConsumedAnnotationType(annotationConsumerInstance);
            Annotation annotation = (Annotation)AnnotationUtils.findAnnotation((AnnotatedElement)annotatedElement, annotationType).orElseThrow(() -> new JUnitException(annotationConsumerInstance.getClass().getName() + " must be used with an annotation of type " + annotationType.getName()));
            AnnotationConsumerInitializer.initializeAnnotationConsumer((AnnotationConsumer)annotationConsumerInstance, annotation);
        }
        return annotationConsumerInstance;
    }

    private static <T> Class<? extends Annotation> findConsumedAnnotationType(T annotationConsumerInstance) {
        Predicate consumesAnnotation = annotationConsumingMethodSignatures.stream().map(signature -> signature::isMatchingWith).reduce(method -> false, Predicate::or);
        Method method2 = (Method)ReflectionUtils.findMethods(annotationConsumerInstance.getClass(), (Predicate)consumesAnnotation, (ReflectionUtils.HierarchyTraversalMode)ReflectionUtils.HierarchyTraversalMode.BOTTOM_UP).get(0);
        return AnnotationConsumerInitializer.getAnnotationType(method2);
    }

    private static Class<? extends Annotation> getAnnotationType(Method method) {
        int annotationIndex = annotationConsumingMethodSignatures.stream().filter(signature -> signature.isMatchingWith(method)).findFirst().map(AnnotationConsumingMethodSignature::getAnnotationParameterIndex).orElse(0);
        return method.getParameterTypes()[annotationIndex];
    }

    private static <A extends Annotation> void initializeAnnotationConsumer(AnnotationConsumer<A> instance, A annotation) {
        try {
            instance.accept(annotation);
        }
        catch (Exception ex) {
            throw new JUnitException("Failed to initialize AnnotationConsumer: " + instance, (Throwable)ex);
        }
    }

    private static class AnnotationConsumingMethodSignature {
        private final String methodName;
        private final int parameterCount;
        private final int annotationParameterIndex;

        AnnotationConsumingMethodSignature(String methodName, int parameterCount, int annotationParameterIndex) {
            this.methodName = methodName;
            this.parameterCount = parameterCount;
            this.annotationParameterIndex = annotationParameterIndex;
        }

        boolean isMatchingWith(Method method) {
            return method.getName().equals(this.methodName) && method.getParameterCount() == this.parameterCount && method.getParameterTypes()[this.annotationParameterIndex].isAnnotation();
        }

        int getAnnotationParameterIndex() {
            return this.annotationParameterIndex;
        }
    }
}

