/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.stats.signing;

import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.demo.stats.signing.TransactionCodec;
import com.swirlds.demo.stats.signing.algorithms.ExtendedSignature;
import com.swirlds.demo.stats.signing.algorithms.SigningAlgorithm;
import com.swirlds.demo.stats.signing.algorithms.X25519SigningAlgorithm;
import com.swirlds.logging.legacy.LogMarker;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.crypto.TransactionSignature;
import org.hiero.consensus.model.node.NodeId;

final class SttTransactionPool {
    private static final Logger logger = LogManager.getLogger(SttTransactionPool.class);
    private final byte[][] transactions;
    private final int transactionSize;
    private final boolean signed;
    private final Random random;
    private final List<SigningAlgorithm> enabledAlgorithms;
    private final Map<Byte, SigningAlgorithm> activeAlgorithms;
    private final NodeId nodeId;

    SttTransactionPool(@NonNull NodeId nodeId, int poolSize, int transactionSize, boolean signed, SigningAlgorithm ... enabledAlgorithms) {
        if (poolSize < 1) {
            throw new IllegalArgumentException("poolSize");
        }
        if (transactionSize < 1) {
            throw new IllegalArgumentException("transactionSize");
        }
        this.random = new Random();
        this.signed = signed;
        this.nodeId = Objects.requireNonNull(nodeId);
        this.transactionSize = transactionSize;
        this.transactions = new byte[poolSize][];
        this.enabledAlgorithms = new ArrayList<SigningAlgorithm>();
        this.activeAlgorithms = new HashMap<Byte, SigningAlgorithm>();
        if (enabledAlgorithms != null && enabledAlgorithms.length > 0) {
            this.enabledAlgorithms.addAll(Arrays.asList(enabledAlgorithms));
        } else {
            this.enabledAlgorithms.add(new X25519SigningAlgorithm());
        }
        this.init();
    }

    TransactionSignature expandSignatures(Bytes tx) {
        if (!TransactionCodec.txIsSigned(tx)) {
            return null;
        }
        return TransactionCodec.extractSignature(tx);
    }

    byte[] transaction() {
        return this.transactions[this.random.nextInt(this.transactions.length)];
    }

    private void init() {
        if (this.signed) {
            this.tryAcquirePrimitives();
        }
        ArrayList<SigningAlgorithm> algorithms = new ArrayList<SigningAlgorithm>(this.activeAlgorithms.values());
        int lastChosenAlg = 0;
        long transactionId = this.nodeId.id() * (long)this.transactions.length;
        for (int i = 0; i < this.transactions.length; ++i) {
            byte[] data = new byte[this.transactionSize];
            this.random.nextBytes(data);
            if (this.signed && !algorithms.isEmpty()) {
                SigningAlgorithm alg = (SigningAlgorithm)algorithms.get(lastChosenAlg);
                if (++lastChosenAlg >= algorithms.size()) {
                    lastChosenAlg = 0;
                }
                try {
                    ExtendedSignature exSig = alg.signEx(data, 0, data.length);
                    byte[] sig = exSig.getSignature();
                    this.transactions[i] = TransactionCodec.encode(alg, transactionId, sig, data);
                }
                catch (SignatureException e) {
                    logger.error(LogMarker.EXCEPTION.getMarker(), "Failed to Sign Transaction (Proceeding As Unsigned) [ id = {} ]", (Object)transactionId, (Object)e);
                    this.transactions[i] = TransactionCodec.encode(null, transactionId, null, data);
                }
            } else {
                this.transactions[i] = TransactionCodec.encode(null, transactionId, null, data);
            }
            ++transactionId;
        }
    }

    private void tryAcquirePrimitives() {
        for (SigningAlgorithm algorithm : this.enabledAlgorithms) {
            try {
                if (algorithm == null) continue;
                if (this.activeAlgorithms.containsKey(algorithm.getId())) {
                    throw new IllegalStateException(String.format("Duplicate signing algorithm specified [ id = %s ]", algorithm.getId()));
                }
                algorithm.tryAcquirePrimitives();
                if (!algorithm.isAvailable()) continue;
                this.activeAlgorithms.put(algorithm.getId(), algorithm);
            }
            catch (Exception ex) {
                logger.error(LogMarker.EXCEPTION.getMarker(), "Failed to Activate Signing Algorithm [ id = {}, class = {} ]", (Object)algorithm.getId(), (Object)algorithm.getClass().getName(), (Object)ex);
            }
        }
    }
}

