/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.matchers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.mockito.ArgumentMatcher;
import org.mockito.internal.exceptions.Reporter;
import org.mockito.internal.matchers.CapturesArguments;
import org.mockito.internal.util.Primitives;

public class CapturingMatcher<T>
implements ArgumentMatcher<T>,
CapturesArguments,
Serializable {
    private final Class<? extends T> clazz;
    private final List<T> arguments = new ArrayList<T>();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock readLock = this.lock.readLock();
    private final Lock writeLock = this.lock.writeLock();

    public CapturingMatcher(Class<? extends T> clazz) {
        this.clazz = Objects.requireNonNull(clazz);
    }

    @Override
    public boolean matches(Object argument) {
        if (argument == null) {
            return true;
        }
        if (Primitives.isPrimitiveOrWrapper(this.clazz)) {
            return Primitives.isAssignableFromWrapper(this.clazz, argument.getClass());
        }
        return this.clazz.isAssignableFrom(argument.getClass());
    }

    public String toString() {
        return "<Capturing argument: " + this.clazz.getSimpleName() + ">";
    }

    public T getLastValue() {
        this.readLock.lock();
        try {
            if (this.arguments.isEmpty()) {
                throw Reporter.noArgumentValueWasCaptured();
            }
            T t = this.arguments.get(this.arguments.size() - 1);
            return t;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public List<T> getAllValues() {
        this.readLock.lock();
        try {
            ArrayList<T> arrayList = new ArrayList<T>(this.arguments);
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void captureFrom(Object argument) {
        this.writeLock.lock();
        try {
            this.arguments.add(argument);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public Class<?> type() {
        return this.clazz;
    }
}

