/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.crypto;

import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.platform.event.StateSignatureTransaction;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.common.Console;
import com.swirlds.common.threading.framework.StoppableThread;
import com.swirlds.common.threading.framework.config.StoppableThreadConfiguration;
import com.swirlds.common.threading.manager.AdHocThreadManager;
import com.swirlds.common.utility.AutoCloseableWrapper;
import com.swirlds.demo.crypto.CryptocurrencyDemoConsensusStateEventHandler;
import com.swirlds.demo.crypto.CryptocurrencyDemoState;
import com.swirlds.platform.Browser;
import com.swirlds.platform.gui.SwirldsGui;
import com.swirlds.platform.state.ConsensusStateEventHandler;
import com.swirlds.platform.state.MerkleNodeState;
import com.swirlds.platform.system.Platform;
import com.swirlds.platform.system.SwirldMain;
import com.swirlds.platform.test.fixtures.state.TestingAppStateInitializer;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Random;
import org.hiero.base.constructable.ClassConstructorPair;
import org.hiero.base.constructable.ConstructableRegistry;
import org.hiero.base.constructable.ConstructableRegistryException;
import org.hiero.consensus.model.node.NodeId;

public class CryptocurrencyDemoMain
implements SwirldMain<CryptocurrencyDemoState> {
    private final long screenUpdateDelay = 250L;
    private Platform platform;
    private NodeId selfId;
    private Console console;
    private Random rand = new Random();
    private GuiKeyListener keyListener = new GuiKeyListener();
    private byte speedCmd = (byte)-1;
    private boolean isFast = false;
    private static final SemanticVersion semanticVersion;
    private final StoppableThread transactionGenerator = ((StoppableThreadConfiguration)((StoppableThreadConfiguration)((StoppableThreadConfiguration)new StoppableThreadConfiguration(AdHocThreadManager.getStaticThreadManager()).setComponent("demo")).setThreadName("transaction-generator")).setMaximumRate(4.0)).setWork(this::generateTransactions).build();

    public static void main(String[] args) {
        Browser.parseCommandLineArgsAndLaunch((String[])args);
    }

    private void generateTransactions() {
        int numStocks = 10;
        byte[] price = new byte[numStocks];
        try (AutoCloseableWrapper wrapper = this.platform.getLatestImmutableState("CryptocurrencyDemoMain.generateTransactions()");){
            CryptocurrencyDemoState state = (CryptocurrencyDemoState)((Object)wrapper.get());
            state.getPriceCopy(price);
        }
        for (int i = 0; i < numStocks; ++i) {
            if (!(Math.random() < 0.5)) continue;
            byte askBid = (byte)(this.rand.nextInt(2) == 0 ? CryptocurrencyDemoState.TransType.ask.ordinal() : CryptocurrencyDemoState.TransType.bid.ordinal());
            byte cents = (byte)Math.max(0, Math.min(127, price[i] + this.rand.nextInt(5) - 2));
            this.platform.createTransaction(new byte[]{askBid, (byte)i, cents});
        }
        if (this.speedCmd != -1) {
            this.platform.createTransaction(new byte[]{this.speedCmd});
            this.speedCmd = (byte)-1;
        }
    }

    public void init(Platform platform, NodeId id) {
        this.platform = platform;
        this.selfId = id;
        int winNum = (int)this.selfId.id();
        this.console = SwirldsGui.createConsole((Platform)platform, (int)winNum, (boolean)true);
        this.console.addKeyListener((KeyListener)this.keyListener);
    }

    public void run() {
        long seq = 0L;
        this.transactionGenerator.start();
        while (true) {
            try (AutoCloseableWrapper wrapper = this.platform.getLatestImmutableState("CryptocurrencyDemoMain.run()");){
                CryptocurrencyDemoState state = (CryptocurrencyDemoState)((Object)wrapper.get());
                this.console.setHeading(" Cryptocurrency and Stock Market Demo\n Press F for fast sync, S for slow, (currently " + (this.isFast ? "fast" : "slow") + ")\n" + String.format(" %s", this.platform.getContext().getMetrics().getValue("platform", "trans_per_sec")) + " transactions per second for member " + String.valueOf(this.selfId) + "\n\n count  ticker  price change  change%  seller->buyer");
                long lastSeq = state.getNumTrades();
                while (seq < lastSeq) {
                    String s = state.getTrade(seq);
                    if (!s.equals("")) {
                        this.console.out.println(s);
                    }
                    ++seq;
                }
            }
            try {
                Thread.sleep(250L);
            }
            catch (Exception exception) {
            }
        }
    }

    @NonNull
    public CryptocurrencyDemoState newStateRoot() {
        CryptocurrencyDemoState state = new CryptocurrencyDemoState();
        TestingAppStateInitializer.DEFAULT.initStates((MerkleNodeState)state);
        return state;
    }

    @NonNull
    public ConsensusStateEventHandler<CryptocurrencyDemoState> newConsensusStateEvenHandler() {
        return new CryptocurrencyDemoConsensusStateEventHandler();
    }

    public SemanticVersion getSemanticVersion() {
        return semanticVersion;
    }

    public Bytes encodeSystemTransaction(@NonNull StateSignatureTransaction transaction) {
        return StateSignatureTransaction.PROTOBUF.toBytes((Object)transaction);
    }

    static {
        try {
            ConstructableRegistry constructableRegistry = ConstructableRegistry.getInstance();
            constructableRegistry.registerConstructable(new ClassConstructorPair(CryptocurrencyDemoState.class, () -> {
                CryptocurrencyDemoState cryptocurrencyDemoState = new CryptocurrencyDemoState();
                return cryptocurrencyDemoState;
            }));
            TestingAppStateInitializer.registerMerkleStateRootClassIds();
        }
        catch (ConstructableRegistryException e) {
            throw new RuntimeException(e);
        }
        semanticVersion = SemanticVersion.newBuilder().major(1).build();
    }

    private class GuiKeyListener
    implements KeyListener {
        private GuiKeyListener() {
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyChar() == 'F' || e.getKeyChar() == 'f') {
                CryptocurrencyDemoMain.this.isFast = true;
                CryptocurrencyDemoMain.this.speedCmd = (byte)CryptocurrencyDemoState.TransType.fast.ordinal();
            } else if (e.getKeyChar() == 'S' || e.getKeyChar() == 's') {
                CryptocurrencyDemoMain.this.isFast = false;
                CryptocurrencyDemoMain.this.speedCmd = (byte)CryptocurrencyDemoState.TransType.slow.ordinal();
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }
    }
}

