/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.merkle.test.fixtures.map.benchmark.operations;

import com.swirlds.common.test.fixtures.benchmark.AbstractBenchmarkOperation;
import com.swirlds.merkle.map.MerkleMap;
import com.swirlds.merkle.test.fixtures.map.benchmark.BenchmarkAccount;
import com.swirlds.merkle.test.fixtures.map.benchmark.BenchmarkKey;
import com.swirlds.merkle.test.fixtures.map.benchmark.MerkleMapBenchmarkMetadata;
import java.util.Random;

public class TransferOperation<A extends BenchmarkAccount, M extends MerkleMapBenchmarkMetadata>
extends AbstractBenchmarkOperation<MerkleMap<BenchmarkKey, A>, M> {
    private BenchmarkKey fromKey;
    private long newFromBalance;
    private BenchmarkKey toKey;
    private long newToBalance;
    private BenchmarkKey nodeFeeKey;
    private long newNodeBalance;
    private BenchmarkKey networkFeeKey;
    private long newNetworkBalance;

    public TransferOperation(double weight) {
        super(weight);
    }

    private TransferOperation(TransferOperation<A, M> that) {
        super(that.getWeight());
    }

    public String getName() {
        return "transfer";
    }

    public void prepare(M metadata, Random random) {
        this.fromKey = ((MerkleMapBenchmarkMetadata)metadata).getRandomKey(random);
        this.toKey = ((MerkleMapBenchmarkMetadata)metadata).getRandomKey(random);
        if (this.fromKey == null || this.toKey == null || this.fromKey == this.toKey) {
            this.abort();
            return;
        }
        this.newFromBalance = random.nextLong();
        this.newToBalance = random.nextLong();
        this.nodeFeeKey = ((MerkleMapBenchmarkMetadata)metadata).getRandomNodeFeeKey(random);
        this.newNodeBalance = random.nextLong();
        this.networkFeeKey = ((MerkleMapBenchmarkMetadata)metadata).getNetworkFeeKey();
        this.newNetworkBalance = random.nextLong();
    }

    public void execute(MerkleMap<BenchmarkKey, A> state) {
        BenchmarkAccount fromAccount = (BenchmarkAccount)state.getForModify((Object)this.fromKey);
        BenchmarkAccount toAccount = (BenchmarkAccount)state.getForModify((Object)this.toKey);
        BenchmarkAccount nodeAccount = (BenchmarkAccount)state.getForModify((Object)this.nodeFeeKey);
        BenchmarkAccount networkAccount = (BenchmarkAccount)state.getForModify((Object)this.networkFeeKey);
        fromAccount.setBalance(this.newFromBalance);
        toAccount.setBalance(this.newToBalance);
        nodeAccount.setBalance(this.newNodeBalance);
        networkAccount.setBalance(this.newNetworkBalance);
    }

    public TransferOperation<A, M> copy() {
        return new TransferOperation<A, M>(this);
    }
}

