/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.addressbook;

import com.hedera.hapi.node.base.Transaction;
import com.hedera.hapi.node.transaction.TransactionResponse;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.grpc.Pipeline;
import com.hedera.pbj.runtime.grpc.Pipelines;
import com.hedera.pbj.runtime.grpc.ServiceInterface;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public interface AddressBookServiceInterface
extends ServiceInterface {
    public static final String SERVICE_NAME = "AddressBookService";
    public static final String FULL_NAME = "proto.AddressBookService";

    public TransactionResponse createNode(Transaction var1);

    public TransactionResponse deleteNode(Transaction var1);

    public TransactionResponse updateNode(Transaction var1);

    @NonNull
    default public String serviceName() {
        return SERVICE_NAME;
    }

    @NonNull
    default public String fullName() {
        return FULL_NAME;
    }

    @NonNull
    default public List<ServiceInterface.Method> methods() {
        return Arrays.asList(AddressBookServiceMethod.values());
    }

    @NonNull
    default public Pipeline<? super Bytes> open(@NonNull ServiceInterface.Method method, @NonNull ServiceInterface.RequestOptions options, @NonNull Pipeline<? super Bytes> replies) {
        AddressBookServiceMethod m = (AddressBookServiceMethod)method;
        try {
            return switch (m.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> Pipelines.unary().mapRequest(bytes -> this.parseTransaction((Bytes)bytes, options)).method(this::createNode).mapResponse(reply -> this.serializeTransactionResponse((TransactionResponse)reply, options)).respondTo(replies).build();
                case 1 -> Pipelines.unary().mapRequest(bytes -> this.parseTransaction((Bytes)bytes, options)).method(this::deleteNode).mapResponse(reply -> this.serializeTransactionResponse((TransactionResponse)reply, options)).respondTo(replies).build();
                case 2 -> Pipelines.unary().mapRequest(bytes -> this.parseTransaction((Bytes)bytes, options)).method(this::updateNode).mapResponse(reply -> this.serializeTransactionResponse((TransactionResponse)reply, options)).respondTo(replies).build();
            };
        }
        catch (Exception e) {
            replies.onError((Throwable)e);
            return Pipelines.noop();
        }
    }

    @NonNull
    private Transaction parseTransaction(@NonNull Bytes message, @NonNull ServiceInterface.RequestOptions options) throws ParseException {
        Objects.requireNonNull(message);
        Objects.requireNonNull(options);
        if (options.isJson() && !options.isProtobuf()) {
            return (Transaction)Transaction.JSON.parse(message.toReadableSequentialData(), false, 16);
        }
        return (Transaction)Transaction.PROTOBUF.parse(message.toReadableSequentialData(), false, 16);
    }

    @NonNull
    private Bytes serializeTransactionResponse(@NonNull TransactionResponse reply, @NonNull ServiceInterface.RequestOptions options) {
        Objects.requireNonNull(reply);
        Objects.requireNonNull(options);
        if (options.isJson() && !options.isProtobuf()) {
            return Bytes.wrap((String)TransactionResponse.JSON.toJSON((Object)reply));
        }
        return TransactionResponse.PROTOBUF.toBytes((Object)reply);
    }

    public static enum AddressBookServiceMethod implements ServiceInterface.Method
    {
        createNode,
        deleteNode,
        updateNode;

    }
}

