/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.test.fixtures.communication.multithreaded;

import com.swirlds.base.utility.Pair;
import com.swirlds.platform.network.Connection;
import com.swirlds.platform.test.fixtures.communication.TestPeerProtocol;
import com.swirlds.platform.test.fixtures.communication.multithreaded.TestNegotiator;
import com.swirlds.platform.test.fixtures.sync.ConnectionFactory;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Callable;
import org.hiero.consensus.model.node.NodeId;
import org.junit.jupiter.api.Assertions;

public class NegotiatorPair {
    private final TestNegotiator n1;
    private final TestNegotiator n2;

    public NegotiatorPair(TestPeerProtocol protocol, Pair<Connection, Connection> connections) {
        this.n1 = new TestNegotiator((Connection)connections.left(), protocol.copy());
        this.n2 = new TestNegotiator((Connection)connections.right(), protocol.copy());
    }

    public NegotiatorPair(TestPeerProtocol protocol) throws IOException {
        this(protocol, ConnectionFactory.createLocalConnections(NodeId.of((long)0L), NodeId.of((long)1L)));
    }

    public void start() {
        this.n1.getThread().start();
        this.n2.getThread().start();
    }

    public Callable<Boolean> threadsDone() {
        return () -> {
            for (TestNegotiator negotiator : List.of(this.n1, this.n2)) {
                if (!negotiator.getThread().isAlive()) continue;
                return false;
            }
            return true;
        };
    }

    public void assertTimesRan(int times) {
        Assertions.assertEquals((int)times, (int)this.n1.getProtocol().getTimesRan(), (String)String.format("protocol 1 was expected to run %d times", times));
        Assertions.assertEquals((int)times, (int)this.n2.getProtocol().getTimesRan(), (String)String.format("protocol 2 was expected to run %d times", times));
    }

    public void assertHandshakeRan() {
        Assertions.assertEquals((int)1, (int)this.n1.getHandshakeRunNumber(), (String)"handshake is expected to run exactly once");
        Assertions.assertEquals((int)1, (int)this.n2.getHandshakeRunNumber(), (String)"handshake is expected to run exactly once");
    }

    public void finish() throws Exception {
        this.n1.rethrow();
        this.n2.rethrow();
    }
}

