/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.virtualmap;

import com.swirlds.common.io.ExternalSelfSerializable;
import com.swirlds.common.io.streams.StreamDebugUtils;
import com.swirlds.common.merkle.MerkleInternal;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.impl.PartialBinaryMerkleInternal;
import com.swirlds.common.merkle.utility.DebugIterationEndpoint;
import com.swirlds.common.utility.Labeled;
import com.swirlds.common.utility.RuntimeObjectRecord;
import com.swirlds.common.utility.RuntimeObjectRegistry;
import com.swirlds.config.api.Configuration;
import com.swirlds.metrics.api.Metrics;
import com.swirlds.virtualmap.VirtualKey;
import com.swirlds.virtualmap.VirtualValue;
import com.swirlds.virtualmap.config.VirtualMapConfig;
import com.swirlds.virtualmap.constructable.constructors.VirtualMapConstructor;
import com.swirlds.virtualmap.datasource.VirtualDataSource;
import com.swirlds.virtualmap.datasource.VirtualDataSourceBuilder;
import com.swirlds.virtualmap.internal.merkle.VirtualMapState;
import com.swirlds.virtualmap.internal.merkle.VirtualRootNode;
import com.swirlds.virtualmap.internal.merkle.VirtualStateAccessorImpl;
import com.swirlds.virtualmap.serialize.KeySerializer;
import com.swirlds.virtualmap.serialize.ValueSerializer;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import org.hiero.base.ValueReference;
import org.hiero.base.constructable.ConstructableClass;
import org.hiero.base.io.SelfSerializable;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.base.io.streams.SerializableDataOutputStream;
import org.hiero.base.utility.CommonUtils;

@DebugIterationEndpoint
@ConstructableClass(value=-5151568835156514733L, constructorType=VirtualMapConstructor.class)
public final class VirtualMap<K extends VirtualKey, V extends VirtualValue>
extends PartialBinaryMerkleInternal
implements ExternalSelfSerializable,
Labeled,
MerkleInternal {
    public static final long CLASS_ID = -5151568835156514733L;
    private VirtualMapState state;
    private VirtualRootNode<K, V> root;
    private final RuntimeObjectRecord registryRecord;
    @NonNull
    private final Configuration configuration;

    public VirtualMap(@NonNull Configuration configuration) {
        Objects.requireNonNull(configuration);
        this.configuration = configuration;
        this.registryRecord = RuntimeObjectRegistry.createRecord(((Object)((Object)this)).getClass());
    }

    public VirtualMap(String label, KeySerializer<K> keySerializer, ValueSerializer<V> valueSerializer, VirtualDataSourceBuilder dataSourceBuilder, @NonNull Configuration configuration) {
        this(configuration);
        this.setChild(0, (MerkleNode)new VirtualMapState(Objects.requireNonNull(label)));
        this.setChild(1, new VirtualRootNode<K, V>(keySerializer, valueSerializer, Objects.requireNonNull(dataSourceBuilder), Objects.requireNonNull((VirtualMapConfig)configuration.getConfigData(VirtualMapConfig.class))));
    }

    private VirtualMap(VirtualMap<K, V> source) {
        this(source.configuration);
        this.setChild(0, (MerkleNode)source.getState().copy());
        this.setChild(1, source.getRoot().copy());
    }

    public VirtualDataSource getDataSource() {
        return this.root.getDataSource();
    }

    VirtualMapState getState() {
        return this.state;
    }

    VirtualRootNode<K, V> getRoot() {
        return this.root;
    }

    public void registerMetrics(Metrics metrics) {
        this.root.registerMetrics(metrics);
    }

    public long getClassId() {
        return -5151568835156514733L;
    }

    public int getVersion() {
        return 3;
    }

    public String getLabel() {
        return this.state.getLabel();
    }

    public VirtualMap<K, V> copy() {
        this.throwIfImmutable();
        this.throwIfDestroyed();
        VirtualMap<K, V> copy = new VirtualMap<K, V>(this);
        this.setImmutable(true);
        return copy;
    }

    public void setChild(int index, MerkleNode child) {
        if (index == 0) {
            this.state = (VirtualMapState)child.cast();
        } else if (index == 1) {
            this.root = (VirtualRootNode)child.cast();
            this.root.postInit(new VirtualStateAccessorImpl(this.state));
        }
        super.setChild(index, child);
    }

    public void serialize(SerializableDataOutputStream out, Path outputDirectory) throws IOException {
        String outputFileName = this.state.getLabel() + ".vmap";
        byte[] outputFileNameBytes = CommonUtils.getNormalisedStringBytes((String)outputFileName);
        out.writeInt(outputFileNameBytes.length);
        out.writeNormalisedString(outputFileName);
        Path outputFile = outputDirectory.resolve(outputFileName);
        try (SerializableDataOutputStream serout = new SerializableDataOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(outputFile.toFile())));){
            serout.writeSerializable((SelfSerializable)this.state, true);
            serout.writeInt(this.root.getVersion());
            this.root.serialize(serout, outputDirectory);
        }
    }

    public void deserialize(SerializableDataInputStream in, Path inputDirectory, int version) throws IOException {
        if (version == 1) {
            in.readSerializable();
        }
        int fileNameLengthInBytes = in.readInt();
        String inputFileName = in.readNormalisedString(fileNameLengthInBytes);
        Path inputFile = inputDirectory.resolve(inputFileName);
        this.loadFromFile(inputFile);
        if (version < 3) {
            this.root.fullLeafRehashIfNecessary();
        }
    }

    public void loadFromFile(Path inputFile) throws IOException {
        ValueReference virtualMapState = new ValueReference();
        ValueReference virtualRootNode = new ValueReference();
        StreamDebugUtils.deserializeAndDebugOnFailure(() -> new SerializableDataInputStream((InputStream)new BufferedInputStream(new FileInputStream(inputFile.toFile()))), stream -> {
            virtualMapState.setValue((Object)((VirtualMapState)stream.readSerializable()));
            virtualRootNode.setValue(new VirtualRootNode((VirtualMapConfig)this.configuration.getConfigData(VirtualMapConfig.class)));
            ((VirtualRootNode)virtualRootNode.getValue()).deserialize((SerializableDataInputStream)stream, inputFile.getParent(), stream.readInt());
            return null;
        });
        this.state = (VirtualMapState)((Object)virtualMapState.getValue());
        this.root = (VirtualRootNode)virtualRootNode.getValue();
        this.addDeserializedChildren(List.of(this.state, this.root), this.getVersion());
    }

    protected void destroyNode() {
        this.registryRecord.release();
    }

    public long size() {
        return this.state.getSize();
    }

    public boolean isEmpty() {
        return this.root.isEmpty();
    }

    public boolean isValid() {
        return this.root != null;
    }

    public boolean containsKey(K key) {
        return this.root.containsKey(key);
    }

    public V get(K key) {
        return this.root.get(key);
    }

    public void put(K key, V value) {
        this.root.put(key, value);
    }

    public V remove(K key) {
        return this.root.remove(key);
    }

    public void warm(K key) {
        this.root.warm(key);
    }

    private static final class ChildIndices {
        private static final int MAP_STATE_CHILD_INDEX = 0;
        private static final int VIRTUAL_ROOT_CHILD_INDEX = 1;

        private ChildIndices() {
        }
    }

    public static class ClassVersion {
        public static final int ORIGINAL = 1;
        public static final int MERKLE_SERIALIZATION_CLEANUP = 2;
        public static final int REHASH_LEAVES = 3;
    }
}

