/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.virtualmap.internal.cache;

import com.swirlds.base.state.MutabilityException;
import com.swirlds.common.FastCopyable;
import com.swirlds.common.threading.framework.config.ThreadConfiguration;
import com.swirlds.common.threading.manager.AdHocThreadManager;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.virtualmap.VirtualKey;
import com.swirlds.virtualmap.VirtualValue;
import com.swirlds.virtualmap.config.VirtualMapConfig;
import com.swirlds.virtualmap.constructable.constructors.VirtualNodeCacheConstructor;
import com.swirlds.virtualmap.datasource.VirtualHashRecord;
import com.swirlds.virtualmap.datasource.VirtualLeafRecord;
import com.swirlds.virtualmap.internal.cache.ConcurrentArray;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.concurrent.futures.StandardFuture;
import org.hiero.base.constructable.ConstructableClass;
import org.hiero.base.crypto.Hash;
import org.hiero.base.exceptions.PlatformException;
import org.hiero.base.io.SelfSerializable;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.base.io.streams.SerializableDataOutputStream;

@ConstructableClass(value=5275760189460016428L, constructorType=VirtualNodeCacheConstructor.class)
public final class VirtualNodeCache<K extends VirtualKey, V extends VirtualValue>
implements FastCopyable,
SelfSerializable {
    private static final Logger logger = LogManager.getLogger(VirtualNodeCache.class);
    public static final long CLASS_ID = 5275760189460016428L;
    public static final VirtualLeafRecord<?, ?> DELETED_LEAF_RECORD = new VirtualLeafRecord<Object, Object>(-1L, null, null);
    public static final Hash DELETED_HASH = new Hash();
    public static final Hash NULL_HASH = new Hash();
    private static Executor cleaningPool = null;
    private final AtomicLong fastCopyVersion = new AtomicLong(0L);
    private final AtomicReference<VirtualNodeCache<K, V>> next = new AtomicReference();
    private final AtomicReference<VirtualNodeCache<K, V>> prev = new AtomicReference();
    private final Map<K, Mutation<K, VirtualLeafRecord<K, V>>> keyToDirtyLeafIndex;
    private final Map<Long, Mutation<Long, K>> pathToDirtyLeafIndex;
    private final Map<Long, Mutation<Long, Hash>> pathToDirtyHashIndex;
    private final AtomicBoolean released = new AtomicBoolean(false);
    private final AtomicBoolean leafIndexesAreImmutable = new AtomicBoolean(false);
    private final AtomicBoolean hashesAreImmutable = new AtomicBoolean(true);
    private volatile ConcurrentArray<Mutation<K, VirtualLeafRecord<K, V>>> dirtyLeaves = new ConcurrentArray();
    private volatile ConcurrentArray<Mutation<Long, K>> dirtyLeafPaths = new ConcurrentArray();
    private volatile ConcurrentArray<Mutation<Long, Hash>> dirtyHashes = new ConcurrentArray();
    private final AtomicBoolean mergedCopy = new AtomicBoolean(false);
    private final ReentrantLock releaseLock;
    private final AtomicBoolean snapshot = new AtomicBoolean(false);
    private final AtomicLong lastReleased;
    @NonNull
    private final VirtualMapConfig virtualMapConfig;

    private static synchronized Executor getCleaningPool(@NonNull VirtualMapConfig virtualMapConfig) {
        Objects.requireNonNull(virtualMapConfig);
        if (cleaningPool == null) {
            cleaningPool = Boolean.getBoolean("syncCleaningPool") ? Runnable::run : new ThreadPoolExecutor(virtualMapConfig.getNumCleanerThreads(), virtualMapConfig.getNumCleanerThreads(), 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), ((ThreadConfiguration)((ThreadConfiguration)((ThreadConfiguration)((ThreadConfiguration)new ThreadConfiguration(AdHocThreadManager.getStaticThreadManager()).setThreadGroup(new ThreadGroup("virtual-cache-cleaners"))).setComponent("virtual-map")).setThreadName("cache-cleaner")).setExceptionHandler((t, ex) -> logger.error(LogMarker.EXCEPTION.getMarker(), "Failed to purge unneeded key/mutationList pairs", ex))).buildFactory());
        }
        return cleaningPool;
    }

    public VirtualNodeCache(@NonNull VirtualMapConfig virtualMapConfig) {
        this(virtualMapConfig, 0L);
    }

    public VirtualNodeCache(@NonNull VirtualMapConfig virtualMapConfig, long fastCopyVersion) {
        this.keyToDirtyLeafIndex = new ConcurrentHashMap<K, Mutation<K, VirtualLeafRecord<K, V>>>();
        this.pathToDirtyLeafIndex = new ConcurrentHashMap<Long, Mutation<Long, K>>();
        this.pathToDirtyHashIndex = new ConcurrentHashMap<Long, Mutation<Long, Hash>>();
        this.releaseLock = new ReentrantLock();
        this.lastReleased = new AtomicLong(-1L);
        this.fastCopyVersion.set(fastCopyVersion);
        this.virtualMapConfig = Objects.requireNonNull(virtualMapConfig);
    }

    private VirtualNodeCache(VirtualNodeCache<K, V> source) {
        this.fastCopyVersion.set(source.fastCopyVersion.get() + 1L);
        this.keyToDirtyLeafIndex = source.keyToDirtyLeafIndex;
        this.pathToDirtyLeafIndex = source.pathToDirtyLeafIndex;
        this.pathToDirtyHashIndex = source.pathToDirtyHashIndex;
        this.releaseLock = source.releaseLock;
        this.lastReleased = source.lastReleased;
        this.virtualMapConfig = source.virtualMapConfig;
        source.prepareForHashing();
        this.next.set(source);
        source.prev.set(this);
    }

    public VirtualNodeCache<K, V> copy() {
        return new VirtualNodeCache<K, V>(this);
    }

    public void prepareForHashing() {
        this.leafIndexesAreImmutable.set(true);
        this.hashesAreImmutable.set(false);
        this.dirtyLeaves.seal();
    }

    public boolean isImmutable() {
        return this.leafIndexesAreImmutable.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean release() {
        this.throwIfDestroyed();
        this.seal();
        AtomicLong atomicLong = this.lastReleased;
        synchronized (atomicLong) {
            this.lastReleased.set(this.fastCopyVersion.get());
        }
        this.releaseLock.lock();
        try {
            if (this.next.get() != null) {
                throw new IllegalStateException("Cannot release an intermediate version, must release the oldest");
            }
            this.released.set(true);
            this.wirePrevAndNext();
        }
        finally {
            this.releaseLock.unlock();
        }
        VirtualNodeCache.purge(this.dirtyLeaves, this.keyToDirtyLeafIndex, this.virtualMapConfig);
        VirtualNodeCache.purge(this.dirtyLeafPaths, this.pathToDirtyLeafIndex, this.virtualMapConfig);
        VirtualNodeCache.purge(this.dirtyHashes, this.pathToDirtyHashIndex, this.virtualMapConfig);
        this.dirtyLeaves = null;
        this.dirtyLeafPaths = null;
        this.dirtyHashes = null;
        if (logger.isTraceEnabled()) {
            logger.trace(LogMarker.VIRTUAL_MERKLE_STATS.getMarker(), "Released {}", (Object)this.fastCopyVersion);
        }
        return true;
    }

    public boolean isDestroyed() {
        return this.released.get();
    }

    public void merge() {
        this.releaseLock.lock();
        try {
            VirtualNodeCache<K, V> p = this.prev.get();
            if (p == null) {
                throw new IllegalStateException("Cannot merge with a null cache");
            }
            if (!p.hashesAreImmutable.get() || !this.hashesAreImmutable.get()) {
                throw new IllegalStateException("You can only merge caches that are sealed");
            }
            p.dirtyLeaves.merge(this.dirtyLeaves);
            p.dirtyLeafPaths.merge(this.dirtyLeafPaths);
            p.dirtyHashes.merge(this.dirtyHashes);
            p.mergedCopy.set(true);
            this.wirePrevAndNext();
        }
        finally {
            this.releaseLock.unlock();
            if (logger.isTraceEnabled()) {
                logger.trace(LogMarker.VIRTUAL_MERKLE_STATS.getMarker(), "Merged version {}, {} dirty leaves, {} dirty internals", (Object)this.fastCopyVersion, (Object)this.dirtyLeaves.size(), (Object)this.dirtyHashes.size());
            }
        }
    }

    public void seal() {
        this.leafIndexesAreImmutable.set(true);
        this.hashesAreImmutable.set(true);
        this.dirtyLeaves.seal();
        this.dirtyHashes.seal();
        this.dirtyLeafPaths.seal();
    }

    public VirtualLeafRecord<K, V> putLeaf(VirtualLeafRecord<K, V> leaf) {
        this.throwIfLeafImmutable();
        Objects.requireNonNull(leaf);
        K key = leaf.getKey();
        assert (key != null) : "Keys cannot be null";
        this.updatePaths(key, leaf.getPath(), this.pathToDirtyLeafIndex, this.dirtyLeafPaths);
        return (VirtualLeafRecord)this.keyToDirtyLeafIndex.compute(key, (BiFunction<VirtualKey, Mutation, Mutation>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, lambda$putLeaf$1(com.swirlds.virtualmap.datasource.VirtualLeafRecord com.swirlds.virtualmap.VirtualKey com.swirlds.virtualmap.internal.cache.VirtualNodeCache$Mutation ), (Lcom/swirlds/virtualmap/VirtualKey;Lcom/swirlds/virtualmap/internal/cache/VirtualNodeCache$Mutation;)Lcom/swirlds/virtualmap/internal/cache/VirtualNodeCache$Mutation;)((VirtualNodeCache)this, leaf)).value;
    }

    public void deleteLeaf(VirtualLeafRecord<K, V> leaf) {
        this.throwIfLeafImmutable();
        Objects.requireNonNull(leaf);
        this.clearLeafPath(leaf.getPath());
        K key = leaf.getKey();
        assert (key != null) : "Keys cannot be null";
        this.keyToDirtyLeafIndex.compute((VirtualKey)key, (BiFunction<VirtualKey, Mutation<VirtualKey, VirtualLeafRecord<VirtualKey, Mutation>>, Mutation<VirtualKey, VirtualLeafRecord<VirtualKey, Mutation>>>)((BiFunction<VirtualKey, Mutation, Mutation>)(k, mutations) -> {
            mutations = this.mutate(leaf, (Mutation<K, VirtualLeafRecord<K, V>>)mutations);
            mutations.setDeleted(true);
            assert (this.pathToDirtyLeafIndex.get(leaf.getPath()).isDeleted()) : "It should be deleted too";
            return mutations;
        }));
    }

    public void clearLeafPath(long path) {
        this.throwIfLeafImmutable();
        this.updatePaths(null, path, this.pathToDirtyLeafIndex, this.dirtyLeafPaths);
    }

    public VirtualLeafRecord<K, V> lookupLeafByKey(K key, boolean forModify) {
        Objects.requireNonNull(key);
        if (this.released.get()) {
            return null;
        }
        Mutation<K, VirtualLeafRecord<K, V>> mutation = this.lookup(this.keyToDirtyLeafIndex.get(key));
        if (mutation == null) {
            return null;
        }
        if (mutation.isDeleted()) {
            return DELETED_LEAF_RECORD;
        }
        if (forModify && mutation.version < this.fastCopyVersion.get()) {
            assert (!this.leafIndexesAreImmutable.get()) : "You cannot create leaf records at this time!";
            VirtualLeafRecord leaf = new VirtualLeafRecord(((VirtualLeafRecord)mutation.value).getPath(), ((VirtualLeafRecord)mutation.value).getKey(), ((VirtualLeafRecord)mutation.value).getValue().copy());
            return this.putLeaf(leaf);
        }
        return (VirtualLeafRecord)mutation.value;
    }

    public VirtualLeafRecord<K, V> lookupLeafByPath(long path, boolean forModify) {
        if (this.released.get()) {
            return null;
        }
        Mutation<Long, K> mutation = this.lookup(this.pathToDirtyLeafIndex.get(path));
        if (mutation == null) {
            return null;
        }
        return mutation.isDeleted() ? DELETED_LEAF_RECORD : this.lookupLeafByKey((VirtualKey)mutation.value, forModify);
    }

    public Stream<VirtualLeafRecord<K, V>> dirtyLeavesForHash(long firstLeafPath, long lastLeafPath) {
        if (this.mergedCopy.get()) {
            throw new IllegalStateException("Cannot get dirty leaves for hashing on a merged cache copy");
        }
        Stream<VirtualLeafRecord<K, V>> result = this.dirtyLeaves(firstLeafPath, lastLeafPath, false);
        return result.sorted(Comparator.comparingLong(VirtualLeafRecord::getPath));
    }

    public Stream<VirtualLeafRecord<K, V>> dirtyLeavesForFlush(long firstLeafPath, long lastLeafPath) {
        return this.dirtyLeaves(firstLeafPath, lastLeafPath, true);
    }

    private Stream<VirtualLeafRecord<K, V>> dirtyLeaves(long firstLeafPath, long lastLeafPath, boolean dedupe) {
        if (!this.dirtyLeaves.isImmutable()) {
            throw new MutabilityException("Cannot call on a cache that is still mutable for dirty leaves");
        }
        if (dedupe) {
            VirtualNodeCache.filterMutations(this.dirtyLeaves, this.virtualMapConfig);
        }
        return this.dirtyLeaves.stream().filter(mutation -> {
            long path = ((VirtualLeafRecord)mutation.value).getPath();
            return path >= firstLeafPath && path <= lastLeafPath;
        }).filter(mutation -> {
            assert (dedupe || !mutation.isFiltered());
            return !mutation.isFiltered();
        }).filter(mutation -> !mutation.isDeleted()).map(mutation -> (VirtualLeafRecord)mutation.value);
    }

    public long estimatedDirtyLeavesCount() {
        return this.dirtyLeaves == null ? 0L : (long)this.dirtyLeaves.size();
    }

    public Stream<VirtualLeafRecord<K, V>> deletedLeaves() {
        if (!this.dirtyLeaves.isImmutable()) {
            throw new MutabilityException("Cannot call on a cache that is still mutable for dirty leaves");
        }
        ConcurrentHashMap leaves = new ConcurrentHashMap();
        StandardFuture<Void> result = this.dirtyLeaves.parallelTraverse(VirtualNodeCache.getCleaningPool(this.virtualMapConfig), element -> {
            VirtualKey key;
            Mutation<K, VirtualLeafRecord<K, V>> mutation;
            if (element.isDeleted() && (mutation = this.lookup(this.keyToDirtyLeafIndex.get(key = (VirtualKey)element.key))) != null && mutation.isDeleted()) {
                leaves.putIfAbsent(key, (VirtualLeafRecord)element.value);
            }
        });
        try {
            result.getAndRethrow();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new PlatformException("VirtualNodeCache.deletedLeaves() interrupted", (Throwable)ex, LogMarker.EXCEPTION);
        }
        return leaves.values().stream();
    }

    public void putHash(VirtualHashRecord node) {
        Objects.requireNonNull(node);
        this.putHash(node.path(), node.hash());
    }

    public void putHash(long path, Hash hash) {
        this.throwIfInternalsImmutable();
        this.updatePaths(hash != null ? hash : NULL_HASH, path, this.pathToDirtyHashIndex, this.dirtyHashes);
    }

    public void deleteHash(long path) {
        this.throwIfLeafImmutable();
        this.updatePaths(null, path, this.pathToDirtyHashIndex, this.dirtyHashes);
    }

    public Hash lookupHashByPath(long path, boolean forModify) {
        if (this.released.get()) {
            return null;
        }
        Mutation<Long, Hash> mutation = this.lookup(this.pathToDirtyHashIndex.get(path));
        if (mutation == null || mutation.value == NULL_HASH) {
            return null;
        }
        if (mutation.isDeleted()) {
            return DELETED_HASH;
        }
        if (forModify && mutation.version < this.fastCopyVersion.get()) {
            assert (!this.hashesAreImmutable.get()) : "You cannot create internal records at this time!";
            this.updatePaths(NULL_HASH, path, this.pathToDirtyHashIndex, this.dirtyHashes);
            return null;
        }
        return (Hash)mutation.value;
    }

    public Stream<VirtualHashRecord> dirtyHashesForFlush(long lastLeafPath) {
        if (!this.dirtyHashes.isImmutable()) {
            throw new MutabilityException("Cannot get the dirty internal records for a non-sealed cache.");
        }
        VirtualNodeCache.filterMutations(this.dirtyHashes, this.virtualMapConfig);
        return this.dirtyHashes.stream().filter(mutation -> (Long)mutation.key <= lastLeafPath).filter(mutation -> !mutation.isFiltered()).map(mutation -> new VirtualHashRecord((Long)mutation.key, mutation.value != NULL_HASH ? (Hash)mutation.value : null));
    }

    public long estimatedHashesCount() {
        return this.dirtyHashes == null ? 0L : (long)this.dirtyHashes.size();
    }

    public long getClassId() {
        return 5275760189460016428L;
    }

    public void serialize(SerializableDataOutputStream out) throws IOException {
        if (!this.snapshot.get()) {
            throw new IllegalStateException("Trying to serialize a non-snapshot instance");
        }
        out.writeLong(this.fastCopyVersion.get());
        this.serializeKeyToDirtyLeafIndex(this.keyToDirtyLeafIndex, out);
        this.serializePathToDirtyLeafIndex(this.pathToDirtyLeafIndex, out);
        this.serializePathToDirtyHashIndex(this.pathToDirtyHashIndex, out);
    }

    public void deserialize(SerializableDataInputStream in, int version) throws IOException {
        this.fastCopyVersion.set(in.readLong());
        this.deserializeKeyToDirtyLeafIndex(this.keyToDirtyLeafIndex, in, version);
        this.deserializePathToDirtyLeafIndex(this.pathToDirtyLeafIndex, in);
        this.deserializePathToDirtyHashIndex(this.pathToDirtyHashIndex, in, version);
    }

    public int getVersion() {
        return 2;
    }

    public long getFastCopyVersion() {
        return this.fastCopyVersion.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VirtualNodeCache<K, V> snapshot() {
        AtomicLong atomicLong = this.lastReleased;
        synchronized (atomicLong) {
            VirtualNodeCache<K, V> newSnapshot = new VirtualNodeCache<K, V>(this.virtualMapConfig);
            this.setMapSnapshotAndArray(this.pathToDirtyHashIndex, newSnapshot.pathToDirtyHashIndex, newSnapshot.dirtyHashes);
            this.setMapSnapshotAndArray(this.pathToDirtyLeafIndex, newSnapshot.pathToDirtyLeafIndex, newSnapshot.dirtyLeafPaths);
            this.setMapSnapshotAndArray(this.keyToDirtyLeafIndex, newSnapshot.keyToDirtyLeafIndex, newSnapshot.dirtyLeaves);
            newSnapshot.snapshot.set(true);
            newSnapshot.fastCopyVersion.set(this.fastCopyVersion.get());
            newSnapshot.seal();
            return newSnapshot;
        }
    }

    private void wirePrevAndNext() {
        VirtualNodeCache<K, V> n = this.next.get();
        VirtualNodeCache<K, V> p = this.prev.get();
        if (n != null) {
            n.prev.set(p);
        }
        if (p != null) {
            p.next.set(n);
        }
        this.next.set(null);
        this.prev.set(null);
    }

    private <V1> void updatePaths(V1 value, long path, Map<Long, Mutation<Long, V1>> index, ConcurrentArray<Mutation<Long, V1>> dirtyPaths) {
        index.compute(path, (key, mutation) -> {
            Mutation<Object, Object> nextMutation = mutation;
            Mutation previousMutation = null;
            while (nextMutation != null && nextMutation.version > this.fastCopyVersion.get()) {
                previousMutation = nextMutation;
                nextMutation = nextMutation.next;
            }
            if (nextMutation == null || nextMutation.version != this.fastCopyVersion.get()) {
                nextMutation = new Mutation<Long, Object>(nextMutation, path, value, this.fastCopyVersion.get());
                nextMutation.setDeleted(value == null);
                dirtyPaths.add(nextMutation);
            } else {
                assert (!nextMutation.isFiltered());
                nextMutation.value = value;
                nextMutation.setDeleted(value == null);
            }
            if (previousMutation != null) {
                assert (!previousMutation.isFiltered());
                previousMutation.next = nextMutation;
            } else {
                mutation = nextMutation;
            }
            return mutation;
        });
    }

    private <K1, V1> Mutation<K1, V1> lookup(Mutation<K1, V1> mutation) {
        while (mutation != null) {
            if (mutation.version <= this.fastCopyVersion.get()) {
                return mutation;
            }
            mutation = mutation.next;
        }
        return null;
    }

    private Mutation<K, VirtualLeafRecord<K, V>> mutate(VirtualLeafRecord<K, V> leaf, Mutation<K, VirtualLeafRecord<K, V>> mutation) {
        if (mutation == null || mutation.version != this.fastCopyVersion.get()) {
            Mutation<K, VirtualLeafRecord<K, VirtualLeafRecord<K, V>>> newerMutation = new Mutation<K, VirtualLeafRecord<K, VirtualLeafRecord<K, V>>>(mutation, leaf.getKey(), leaf, this.fastCopyVersion.get());
            this.dirtyLeaves.add(newerMutation);
            mutation = newerMutation;
        } else if (mutation.value != leaf) {
            assert (((VirtualLeafRecord)mutation.value).getKey().equals(leaf.getKey()));
            ((VirtualLeafRecord)mutation.value).setPath(leaf.getPath());
            ((VirtualLeafRecord)mutation.value).setValue(leaf.getValue());
            mutation.setDeleted(false);
        } else {
            mutation.setDeleted(false);
        }
        return mutation;
    }

    private static <K, V> void purge(ConcurrentArray<Mutation<K, V>> array, Map<K, Mutation<K, V>> index, @NonNull VirtualMapConfig virtualMapConfig) {
        array.parallelTraverse(VirtualNodeCache.getCleaningPool(virtualMapConfig), element -> index.compute(element.key, (key, mutation) -> {
            if (mutation == null || element.equals(mutation)) {
                return null;
            }
            Mutation m = mutation;
            while (m.next != null) {
                if (element.equals(m.next)) {
                    m.next = null;
                    break;
                }
                m = m.next;
            }
            return mutation;
        }));
    }

    private static <K, V> void filterMutations(ConcurrentArray<Mutation<K, V>> array, @NonNull VirtualMapConfig virtualMapConfig) {
        Consumer<Mutation> action = mutation -> {
            Mutation nextMutation = mutation.next;
            if (nextMutation != null) {
                nextMutation.setFiltered();
            }
        };
        try {
            array.parallelTraverse(VirtualNodeCache.getCleaningPool(virtualMapConfig), action).getAndRethrow();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    private <K2, L2> void setMapSnapshotAndArray(Map<K2, Mutation<K2, L2>> src, Map<K2, Mutation<K2, L2>> dst, ConcurrentArray<Mutation<K2, L2>> array) {
        long accepted = this.fastCopyVersion.get();
        long rejected = this.lastReleased.get();
        for (Map.Entry<K2, Mutation<K2, L2>> entry : src.entrySet()) {
            Mutation<Object, Object> mutation = entry.getValue();
            while (mutation != null && mutation.version > accepted) {
                mutation = mutation.next;
            }
            if (mutation == null || mutation.version <= rejected) continue;
            dst.put(entry.getKey(), mutation);
            array.add(mutation);
        }
    }

    private void serializePathToDirtyHashIndex(Map<Long, Mutation<Long, Hash>> map, SerializableDataOutputStream out) throws IOException {
        assert (this.snapshot.get()) : "Only snapshots can be serialized";
        out.writeInt(map.size());
        for (Map.Entry<Long, Mutation<Long, Hash>> entry : map.entrySet()) {
            out.writeLong(entry.getKey().longValue());
            Mutation<Long, Hash> mutation = entry.getValue();
            assert (mutation != null) : "Mutations cannot be null in a snapshot";
            assert (mutation.version <= this.fastCopyVersion.get()) : "Trying to serialize pathToDirtyInternalIndex with a version ahead";
            out.writeLong(mutation.version);
            out.writeBoolean(mutation.isDeleted());
            if (mutation.isDeleted()) continue;
            out.writeSerializable((SelfSerializable)mutation.value, true);
        }
    }

    private void deserializePathToDirtyHashIndex(Map<Long, Mutation<Long, Hash>> map, SerializableDataInputStream in, int version) throws IOException {
        int sizeOfMap = in.readInt();
        for (int index = 0; index < sizeOfMap; ++index) {
            long key = in.readLong();
            long mutationVersion = in.readLong();
            boolean isDeleted = in.readBoolean();
            Hash hash = null;
            if (!isDeleted) {
                if (version == 1) {
                    in.readLong();
                }
                hash = (Hash)in.readSerializable();
            }
            Mutation<Long, Hash> mutation = new Mutation<Long, Hash>(null, key, hash, mutationVersion);
            mutation.setDeleted(isDeleted);
            map.put(key, mutation);
            this.dirtyHashes.add(mutation);
        }
    }

    private void serializePathToDirtyLeafIndex(Map<Long, Mutation<Long, K>> map, SerializableDataOutputStream out) throws IOException {
        assert (this.snapshot.get()) : "Only snapshots can be serialized";
        out.writeInt(map.size());
        for (Map.Entry<Long, Mutation<Long, K>> entry : map.entrySet()) {
            out.writeLong(entry.getKey().longValue());
            Mutation<Long, K> mutation = entry.getValue();
            assert (mutation != null) : "Mutations cannot be null in a snapshot";
            assert (mutation.version <= this.fastCopyVersion.get()) : "Trying to serialize pathToDirtyLeafIndex with a version ahead";
            out.writeSerializable((SelfSerializable)mutation.value, true);
            out.writeLong(mutation.version);
            out.writeBoolean(mutation.isDeleted());
        }
    }

    private void deserializePathToDirtyLeafIndex(Map<Long, Mutation<Long, K>> map, SerializableDataInputStream in) throws IOException {
        int sizeOfMap = in.readInt();
        for (int index = 0; index < sizeOfMap; ++index) {
            Long path = in.readLong();
            VirtualKey key = (VirtualKey)in.readSerializable();
            long mutationVersion = in.readLong();
            boolean deleted = in.readBoolean();
            Mutation<Long, VirtualKey> mutation = new Mutation<Long, VirtualKey>(null, path, key, mutationVersion);
            mutation.setDeleted(deleted);
            map.put(path, mutation);
            this.dirtyLeafPaths.add(mutation);
        }
    }

    private void serializeKeyToDirtyLeafIndex(Map<K, Mutation<K, VirtualLeafRecord<K, V>>> map, SerializableDataOutputStream out) throws IOException {
        assert (this.snapshot.get()) : "Only snapshots can be serialized";
        out.writeInt(map.size());
        for (Map.Entry<K, Mutation<K, VirtualLeafRecord<K, V>>> entry : map.entrySet()) {
            Mutation<K, VirtualLeafRecord<K, V>> mutation = entry.getValue();
            assert (mutation != null) : "Mutations cannot be null in a snapshot";
            assert (mutation.version <= this.fastCopyVersion.get()) : "Trying to serialize keyToDirtyLeafIndex with a version ahead";
            VirtualLeafRecord leaf = (VirtualLeafRecord)mutation.value;
            out.writeSerializable((SelfSerializable)leaf, false);
            out.writeLong(mutation.version);
            out.writeBoolean(mutation.isDeleted());
        }
    }

    private void deserializeKeyToDirtyLeafIndex(Map<K, Mutation<K, VirtualLeafRecord<K, V>>> map, SerializableDataInputStream in, int version) throws IOException {
        int sizeOfMap = in.readInt();
        for (int index = 0; index < sizeOfMap; ++index) {
            VirtualLeafRecord leafRecord = (VirtualLeafRecord)in.readSerializable(false, VirtualLeafRecord::new);
            if (version == 1) {
                in.readSerializable();
            }
            long mutationVersion = in.readLong();
            boolean deleted = in.readBoolean();
            Mutation mutation = new Mutation(null, leafRecord.getKey(), leafRecord, mutationVersion);
            mutation.setDeleted(deleted);
            map.put(leafRecord.getKey(), mutation);
            this.dirtyLeaves.add(mutation);
        }
    }

    private void throwIfLeafImmutable() {
        if (this.leafIndexesAreImmutable.get()) {
            throw new MutabilityException("This operation is not permitted on immutable leaves");
        }
    }

    private void throwIfInternalsImmutable() {
        if (this.hashesAreImmutable.get()) {
            throw new MutabilityException("This operation is not permitted on immutable internals");
        }
    }

    public String toDebugString() {
        StringBuilder builder = new StringBuilder();
        builder.append("VirtualNodeCache ").append(this).append("\n");
        builder.append("===================================\n");
        builder.append(this.toDebugStringChain()).append("\n");
        builder.append(this.toDebugStringIndex("keyToDirtyLeafIndex", this.keyToDirtyLeafIndex)).append("\n");
        builder.append(this.toDebugStringIndex("pathToDirtyLeafIndex", this.pathToDirtyLeafIndex)).append("\n");
        builder.append(this.toDebugStringIndex("pathToDirtyHashIndex", this.pathToDirtyHashIndex)).append("\n");
        builder.append(this.toDebugStringArray("dirtyLeaves", this.dirtyLeaves));
        builder.append(this.toDebugStringArray("dirtyLeafPaths", this.dirtyLeafPaths));
        builder.append(this.toDebugStringArray("dirtyHashes", this.dirtyHashes));
        return builder.toString();
    }

    private String toDebugStringChain() {
        VirtualNodeCache<K, V> prevCache;
        StringBuilder builder = new StringBuilder();
        builder.append("Copies:\n");
        builder.append("\t");
        VirtualNodeCache<K, V> firstCache = this;
        while ((prevCache = firstCache.prev.get()) != null) {
            firstCache = prevCache;
        }
        while (firstCache != null) {
            builder.append("[").append(firstCache.fastCopyVersion.get()).append(firstCache == this ? "*" : "").append("]->");
            firstCache = firstCache.next.get();
        }
        return builder.toString();
    }

    private String toDebugStringIndex(String indexName, Map<Object, Mutation> index) {
        StringBuilder builder = new StringBuilder();
        builder.append(indexName).append(":\n");
        index.forEach((key, mutation) -> {
            builder.append("\t").append(key).append(":==> ");
            while (mutation != null) {
                builder.append("[").append(mutation.key).append(",").append(mutation.value).append(",").append(mutation.isDeleted() ? "D," : "").append("V").append(mutation.version).append(mutation.version == this.fastCopyVersion.get() ? "*" : "").append("]->");
                mutation = mutation.next;
            }
            builder.append("\n");
        });
        return builder.toString();
    }

    private String toDebugStringArray(String name, ConcurrentArray<Mutation> arr) {
        StringBuilder builder = new StringBuilder();
        builder.append(name).append(":\n");
        int size = arr.size();
        for (int i = 0; i < size; ++i) {
            Mutation mutation = arr.get(i);
            builder.append("\t").append(mutation.key).append(",").append(mutation.value).append(",").append(mutation.isDeleted() ? "D," : "").append("V").append(mutation.version).append(mutation.version == this.fastCopyVersion.get() ? "*" : "").append("]\n");
        }
        return builder.toString();
    }

    private /* synthetic */ Mutation lambda$putLeaf$1(VirtualLeafRecord leaf, VirtualKey k, Mutation mutations) {
        return this.mutate(leaf, mutations);
    }

    private static final class Mutation<K, V> {
        private volatile Mutation<K, V> next;
        private final long version;
        private final K key;
        private volatile V value;
        private volatile byte flags = 0;
        private static final int FLAG_BIT_DELETED = 0;
        private static final int FLAG_BIT_FILTERED = 1;

        Mutation(Mutation<K, V> next, K key, V value, long version) {
            this.next = next;
            this.key = key;
            this.value = value;
            this.version = version;
        }

        static boolean getFlag(byte flags, int bit) {
            return (0xFF & flags & 1 << bit) != 0;
        }

        void setFlag(int bit, boolean value) {
            this.flags = value ? (byte)(this.flags | 1 << bit) : (byte)(this.flags & ~(1 << bit));
        }

        boolean isDeleted() {
            return Mutation.getFlag(this.flags, 0);
        }

        void setDeleted(boolean deleted) {
            this.setFlag(0, deleted);
        }

        boolean isFiltered() {
            return Mutation.getFlag(this.flags, 1);
        }

        void setFiltered() {
            this.setFlag(1, true);
        }
    }

    private static final class ClassVersion {
        public static final int ORIGINAL = 1;
        public static final int NO_LEAF_HASHES = 2;

        private ClassVersion() {
        }
    }
}

