/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.consensus;

import com.hedera.hapi.node.base.Transaction;
import com.hedera.hapi.node.transaction.Query;
import com.hedera.hapi.node.transaction.Response;
import com.hedera.hapi.node.transaction.TransactionResponse;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.grpc.Pipeline;
import com.hedera.pbj.runtime.grpc.Pipelines;
import com.hedera.pbj.runtime.grpc.ServiceInterface;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public interface ConsensusServiceInterface
extends ServiceInterface {
    public static final String SERVICE_NAME = "ConsensusService";
    public static final String FULL_NAME = "proto.ConsensusService";

    public TransactionResponse createTopic(Transaction var1);

    public TransactionResponse updateTopic(Transaction var1);

    public TransactionResponse deleteTopic(Transaction var1);

    public TransactionResponse submitMessage(Transaction var1);

    public Response getTopicInfo(Query var1);

    @NonNull
    default public String serviceName() {
        return SERVICE_NAME;
    }

    @NonNull
    default public String fullName() {
        return FULL_NAME;
    }

    @NonNull
    default public List<ServiceInterface.Method> methods() {
        return Arrays.asList(ConsensusServiceMethod.values());
    }

    @NonNull
    default public Pipeline<? super Bytes> open(@NonNull ServiceInterface.Method method, @NonNull ServiceInterface.RequestOptions options, @NonNull Pipeline<? super Bytes> replies) {
        ConsensusServiceMethod m = (ConsensusServiceMethod)method;
        try {
            return switch (m.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> Pipelines.unary().mapRequest(bytes -> this.parseTransaction((Bytes)bytes, options)).method(this::createTopic).mapResponse(reply -> this.serializeTransactionResponse((TransactionResponse)reply, options)).respondTo(replies).build();
                case 1 -> Pipelines.unary().mapRequest(bytes -> this.parseTransaction((Bytes)bytes, options)).method(this::updateTopic).mapResponse(reply -> this.serializeTransactionResponse((TransactionResponse)reply, options)).respondTo(replies).build();
                case 2 -> Pipelines.unary().mapRequest(bytes -> this.parseTransaction((Bytes)bytes, options)).method(this::deleteTopic).mapResponse(reply -> this.serializeTransactionResponse((TransactionResponse)reply, options)).respondTo(replies).build();
                case 3 -> Pipelines.unary().mapRequest(bytes -> this.parseTransaction((Bytes)bytes, options)).method(this::submitMessage).mapResponse(reply -> this.serializeTransactionResponse((TransactionResponse)reply, options)).respondTo(replies).build();
                case 4 -> Pipelines.unary().mapRequest(bytes -> this.parseQuery((Bytes)bytes, options)).method(this::getTopicInfo).mapResponse(reply -> this.serializeResponse((Response)reply, options)).respondTo(replies).build();
            };
        }
        catch (Exception e) {
            replies.onError((Throwable)e);
            return Pipelines.noop();
        }
    }

    @NonNull
    private Transaction parseTransaction(@NonNull Bytes message, @NonNull ServiceInterface.RequestOptions options) throws ParseException {
        Objects.requireNonNull(message);
        Objects.requireNonNull(options);
        if (options.isJson() && !options.isProtobuf()) {
            return (Transaction)Transaction.JSON.parse(message.toReadableSequentialData(), false, 16);
        }
        return (Transaction)Transaction.PROTOBUF.parse(message.toReadableSequentialData(), false, 16);
    }

    @NonNull
    private Query parseQuery(@NonNull Bytes message, @NonNull ServiceInterface.RequestOptions options) throws ParseException {
        Objects.requireNonNull(message);
        Objects.requireNonNull(options);
        if (options.isJson() && !options.isProtobuf()) {
            return (Query)Query.JSON.parse(message.toReadableSequentialData(), false, 16);
        }
        return (Query)Query.PROTOBUF.parse(message.toReadableSequentialData(), false, 16);
    }

    @NonNull
    private Bytes serializeTransactionResponse(@NonNull TransactionResponse reply, @NonNull ServiceInterface.RequestOptions options) {
        Objects.requireNonNull(reply);
        Objects.requireNonNull(options);
        if (options.isJson() && !options.isProtobuf()) {
            return Bytes.wrap((String)TransactionResponse.JSON.toJSON((Object)reply));
        }
        return TransactionResponse.PROTOBUF.toBytes((Object)reply);
    }

    @NonNull
    private Bytes serializeResponse(@NonNull Response reply, @NonNull ServiceInterface.RequestOptions options) {
        Objects.requireNonNull(reply);
        Objects.requireNonNull(options);
        if (options.isJson() && !options.isProtobuf()) {
            return Bytes.wrap((String)Response.JSON.toJSON((Object)reply));
        }
        return Response.PROTOBUF.toBytes((Object)reply);
    }

    public static enum ConsensusServiceMethod implements ServiceInterface.Method
    {
        createTopic,
        updateTopic,
        deleteTopic,
        submitMessage,
        getTopicInfo;

    }
}

