/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.merkledb.test.fixtures;

import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.BufferedData;
import com.swirlds.common.FastCopyable;
import com.swirlds.virtualmap.VirtualKey;
import com.swirlds.virtualmap.serialize.KeySerializer;
import java.io.IOException;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.base.io.streams.SerializableDataOutputStream;

public class ExampleLongKeyFixedSize
implements VirtualKey,
FastCopyable {
    private static final long CLASS_ID = 7980976629655961887L;
    private static final int CURRENT_SERIALIZATION_VERSION = 3054;
    private long value;
    private int hashCode;

    public ExampleLongKeyFixedSize() {
    }

    public ExampleLongKeyFixedSize(long value) {
        this.setValue(value);
    }

    public long getValue() {
        return this.value;
    }

    public void setValue(long value) {
        this.value = value;
        this.hashCode = Long.hashCode(value);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public ExampleLongKeyFixedSize copy() {
        return new ExampleLongKeyFixedSize(this.value);
    }

    public void serialize(SerializableDataOutputStream out) throws IOException {
        out.writeLong(this.value);
    }

    public void deserialize(SerializableDataInputStream in, int dataVersion) throws IOException {
        assert (dataVersion == this.getVersion()) : "dataVersion=" + dataVersion + " != getVersion()=" + this.getVersion();
        this.setValue(in.readLong());
    }

    public long getClassId() {
        return 7980976629655961887L;
    }

    public int getVersion() {
        return 3054;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExampleLongKeyFixedSize)) {
            return false;
        }
        ExampleLongKeyFixedSize that = (ExampleLongKeyFixedSize)o;
        return this.value == that.value;
    }

    public String toString() {
        return "LongVirtualKey{value=" + this.value + ", hashCode=" + this.hashCode + "}";
    }

    public static class Serializer
    implements KeySerializer<ExampleLongKeyFixedSize> {
        private static final long CLASS_ID = 6386345285158235241L;

        public int getSerializedSize() {
            return 8;
        }

        public long getCurrentDataVersion() {
            return 3054L;
        }

        public ExampleLongKeyFixedSize deserialize(ReadableSequentialData in) {
            long value = in.readLong();
            return new ExampleLongKeyFixedSize(value);
        }

        public void serialize(ExampleLongKeyFixedSize data, WritableSequentialData out) {
            out.writeLong(data.getValue());
        }

        public boolean equals(BufferedData buffer, ExampleLongKeyFixedSize keyToCompare) {
            long readKey = buffer.readLong();
            return readKey == keyToCompare.getValue();
        }

        public long getClassId() {
            return 6386345285158235241L;
        }

        public int getVersion() {
            return 1;
        }

        public int hashCode() {
            return super.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof Serializer;
        }

        private static final class ClassVersion {
            public static final int ORIGINAL = 1;

            private ClassVersion() {
            }
        }
    }
}

