/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.crypto;

import com.hedera.hapi.node.state.roster.RosterEntry;
import com.swirlds.platform.state.MerkleNodeState;
import com.swirlds.platform.system.Platform;
import com.swirlds.state.merkle.MerkleStateRoot;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import org.hiero.base.constructable.ConstructableIgnored;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.roster.RosterUtils;

@ConstructableIgnored
public class CryptocurrencyDemoState
extends MerkleStateRoot<CryptocurrencyDemoState>
implements MerkleNodeState {
    private static final long CLASS_ID = 7401358222835466873L;
    private static final int DEFAULT_MAX_ARRAY_SIZE = 8192;
    private static final int DEFAULT_MAX_STRING_SIZE = 128;
    public static final int NUM_STOCKS = 10;
    private static final int MAX_TRADES = 200;
    private String[] tickerSymbol;
    private Map<NodeId, AtomicLong> wallet;
    private Map<NodeId, List<AtomicLong>> shares;
    private String[] trades;
    private int numTradesStored = 0;
    private int lastTradeIndex = 0;
    private long numTrades = 0L;
    private byte[] ask;
    private byte[] bid;
    private NodeId[] askId;
    private NodeId[] bidId;
    private byte[] price;

    public CryptocurrencyDemoState() {
    }

    private CryptocurrencyDemoState(CryptocurrencyDemoState sourceState) {
        super((MerkleStateRoot)sourceState);
        this.tickerSymbol = (String[])sourceState.tickerSymbol.clone();
        this.wallet = new HashMap<NodeId, AtomicLong>(sourceState.wallet);
        this.shares = new HashMap<NodeId, List<AtomicLong>>();
        sourceState.shares.forEach((nodeId, sharesForNode) -> this.shares.put((NodeId)nodeId, new ArrayList(sharesForNode)));
        this.trades = (String[])sourceState.trades.clone();
        this.numTradesStored = sourceState.numTradesStored;
        this.lastTradeIndex = sourceState.lastTradeIndex;
        this.numTrades = sourceState.numTrades;
        this.ask = (byte[])sourceState.ask.clone();
        this.bid = (byte[])sourceState.bid.clone();
        this.askId = (NodeId[])sourceState.askId.clone();
        this.bidId = (NodeId[])sourceState.bidId.clone();
        this.price = (byte[])sourceState.price.clone();
    }

    public synchronized String getTrade(long seq) {
        if (seq > this.numTrades || seq <= this.numTrades - (long)this.numTradesStored) {
            return "";
        }
        return this.trades[(int)(((long)this.lastTradeIndex + seq - this.numTrades + 200L) % 200L)];
    }

    public synchronized void getPriceCopy(byte[] price) {
        for (int i = 0; i < 10; ++i) {
            price[i] = this.price[i];
        }
    }

    public synchronized long getNumTrades() {
        return this.numTrades;
    }

    @NonNull
    public synchronized CryptocurrencyDemoState copy() {
        this.throwIfImmutable();
        this.setImmutable(true);
        return new CryptocurrencyDemoState(this);
    }

    void handleTransaction(NodeId id, int askBid, int tradeStock, int tradePrice) {
        String tradeDescription;
        if (askBid == TransType.ask.ordinal()) {
            if (this.shares.get(id).get(tradeStock).get() == 0L) {
                return;
            }
            if (this.bidId[tradeStock] != null && this.wallet.get(this.bidId[tradeStock]).get() < (long)this.bid[tradeStock]) {
                this.bidId[tradeStock] = null;
            }
            if (this.askId[tradeStock] == null || tradePrice < this.ask[tradeStock]) {
                this.askId[tradeStock] = id;
                this.ask[tradeStock] = (byte)tradePrice;
            }
        } else {
            if (this.shares.get(id).get(tradeStock).get() == 0L) {
                return;
            }
            if (this.askId[tradeStock] != null && this.shares.get(this.askId[tradeStock]).get(tradeStock).get() == 0L) {
                this.askId[tradeStock] = null;
            }
            if (this.bidId[tradeStock] == null || tradePrice > this.bid[tradeStock]) {
                this.bidId[tradeStock] = id;
                this.bid[tradeStock] = (byte)tradePrice;
            }
        }
        if (this.askId[tradeStock] == null || this.bidId[tradeStock] == null || this.ask[tradeStock] > this.bid[tradeStock]) {
            return;
        }
        tradePrice = this.ask[tradeStock] + this.bid[tradeStock];
        tradePrice = tradePrice / 2 + tradePrice % 4 / 3;
        this.wallet.get(this.askId[tradeStock]).addAndGet(tradePrice);
        this.wallet.get(this.bidId[tradeStock]).addAndGet(-tradePrice);
        this.shares.get(this.askId[tradeStock]).get(tradeStock).addAndGet(-1L);
        this.shares.get(this.bidId[tradeStock]).get(tradeStock).addAndGet(1L);
        String selfName = RosterUtils.formatNodeName((long)id.id());
        String sellerNickname = RosterUtils.formatNodeName((long)this.askId[tradeStock].id());
        String buyerNickname = RosterUtils.formatNodeName((long)this.bidId[tradeStock].id());
        int change = tradePrice - this.price[tradeStock];
        double changePerc = 100.0 * (double)change / (double)this.price[tradeStock];
        String dir = change > 0 ? "^" : (change < 0 ? "v" : " ");
        ++this.numTrades;
        this.numTradesStored = Math.min(200, 1 + this.numTradesStored);
        this.lastTradeIndex = (this.lastTradeIndex + 1) % 200;
        this.trades[this.lastTradeIndex] = tradeDescription = String.format("%6d %6s %7.2f %s %4.2f %7.2f%% %7s->%s      %5s has $%-8.2f and shares: %s", this.numTrades, this.tickerSymbol[tradeStock], (double)tradePrice / 100.0, dir, Math.abs((double)change / 100.0), Math.abs(changePerc), sellerNickname, buyerNickname, selfName, (double)this.wallet.get(id).get() / 100.0, this.shares.get(id));
        this.price[tradeStock] = (byte)tradePrice;
        this.askId[tradeStock] = null;
        this.bidId[tradeStock] = null;
    }

    void genesisInit(@NonNull Platform platform) {
        this.tickerSymbol = new String[10];
        this.wallet = new HashMap<NodeId, AtomicLong>();
        this.shares = new HashMap<NodeId, List<AtomicLong>>();
        this.trades = new String[200];
        this.numTradesStored = 0;
        this.lastTradeIndex = 0;
        this.numTrades = 0L;
        this.ask = new byte[10];
        this.bid = new byte[10];
        this.askId = new NodeId[10];
        this.bidId = new NodeId[10];
        this.price = new byte[10];
        Random rand = new Random(0L);
        for (int i = 0; i < 10; ++i) {
            this.tickerSymbol[i] = "" + (char)(65 + rand.nextInt(26)) + (char)(65 + rand.nextInt(26)) + (char)(65 + rand.nextInt(26)) + (char)(65 + rand.nextInt(26));
            this.bidId[i] = null;
            this.askId[i] = null;
            this.price[i] = 64;
            this.bid[i] = 64;
            this.ask[i] = 64;
        }
        for (RosterEntry address : platform.getRoster().rosterEntries()) {
            NodeId id = NodeId.of((long)address.nodeId());
            this.wallet.put(id, new AtomicLong(20000L));
            ArrayList<AtomicLong> sharesForID = new ArrayList<AtomicLong>();
            for (int i = 0; i < 10; ++i) {
                sharesForID.add(new AtomicLong(200L));
            }
            this.shares.put(id, sharesForID);
        }
    }

    public long getClassId() {
        return 7401358222835466873L;
    }

    public int getVersion() {
        return 2;
    }

    public int getMinimumSupportedVersion() {
        return 2;
    }

    protected CryptocurrencyDemoState copyingConstructor() {
        return new CryptocurrencyDemoState(this);
    }

    public static enum TransType {
        slow,
        fast,
        bid,
        ask;

    }

    private static class ClassVersion {
        public static final int ORIGINAL = 1;
        public static final int MIGRATE_TO_SERIALIZABLE = 2;

        private ClassVersion() {
        }
    }
}

