/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.state.service;

import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.platform.state.ConsensusSnapshot;
import com.hedera.hapi.platform.state.PlatformState;
import com.hedera.hapi.util.HapiUtils;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.platform.state.MerkleStateUtils;
import com.swirlds.platform.state.PlatformStateAccessor;
import com.swirlds.platform.state.PlatformStateModifier;
import com.swirlds.platform.state.service.ReadablePlatformStateStore;
import com.swirlds.platform.state.service.SnapshotPlatformStateAccessor;
import com.swirlds.platform.state.service.WritablePlatformStateStore;
import com.swirlds.platform.state.service.schemas.V0540PlatformStateSchema;
import com.swirlds.state.State;
import com.swirlds.state.spi.ReadableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Instant;
import java.util.Objects;
import java.util.function.Consumer;
import org.hiero.base.crypto.Hash;
import org.hiero.consensus.model.hashgraph.Round;

public class PlatformStateFacade {
    public static final PlatformStateFacade DEFAULT_PLATFORM_STATE_FACADE = new PlatformStateFacade();

    public SemanticVersion creationSemanticVersionOf(@NonNull State state) {
        Objects.requireNonNull(state);
        PlatformState platformState = this.platformStateOf(state);
        return platformState == null ? null : platformState.creationSoftwareVersion();
    }

    public boolean isFreezeRound(@NonNull State state, @NonNull Round round) {
        PlatformState platformState = this.platformStateOf(state);
        return PlatformStateFacade.isInFreezePeriod(round.getConsensusTimestamp(), platformState.freezeTime() == null ? null : HapiUtils.asInstant((Timestamp)platformState.freezeTime()), platformState.lastFrozenTime() == null ? null : HapiUtils.asInstant((Timestamp)platformState.lastFrozenTime()));
    }

    public boolean isGenesisStateOf(@NonNull State state) {
        return this.readablePlatformStateStore(state).getRound() == 0L;
    }

    public static boolean isInFreezePeriod(@NonNull Instant consensusTime, @Nullable Instant freezeTime, @Nullable Instant lastFrozenTime) {
        if (freezeTime == null || consensusTime.isBefore(freezeTime)) {
            return false;
        }
        return lastFrozenTime == null || lastFrozenTime.isBefore(freezeTime);
    }

    @Nullable
    public SemanticVersion creationSoftwareVersionOf(@NonNull State state) {
        Objects.requireNonNull(state);
        if (PlatformStateFacade.isPlatformStateEmpty(state)) {
            return null;
        }
        return this.readablePlatformStateStore(state).getCreationSoftwareVersion();
    }

    private static boolean isPlatformStateEmpty(State state) {
        return state.getReadableStates("PlatformStateService").isEmpty();
    }

    public long roundOf(@NonNull State root) {
        Objects.requireNonNull(root);
        return this.readablePlatformStateStore(root).getRound();
    }

    @Nullable
    public PlatformState platformStateOf(@NonNull State state) {
        ReadableStates readableStates = state.getReadableStates("PlatformStateService");
        if (readableStates.isEmpty()) {
            return V0540PlatformStateSchema.UNINITIALIZED_PLATFORM_STATE;
        }
        return (PlatformState)readableStates.getSingleton("PLATFORM_STATE").get();
    }

    @Nullable
    public Hash legacyRunningEventHashOf(@NonNull State state) {
        return this.readablePlatformStateStore(state).getLegacyRunningEventHash();
    }

    public long ancientThresholdOf(@NonNull State state) {
        return this.readablePlatformStateStore(state).getAncientThreshold();
    }

    @Nullable
    public ConsensusSnapshot consensusSnapshotOf(@NonNull State root) {
        return this.readablePlatformStateStore(root).getSnapshot();
    }

    @Nullable
    public SemanticVersion firstVersionInBirthRoundModeOf(@NonNull State state) {
        return this.readablePlatformStateStore(state).getFirstVersionInBirthRoundMode();
    }

    public long lastRoundBeforeBirthRoundModeOf(@NonNull State root) {
        return this.readablePlatformStateStore(root).getLastRoundBeforeBirthRoundMode();
    }

    public long lowestJudgeGenerationBeforeBirthRoundModeOf(@NonNull State state) {
        return this.readablePlatformStateStore(state).getLowestJudgeGenerationBeforeBirthRoundMode();
    }

    @Nullable
    public Instant consensusTimestampOf(@NonNull State state) {
        return this.readablePlatformStateStore(state).getConsensusTimestamp();
    }

    public Instant freezeTimeOf(@NonNull State state) {
        return this.readablePlatformStateStore(state).getFreezeTime();
    }

    public void updateLastFrozenTime(@NonNull State state) {
        this.getWritablePlatformStateOf(state).setLastFrozenTime(this.freezeTimeOf(state));
    }

    @Nullable
    public Instant lastFrozenTimeOf(@NonNull State state) {
        return this.readablePlatformStateStore(state).getLastFrozenTime();
    }

    public long latestFreezeRoundOf(@NonNull State state) {
        return this.readablePlatformStateStore(state).getLatestFreezeRound();
    }

    @NonNull
    protected PlatformStateModifier getWritablePlatformStateOf(@NonNull State state) {
        if (state.isImmutable()) {
            throw new IllegalStateException("Cannot get writable platform state when state is immutable");
        }
        return this.writablePlatformStateStore(state);
    }

    public void bulkUpdateOf(@NonNull State state, @NonNull Consumer<PlatformStateModifier> updater) {
        this.getWritablePlatformStateOf(state).bulkUpdate(updater);
    }

    public void setSnapshotTo(@NonNull State state, @NonNull ConsensusSnapshot snapshot) {
        this.getWritablePlatformStateOf(state).setSnapshot(snapshot);
    }

    public void setLegacyRunningEventHashTo(@NonNull State state, @Nullable Hash legacyRunningEventHash) {
        this.getWritablePlatformStateOf(state).setLegacyRunningEventHash(legacyRunningEventHash);
    }

    public void setCreationSoftwareVersionTo(@NonNull State state, @NonNull SemanticVersion creationVersion) {
        this.getWritablePlatformStateOf(state).setCreationSoftwareVersion(creationVersion);
    }

    @NonNull
    public String getInfoString(@NonNull State state, int hashDepth) {
        return MerkleStateUtils.createInfoString(hashDepth, this.readablePlatformStateStore(state), state.getHash(), (MerkleNode)state);
    }

    private PlatformStateAccessor readablePlatformStateStore(@NonNull State state) {
        ReadableStates readableStates = state.getReadableStates("PlatformStateService");
        if (readableStates.isEmpty()) {
            return new SnapshotPlatformStateAccessor(V0540PlatformStateSchema.UNINITIALIZED_PLATFORM_STATE);
        }
        return new ReadablePlatformStateStore(readableStates);
    }

    private WritablePlatformStateStore writablePlatformStateStore(@NonNull State state) {
        return new WritablePlatformStateStore(state.getWritableStates("PlatformStateService"));
    }
}

