/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.gui.internal;

import com.swirlds.common.metrics.platform.AbstractDistributionMetric;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.metrics.api.Metric;
import com.swirlds.metrics.api.Metrics;
import com.swirlds.platform.gui.GuiConstants;
import com.swirlds.platform.gui.GuiUtils;
import com.swirlds.platform.gui.components.Chart;
import com.swirlds.platform.gui.components.ChartLabelModel;
import com.swirlds.platform.gui.components.PrePaintableJPanel;
import com.swirlds.platform.gui.internal.WinBrowser;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Comparator;
import java.util.IllegalFormatException;
import java.util.List;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class WinTab2Stats
extends PrePaintableJPanel
implements ChartLabelModel {
    private static final long serialVersionUID = 1L;
    public static final int CHART_WIDTH = 750;
    public static final int CHART_HEIGHT = 400;
    private final transient List<Metric> metrics;
    final int numCols = 8;
    private static final Logger logger = LogManager.getLogger(WinTab2Stats.class);
    private JTextArea descriptions;
    private final Color LIGHT_GRAY = new Color(0.9f, 0.9f, 0.9f);
    private JLabel[] statBoxes;
    private JPanel[] charts;
    private JPanel boxesPanel;
    private JPanel chartsPanel;
    private String[] xLabel;
    private double[] xLabelVal;
    private String[] yLabel;
    private double[] yLabelVal;
    private int[] rm2cm;
    private int[] cm2rm;

    public WinTab2Stats(@NonNull Metrics guiMetrics) {
        this.metrics = guiMetrics.getAll().stream().sorted(Comparator.comparing(m -> m.getName().toUpperCase())).toList();
        int numStats = this.metrics.size();
        int numRows = numStats / 8 + (numStats % 8 == 0 ? 0 : 1);
        int lastTall = (numStats - 1 + 8) % 8;
        this.rm2cm = new int[numStats];
        this.cm2rm = new int[numStats];
        int i = 0;
        while (i < numStats) {
            int col;
            int j;
            int row = i / 8;
            this.rm2cm[i] = j = row + col * numRows - ((col = i % 8) - 1 > lastTall ? col - 1 - lastTall : 0);
            this.cm2rm[j] = i++;
        }
    }

    void showChart(int index) {
        int j = this.cm2rm[index];
        this.chartsPanel.add(this.charts[index]);
        this.charts[index].setVisible(true);
        this.statBoxes[j].setBackground(GuiConstants.MEMBER_HIGHLIGHT_COLOR);
        this.revalidate();
    }

    void hideChart(int index) {
        int j = this.cm2rm[index];
        this.chartsPanel.remove(this.charts[index]);
        this.charts[index].setVisible(false);
        this.statBoxes[j].setBackground(Color.WHITE);
        this.revalidate();
    }

    @Override
    public void prePaint() {
        if (WinBrowser.memberDisplayed == null) {
            return;
        }
        if (this.statBoxes != null) {
            return;
        }
        this.boxesPanel = new JPanel(new GridBagLayout());
        this.chartsPanel = new JPanel();
        BoxLayout boxLayout = new BoxLayout(this.chartsPanel, 1);
        this.chartsPanel.setLayout(boxLayout);
        this.setLayout(new GridBagLayout());
        this.boxesPanel.setBackground(Color.WHITE);
        this.chartsPanel.setBackground(Color.WHITE);
        this.setBackground(Color.WHITE);
        JTextArea instructions = GuiUtils.newJTextArea("");
        JTextArea spacer = GuiUtils.newJTextArea("");
        instructions.setText(GuiUtils.wrap(50, "The table shows various statistics about how the system is running. Click on a white square to plot the history of the statistic. Click on a highlighted square to hide that plot. \n\nEach plot shows history divided into periods. Within one period, the blue line goes through the average value during that period. The light gray box shows the min and max value during that period. The dark gray box shows one standard deviation above and below the mean."));
        int numStats = this.metrics.size();
        this.statBoxes = new JLabel[numStats];
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.anchor = 23;
        c.gridx = 0;
        c.gridy = 0;
        this.charts = new JPanel[numStats];
        for (int i = 0; i < numStats; ++i) {
            AbstractDistributionMetric statMetric;
            int j = this.rm2cm[i];
            Metric metric = this.metrics.get(j);
            JLabel txt = new JLabel();
            txt.setToolTipText(metric.getDescription());
            txt.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.BLACK), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            this.statBoxes[i] = txt;
            c.gridx = i % 8;
            c.gridy = i / 8;
            c.gridwidth = 1;
            c.weightx = 0.0;
            this.boxesPanel.add((Component)txt, c);
            if (i % 8 == 7) {
                JTextArea spacer2 = GuiUtils.newJTextArea("");
                ++c.gridx;
                c.weightx = 1.0;
                c.gridwidth = 0;
                this.boxesPanel.add((Component)spacer2, c);
            }
            if (metric instanceof AbstractDistributionMetric && (statMetric = (AbstractDistributionMetric)metric).getStatsBuffered().getAllHistory() != null) {
                this.statBoxes[i].setBackground(Color.WHITE);
                this.statBoxes[i].setOpaque(true);
                this.charts[j] = new JPanel();
                this.charts[j].setBackground(Color.WHITE);
                this.charts[j].add(new Chart(this, 750, 400, false, statMetric.getStatsBuffered(), metric.getName()));
                this.charts[j].add(new Chart(this, 750, 400, true, statMetric.getStatsBuffered(), metric.getName()));
                this.charts[j].setVisible(false);
                final int jj = j;
                this.statBoxes[i].addMouseListener(new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent e) {
                        if (WinTab2Stats.this.charts[jj].isVisible()) {
                            WinTab2Stats.this.hideChart(jj);
                        } else {
                            WinTab2Stats.this.showChart(jj);
                        }
                    }
                });
            } else {
                this.statBoxes[i].setBackground(this.LIGHT_GRAY);
                this.statBoxes[i].setOpaque(true);
            }
            if (!"trans_per_sec".equals(metric.getName())) continue;
            this.showChart(j);
        }
        this.descriptions = GuiUtils.newJTextArea("");
        this.descriptions.setFont(new Font("Monospaced", 0, 14));
        StringBuilder s = new StringBuilder();
        for (Metric metric : this.metrics) {
            s.append(String.format("%17s: %s%n", metric.getName(), metric.getDescription()));
        }
        this.descriptions.setText(s.toString());
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(10, 10, 10, 10);
        this.add((Component)this.boxesPanel, c);
        c.gridy = 1;
        this.add((Component)spacer, c);
        c.gridwidth = 0;
        c.gridx = 1;
        c.gridheight = 2;
        c.gridy = 0;
        this.add((Component)instructions, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridheight = 1;
        this.add((Component)this.chartsPanel, c);
        c.gridy = 3;
        this.add((Component)this.descriptions, c);
        JTextArea spacer2 = GuiUtils.newJTextArea("");
        c.gridy = 4;
        c.weighty = 1.0;
        this.add((Component)spacer2, c);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (WinBrowser.memberDisplayed == null) {
            return;
        }
        for (int i = 0; i < this.statBoxes.length; ++i) {
            int j = this.rm2cm[i];
            this.statBoxes[i].setForeground(Color.BLACK);
            Metric metric = this.metrics.get(j);
            this.statBoxes[i].setText("<html><center>&nbsp;&nbsp;&nbsp;&nbsp;" + metric.getName() + "&nbsp;&nbsp;&nbsp;&nbsp;<br>" + WinTab2Stats.format(metric).trim() + "</center></html>");
            this.statBoxes[i].setHorizontalAlignment(0);
        }
    }

    private static String format(Metric metric) {
        try {
            if (metric == null) {
                return "";
            }
            return String.format(Locale.US, metric.getFormat(), metric.get(Metric.ValueType.VALUE));
        }
        catch (IllegalFormatException e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "unable to compute string for {}", (Object)metric.getName(), (Object)e);
            return "";
        }
    }

    @Override
    public void setYLabels(String[] labels) {
        this.yLabel = labels;
    }

    @Override
    public void setYLabelValues(double[] values) {
        this.yLabelVal = values;
    }

    @Override
    public void setXLabels(String[] labels) {
        this.xLabel = labels;
    }

    @Override
    public void setXLabelValues(double[] values) {
        this.xLabelVal = values;
    }

    @Override
    public String[] getYLabels() {
        return this.yLabel;
    }

    @Override
    public double[] getYLabelValues() {
        return this.yLabelVal;
    }

    @Override
    public String[] getXLabels() {
        return this.xLabel;
    }

    @Override
    public double[] getXLabelValues() {
        return this.xLabelVal;
    }
}

