/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.virtualmerkle.map.smartcontracts.bytecode;

import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.swirlds.demo.virtualmerkle.random.PTTRandom;
import com.swirlds.virtualmap.VirtualValue;
import java.io.IOException;
import java.util.Arrays;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.base.io.streams.SerializableDataOutputStream;

public final class SmartContractByteCodeMapValue
implements VirtualValue {
    public static final int MAX_BYTE_CODE_BYTES = 12000;
    private static final long CLASS_ID = 6080232179761584242L;
    private byte[] byteCode;

    public SmartContractByteCodeMapValue() {
        this.byteCode = new byte[0];
    }

    public SmartContractByteCodeMapValue(SmartContractByteCodeMapValue source) {
        this.byteCode = Arrays.copyOf(source.byteCode, source.byteCode.length);
    }

    public SmartContractByteCodeMapValue(PTTRandom pttRandom, int byteCodeSize) {
        this.byteCode = new byte[byteCodeSize];
        for (int i = 0; i < byteCodeSize; ++i) {
            this.byteCode[i] = pttRandom.nextByte();
        }
    }

    public SmartContractByteCodeMapValue(byte[] bytes) {
        this.byteCode = Arrays.copyOf(bytes, bytes.length);
    }

    public int getSize() {
        return this.byteCode.length;
    }

    public byte[] getByteCode() {
        return this.byteCode;
    }

    public long getClassId() {
        return 6080232179761584242L;
    }

    public int getVersion() {
        return 1;
    }

    public SmartContractByteCodeMapValue copy() {
        return new SmartContractByteCodeMapValue(this);
    }

    public SmartContractByteCodeMapValue asReadOnly() {
        return new SmartContractByteCodeMapValue(this);
    }

    int getSizeInBytes() {
        return 4 + this.byteCode.length;
    }

    public void serialize(SerializableDataOutputStream out) throws IOException {
        out.writeByteArray(this.byteCode);
    }

    void serialize(WritableSequentialData out) {
        out.writeInt(this.byteCode.length);
        out.writeBytes(this.byteCode);
    }

    public void deserialize(SerializableDataInputStream in, int version) throws IOException {
        this.byteCode = in.readByteArray(12000);
    }

    void deserialize(ReadableSequentialData in) {
        int len = in.readInt();
        this.byteCode = new byte[len];
        in.readBytes(this.byteCode);
    }

    public String toString() {
        return "SmartContractByteCodeMapValue{byteCode.length=" + this.byteCode.length + "}";
    }

    private static final class ClassVersion {
        public static final int ORIGINAL = 1;

        private ClassVersion() {
        }
    }
}

