/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.merkle.map;

import com.swirlds.common.merkle.MerkleLeaf;
import com.swirlds.common.merkle.impl.PartialMerkleLeaf;
import com.swirlds.common.merkle.utility.Keyed;
import com.swirlds.merkle.test.fixtures.map.pta.MapKey;
import com.swirlds.merkle.test.fixtures.map.pta.MapValue;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;
import org.hiero.base.crypto.Cryptography;
import org.hiero.base.crypto.CryptographyProvider;
import org.hiero.base.crypto.Hash;
import org.hiero.base.crypto.SerializableHashable;
import org.hiero.base.io.SelfSerializable;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.base.io.streams.SerializableDataOutputStream;

public class MapValueData
extends PartialMerkleLeaf
implements Keyed<MapKey>,
MapValue,
Serializable,
MerkleLeaf {
    private static final Cryptography CRYPTOGRAPHY = CryptographyProvider.getInstance();
    public static final long CLASS_ID = 2336178784194096168L;
    private MapKey key;
    private long balance;
    private long sendThresholdValue;
    private long receiveThresholdValue;
    private boolean receiverSignatureRequired;
    private long uid;

    public MapValueData() {
    }

    public MapValueData(long balance, long sendThresholdValue, long receiveThresholdValue, boolean isReceiverSignatureRequired, long uid) {
        this.balance = balance;
        this.sendThresholdValue = sendThresholdValue;
        this.receiveThresholdValue = receiveThresholdValue;
        this.receiverSignatureRequired = isReceiverSignatureRequired;
        this.uid = uid;
    }

    private MapValueData(MapValueData sourceValue) {
        super((PartialMerkleLeaf)sourceValue);
        this.balance = sourceValue.getBalance();
        this.sendThresholdValue = sourceValue.getSendThresholdValue();
        this.receiveThresholdValue = sourceValue.getReceiveThresholdValue();
        this.receiverSignatureRequired = sourceValue.isReceiverSignatureRequired();
        this.uid = sourceValue.getUid();
        this.setKey(sourceValue.getKey().copy());
        this.setImmutable(false);
        sourceValue.setImmutable(true);
    }

    public MapKey getKey() {
        return this.key;
    }

    public void setKey(MapKey key) {
        this.key = key;
    }

    public long getBalance() {
        return this.balance;
    }

    public void setBalance(long balance) {
        this.invalidateHash();
        this.balance = balance;
    }

    public long getSendThresholdValue() {
        return this.sendThresholdValue;
    }

    public void setSendThresholdValue(long sendThresholdValue) {
        this.invalidateHash();
        this.sendThresholdValue = sendThresholdValue;
    }

    public long getReceiveThresholdValue() {
        return this.receiveThresholdValue;
    }

    public void setReceiveThresholdValue(long receiveThreshold) {
        this.invalidateHash();
        this.receiveThresholdValue = receiveThreshold;
    }

    public boolean isReceiverSignatureRequired() {
        return this.receiverSignatureRequired;
    }

    public void setReceiverSignatureRequired(boolean required) {
        this.invalidateHash();
        this.receiverSignatureRequired = required;
    }

    public Hash calculateHash() {
        if (this.getHash() != null) {
            return this.getHash();
        }
        CRYPTOGRAPHY.digestSync((SerializableHashable)this);
        return this.getHash();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        MapValueData that = (MapValueData)other;
        return this.balance == that.balance && this.sendThresholdValue == that.sendThresholdValue && this.receiveThresholdValue == that.receiveThresholdValue && this.receiverSignatureRequired == that.receiverSignatureRequired && this.uid == that.uid;
    }

    public int hashCode() {
        return Objects.hash(this.balance, this.sendThresholdValue, this.receiveThresholdValue, this.receiverSignatureRequired, this.uid);
    }

    public String toString() {
        return "MapValue{balance=" + this.balance + ", sendThresholdValue=" + this.sendThresholdValue + ", receiveThresholdValue=" + this.receiveThresholdValue + ", receiverSignatureRequired=" + this.receiverSignatureRequired + "}";
    }

    public MapValueData copy() {
        this.throwIfImmutable();
        return new MapValueData(this);
    }

    public void serialize(SerializableDataOutputStream outStream) throws IOException {
        outStream.writeLong(this.balance);
        outStream.writeLong(this.sendThresholdValue);
        outStream.writeLong(this.receiveThresholdValue);
        outStream.writeBoolean(this.receiverSignatureRequired);
        outStream.writeLong(this.uid);
        outStream.writeSerializable((SelfSerializable)this.key, false);
    }

    public void deserialize(SerializableDataInputStream inStream, int version) throws IOException {
        this.balance = inStream.readLong();
        this.sendThresholdValue = inStream.readLong();
        this.receiveThresholdValue = inStream.readLong();
        this.receiverSignatureRequired = inStream.readBoolean();
        if (version == 2) {
            this.uid = inStream.readLong();
        }
        this.key = (MapKey)inStream.readSerializable(false, MapKey::new);
    }

    public long getClassId() {
        return 2336178784194096168L;
    }

    public int getVersion() {
        return 2;
    }

    public long getUid() {
        return this.uid;
    }

    private static class ClassVersion {
        public static final int ORIGINAL = 1;
        public static final int UID = 2;

        private ClassVersion() {
        }
    }
}

