/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.block.stream.trace.codec;

import com.hedera.hapi.block.stream.trace.ContractSlotUsage;
import com.hedera.hapi.block.stream.trace.SlotRead;
import com.hedera.hapi.block.stream.trace.schema.ContractSlotUsageSchema;
import com.hedera.hapi.node.base.ContractID;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ContractSlotUsageJsonCodec
implements JsonCodec<ContractSlotUsage> {
    @NonNull
    public ContractSlotUsage parse(@Nullable JSONParser.ObjContext root, boolean strictMode, int maxDepth) throws ParseException {
        if (maxDepth < 0) {
            throw new ParseException("Reached maximum allowed depth of nested messages");
        }
        try {
            ContractID temp_contract_id = null;
            List<Bytes> temp_written_slot_keys = Collections.emptyList();
            List temp_slot_reads = Collections.emptyList();
            block12: for (JSONParser.PairContext kvPair : root.pair()) {
                switch (kvPair.STRING().getText()) {
                    case "contractId": {
                        temp_contract_id = (ContractID)ContractID.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1);
                        continue block12;
                    }
                    case "writtenSlotKeys": {
                        temp_written_slot_keys = kvPair.value().arr().value().stream().map(v -> Bytes.fromBase64((String)v.STRING().getText())).toList();
                        continue block12;
                    }
                    case "slotReads": {
                        temp_slot_reads = JsonTools.parseObjArray((JSONParser.ArrContext)kvPair.value().arr(), SlotRead.JSON, (int)(maxDepth - 1));
                        continue block12;
                    }
                }
                if (!strictMode) continue;
                throw new UnknownFieldException(kvPair.STRING().getText());
            }
            return new ContractSlotUsage(temp_contract_id, temp_written_slot_keys, temp_slot_reads);
        }
        catch (Exception ex) {
            throw new ParseException((Throwable)ex);
        }
    }

    public String toJSON(@NonNull ContractSlotUsage data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.contractId() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"contractId", ContractID.JSON, (Object)data.contractId()));
        }
        if (!data.writtenSlotKeys().isEmpty()) {
            fieldLines.add(JsonTools.arrayField((String)"writtenSlotKeys", (FieldDefinition)ContractSlotUsageSchema.WRITTEN_SLOT_KEYS, data.writtenSlotKeys()));
        }
        if (!data.slotReads().isEmpty()) {
            fieldLines.add(JsonTools.arrayField((String)childIndent, (String)"slotReads", SlotRead.JSON, data.slotReads()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

