/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.gui;

import com.hedera.hapi.platform.event.GossipEvent;
import com.hedera.hapi.platform.state.ConsensusSnapshot;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.config.api.Configuration;
import com.swirlds.platform.Consensus;
import com.swirlds.platform.ConsensusImpl;
import com.swirlds.platform.consensus.ConsensusConfig;
import com.swirlds.platform.consensus.RoundCalculationUtils;
import com.swirlds.platform.event.linking.SimpleLinker;
import com.swirlds.platform.gui.BranchedEventMetadata;
import com.swirlds.platform.internal.EventImpl;
import com.swirlds.platform.metrics.NoOpConsensusMetrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.hashgraph.ConsensusRound;
import org.hiero.consensus.model.roster.AddressBook;
import org.hiero.consensus.roster.RosterRetriever;

public class GuiEventStorage {
    private long maxGeneration = 0L;
    private final Consensus consensus;
    private final SimpleLinker linker;
    private final Configuration configuration;
    private ConsensusRound lastConsensusRound;
    private Map<GossipEvent, BranchedEventMetadata> branchedEventsMetadata = new HashMap<GossipEvent, BranchedEventMetadata>();

    public GuiEventStorage(@NonNull Configuration configuration, @NonNull AddressBook addressBook) {
        this.configuration = Objects.requireNonNull(configuration);
        PlatformContext platformContext = PlatformContext.create((Configuration)configuration);
        this.consensus = new ConsensusImpl(platformContext, new NoOpConsensusMetrics(), RosterRetriever.buildRoster((AddressBook)addressBook));
        this.linker = new SimpleLinker();
    }

    public GuiEventStorage(@NonNull Consensus consensus, @NonNull SimpleLinker linker, @NonNull Configuration configuration) {
        this.consensus = consensus;
        this.linker = linker;
        this.configuration = configuration;
        this.maxGeneration = linker.getNonAncientEvents().stream().mapToLong(EventImpl::getNGen).max().orElse(0L);
    }

    @NonNull
    public Consensus getConsensus() {
        return this.consensus;
    }

    public synchronized void handlePreconsensusEvent(@NonNull PlatformEvent event) {
        this.maxGeneration = Math.max(this.maxGeneration, event.getGeneration());
        EventImpl eventImpl = this.linker.linkEvent(event.copyGossipedData());
        if (eventImpl == null) {
            return;
        }
        eventImpl.getBaseEvent().setNGen(event.getNGen());
        List<ConsensusRound> rounds = this.consensus.addEvent(eventImpl);
        if (rounds.isEmpty()) {
            return;
        }
        this.lastConsensusRound = rounds.getLast();
        this.linker.setNonAncientThreshold(rounds.getLast().getEventWindow().ancientThreshold());
    }

    public synchronized void handleSnapshotOverride(@NonNull ConsensusSnapshot snapshot) {
        this.consensus.loadSnapshot(snapshot);
        this.linker.clear();
        this.linker.setNonAncientThreshold(RoundCalculationUtils.getAncientThreshold(((ConsensusConfig)this.configuration.getConfigData(ConsensusConfig.class)).roundsNonAncient(), snapshot));
        this.lastConsensusRound = null;
    }

    public synchronized long getMaxGeneration() {
        return this.maxGeneration;
    }

    @NonNull
    public synchronized List<EventImpl> getNonAncientEvents() {
        return this.linker.getNonAncientEvents();
    }

    @Nullable
    public synchronized ConsensusRound getLastConsensusRound() {
        return this.lastConsensusRound;
    }

    @NonNull
    public Map<GossipEvent, BranchedEventMetadata> getBranchedEventsMetadata() {
        return this.branchedEventsMetadata;
    }

    public void setBranchedEventsMetadata(@NonNull Map<GossipEvent, BranchedEventMetadata> branchedEventsMetadata) {
        this.branchedEventsMetadata = branchedEventsMetadata;
    }
}

