/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.event.preconsensus;

import com.swirlds.base.time.Time;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.event.preconsensus.PcesConfig;
import com.swirlds.platform.event.preconsensus.PcesFile;
import com.swirlds.platform.event.preconsensus.PcesFileTracker;
import com.swirlds.platform.event.preconsensus.PcesMetrics;
import com.swirlds.platform.event.preconsensus.PcesMutableFile;
import com.swirlds.platform.event.preconsensus.PcesUtilities;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PcesFileManager {
    private static final Logger logger = LogManager.getLogger(PcesFileManager.class);
    public static final long NO_LOWER_BOUND = -1L;
    private final Time time;
    private final PcesMetrics metrics;
    private final Path databaseDirectory;
    private long currentOrigin;
    private final Duration minimumRetentionPeriod;
    private long totalFileByteCount = 0L;
    private final PcesFileTracker files;

    public PcesFileManager(@NonNull PlatformContext platformContext, @NonNull PcesFileTracker files, @NonNull Path databaseDirectory, long startingRound) throws IOException {
        Objects.requireNonNull(platformContext);
        if (startingRound < 0L) {
            throw new IllegalArgumentException("starting round must be non-negative");
        }
        PcesConfig preconsensusEventStreamConfig = (PcesConfig)platformContext.getConfiguration().getConfigData(PcesConfig.class);
        this.time = platformContext.getTime();
        this.files = Objects.requireNonNull(files);
        this.metrics = new PcesMetrics(platformContext.getMetrics());
        this.minimumRetentionPeriod = preconsensusEventStreamConfig.minimumRetentionPeriod();
        this.databaseDirectory = Objects.requireNonNull(databaseDirectory);
        this.currentOrigin = PcesUtilities.getInitialOrigin(files, startingRound);
        this.initializeMetrics();
    }

    private void initializeMetrics() throws IOException {
        this.totalFileByteCount = this.files.getTotalFileByteCount();
        if (this.files.getFileCount() > 0) {
            this.metrics.getPreconsensusEventFileOldestIdentifier().set(this.files.getFirstFile().getLowerBound());
            this.metrics.getPreconsensusEventFileYoungestIdentifier().set(this.files.getLastFile().getUpperBound());
            Duration age = Duration.between(this.files.getFirstFile().getTimestamp(), this.time.now());
            this.metrics.getPreconsensusEventFileOldestSeconds().set(age.toSeconds());
        } else {
            this.metrics.getPreconsensusEventFileOldestIdentifier().set(-1L);
            this.metrics.getPreconsensusEventFileYoungestIdentifier().set(-1L);
            this.metrics.getPreconsensusEventFileOldestSeconds().set(0L);
        }
        this.updateFileSizeMetrics();
    }

    private long getNextSequenceNumber() {
        if (this.files.getFileCount() == 0) {
            return 0L;
        }
        return this.files.getLastFile().getSequenceNumber() + 1L;
    }

    public void registerDiscontinuity(long newOriginRound) {
        if (newOriginRound <= this.currentOrigin) {
            throw new IllegalArgumentException("New origin round must be greater than the current origin round. Current origin round: " + this.currentOrigin + ", new origin round: " + newOriginRound);
        }
        PcesFile lastFile = this.files.getFileCount() > 0 ? this.files.getLastFile() : null;
        logger.info(LogMarker.STARTUP.getMarker(), "Due to recent operations on this node, the local preconsensus event stream will have a discontinuity. The last file with the old origin round is {}. All future files will have an origin round of {}.", (Object)lastFile, (Object)newOriginRound);
        this.currentOrigin = newOriginRound;
    }

    @NonNull
    public PcesFile getNextFileDescriptor(long lowerBound, long upperBound) {
        long upperBoundForFile;
        long lowerBoundForFile;
        if (lowerBound > upperBound) {
            throw new IllegalArgumentException("lower bound must be less than or equal to the upper bound");
        }
        if (this.files.getFileCount() == 0) {
            lowerBoundForFile = lowerBound;
            upperBoundForFile = upperBound;
        } else {
            lowerBoundForFile = Math.max(lowerBound, this.files.getLastFile().getLowerBound());
            upperBoundForFile = Math.max(upperBound, this.files.getLastFile().getUpperBound());
        }
        PcesFile descriptor = PcesFile.of(this.time.now(), this.getNextSequenceNumber(), lowerBoundForFile, upperBoundForFile, this.currentOrigin, this.databaseDirectory);
        if (this.files.getFileCount() > 0) {
            PcesFile previousFile = this.files.getLastFile();
            PcesUtilities.fileSanityChecks(false, previousFile.getSequenceNumber(), previousFile.getLowerBound(), previousFile.getUpperBound(), this.currentOrigin, previousFile.getTimestamp(), descriptor);
        }
        this.files.addFile(descriptor);
        this.metrics.getPreconsensusEventFileYoungestIdentifier().set(descriptor.getUpperBound());
        return descriptor;
    }

    public void finishedWritingFile(@NonNull PcesMutableFile file) {
        long previousFileUpperBound = this.files.getFileCount() == 1 ? 0L : this.files.getFile(this.files.getFileCount() - 2).getUpperBound();
        PcesFile compressedDescriptor = file.compressSpan(previousFileUpperBound);
        this.files.setFile(this.files.getFileCount() - 1, compressedDescriptor);
        this.totalFileByteCount += file.fileSize();
        this.metrics.getPreconsensusEventFileRate().cycle();
        this.metrics.getPreconsensusEventAverageFileSpan().update((double)file.getSpan());
        this.metrics.getPreconsensusEventAverageUnUtilizedFileSpan().update((double)file.getUnUtilizedSpan());
        this.updateFileSizeMetrics();
    }

    public void pruneOldFiles(long lowerBoundToKeep) throws IOException {
        Instant minimumTimestamp = this.time.now().minus(this.minimumRetentionPeriod);
        while (this.files.getFileCount() > 0 && this.files.getFirstFile().getUpperBound() < lowerBoundToKeep && this.files.getFirstFile().getTimestamp().isBefore(minimumTimestamp)) {
            PcesFile file = this.files.removeFirstFile();
            this.totalFileByteCount -= Files.size(file.getPath());
            file.deleteFile(this.databaseDirectory);
        }
        if (this.files.getFileCount() > 0) {
            this.metrics.getPreconsensusEventFileOldestIdentifier().set(this.files.getFirstFile().getLowerBound());
            Duration age = Duration.between(this.files.getFirstFile().getTimestamp(), this.time.now());
            this.metrics.getPreconsensusEventFileOldestSeconds().set(age.toSeconds());
        }
        this.updateFileSizeMetrics();
    }

    private void updateFileSizeMetrics() {
        this.metrics.getPreconsensusEventFileCount().set((long)this.files.getFileCount());
        this.metrics.getPreconsensusEventFileTotalSizeGB().set((double)this.totalFileByteCount * 9.313225746154785E-10);
        if (this.files.getFileCount() > 0) {
            this.metrics.getPreconsensusEventFileAverageSizeMB().set((double)this.totalFileByteCount / (double)this.files.getFileCount() * 9.5367431640625E-7);
        }
    }
}

